/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer.util;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.pdf.PdfRenderer;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import com.rajat.pdfviewer.util.CacheHelper;
import com.rajat.pdfviewer.util.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\u001e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J\u001a\u0010\u001c\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0005J2\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\r0#J\u0018\u0010$\u001a\u00020%2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0007H\u0086@\u00a2\u0006\u0002\u0010&J\u0018\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00012\b\b\u0002\u0010)\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/rajat/pdfviewer/util/FileUtils;", "", "<init>", "()V", "TAG", "", "fileFromAsset", "Ljava/io/File;", "context", "Landroid/content/Context;", "assetName", "(Landroid/content/Context;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "copy", "", "inputStream", "Ljava/io/InputStream;", "output", "uriToFile", "uri", "Landroid/net/Uri;", "(Landroid/content/Context;Landroid/net/Uri;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createPdfDocumentUri", "contentResolver", "Landroid/content/ContentResolver;", "fileName", "(Landroid/content/ContentResolver;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCachedFileName", "url", "clearPdfCache", "exceptFileName", "writeFile", "file", "totalLength", "", "onProgress", "Lkotlin/Function1;", "isValidPdf", "", "(Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cachedFileNameWithFormat", "name", "format", "pdfViewer_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\ncom/rajat/pdfviewer/util/FileUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,136:1\n1#2:137\n13472#3,2:138\n*S KotlinDebug\n*F\n+ 1 FileUtils.kt\ncom/rajat/pdfviewer/util/FileUtils\n*L\n73#1:138,2\n*E\n"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    @NotNull
    private static final String TAG = "PdfValidator";
    public static final int $stable;

    private FileUtils() {
    }

    @Nullable
    public final Object fileFromAsset(@NotNull Context context, @NotNull String assetName, @NotNull Continuation<? super File> $completion) throws IOException {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super File>, Object>(context, assetName, null){
            int label;
            final /* synthetic */ Context $context;
            final /* synthetic */ String $assetName;
            {
                this.$context = $context;
                this.$assetName = $assetName;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        File outFile = new File(this.$context.getCacheDir(), this.$assetName);
                        if (StringsKt.contains$default((CharSequence)this.$assetName, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            File file = outFile.getParentFile();
                            if (file != null) {
                                Boxing.boxBoolean((boolean)file.mkdirs());
                            }
                        }
                        InputStream inputStream = this.$context.getAssets().open(this.$assetName);
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"open(...)");
                        FileUtils.INSTANCE.copy(inputStream, outFile);
                        return outFile;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super File> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copy(@NotNull InputStream inputStream, @NotNull File output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileOutputStream(output);
            Throwable throwable2 = null;
            try {
                FileOutputStream outputStream = (FileOutputStream)closeable2;
                boolean bl2 = false;
                byte[] buffer = new byte[1024];
                int read = 0;
                while (true) {
                    int n;
                    int it = n = input.read(buffer);
                    boolean bl3 = false;
                    read = it;
                    if (n == -1) break;
                    outputStream.write(buffer, 0, read);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object uriToFile(@NotNull Context var1_1, @NotNull Uri var2_2, @NotNull Continuation<? super File> $completion) {
        if (!($completion instanceof uriToFile.1)) ** GOTO lbl-1000
        var5_4 = $completion;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ FileUtils this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.uriToFile(null, null, (Continuation<? super File>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super File>, Object>((Context)context, (Uri)uri, null){
                    int label;
                    final /* synthetic */ Context $context;
                    final /* synthetic */ Uri $uri;
                    {
                        this.$context = $context;
                        this.$uri = $uri;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                InputStream inputStream = this.$context.getContentResolver().openInputStream(this.$uri);
                                if (inputStream == null) {
                                    throw new IOException("Failed to open URI: " + this.$uri);
                                }
                                InputStream inputStream2 = inputStream;
                                File tempFile = File.createTempFile("pdf_temp", ".pdf", this.$context.getCacheDir());
                                Closeable closeable = inputStream2;
                                Throwable throwable = null;
                                try {
                                    InputStream it = (InputStream)closeable;
                                    boolean bl = false;
                                    Intrinsics.checkNotNull((Object)tempFile);
                                    long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)new FileOutputStream(tempFile), (int)0, (int)2, null);
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                }
                                return tempFile;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super File> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"withContext(...)");
                return v0;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object createPdfDocumentUri(@NotNull ContentResolver contentResolver, @NotNull String fileName, @NotNull Continuation<? super Uri> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Uri>, Object>(contentResolver, fileName, null){
            int label;
            final /* synthetic */ ContentResolver $contentResolver;
            final /* synthetic */ String $fileName;
            {
                this.$contentResolver = $contentResolver;
                this.$fileName = $fileName;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ContentValues contentValues = new ContentValues();
                        String string2 = this.$fileName;
                        ContentValues $this$invokeSuspend_u24lambda_u240 = contentValues;
                        boolean bl = false;
                        $this$invokeSuspend_u24lambda_u240.put("_display_name", string2);
                        $this$invokeSuspend_u24lambda_u240.put("mime_type", "application/pdf");
                        if (Build.VERSION.SDK_INT >= 29) {
                            $this$invokeSuspend_u24lambda_u240.put("relative_path", Environment.DIRECTORY_DOCUMENTS);
                        }
                        ContentValues contentValues2 = contentValues;
                        Uri uri = this.$contentResolver.insert(MediaStore.Files.getContentUri((String)"external"), contentValues2);
                        if (uri == null) {
                            throw new IOException("Failed to create new MediaStore record.");
                        }
                        return uri;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Uri> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public final String getCachedFileName(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return CacheHelper.INSTANCE.getCacheKey(url) + ".pdf";
    }

    /*
     * WARNING - void declaration
     */
    public final void clearPdfCache(@NotNull Context context, @Nullable String exceptFileName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File cacheDir = context.getCacheDir();
        File[] fileArray = cacheDir.listFiles((arg_0, arg_1) -> FileUtils.clearPdfCache$lambda$3(exceptFileName, arg_0, arg_1));
        if (fileArray != null) {
            void $this$forEach$iv;
            File[] fileArray2 = fileArray;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv;
                void it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.delete();
            }
        }
    }

    public static /* synthetic */ void clearPdfCache$default(FileUtils fileUtils, Context context, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        fileUtils.clearPdfCache(context, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeFile(@NotNull InputStream inputStream, @NotNull File file, long totalLength, @NotNull Function1<? super Long, Unit> onProgress) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(onProgress, (String)"onProgress");
        Closeable closeable = new FileOutputStream(file);
        Throwable throwable = null;
        try {
            FileOutputStream outputStream = (FileOutputStream)closeable;
            boolean bl = false;
            byte[] data = new byte[8192];
            long totalBytesRead = 0L;
            int bytesRead = 0;
            while (true) {
                int n;
                int it = n = inputStream.read(data);
                boolean bl2 = false;
                bytesRead = it;
                if (n == -1) break;
                outputStream.write(data, 0, bytesRead);
                totalBytesRead += (long)bytesRead;
                try {
                    onProgress.invoke((Object)totalBytesRead);
                }
                catch (Exception e) {
                    Log.w((String)TAG, (String)("Progress callback failed: " + e.getMessage()), (Throwable)e);
                }
            }
            outputStream.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    public final Object isValidPdf(@Nullable File file, @NotNull Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(file, null){
            int label;
            final /* synthetic */ File $file;
            {
                this.$file = $file;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean bl;
                        ResultKt.throwOnFailure((Object)object);
                        if (this.$file == null || !this.$file.exists() || this.$file.length() < 4L) {
                            Log.e((String)"PdfValidator", (String)"Validation failed: File is null, does not exist, or is too small.");
                            return Boxing.boxBoolean((boolean)false);
                        }
                        try {
                            boolean bl2;
                            Closeable closeable = new FileInputStream(this.$file);
                            File file = this.$file;
                            Throwable throwable = null;
                            try {
                                FileInputStream inputStream = (FileInputStream)closeable;
                                boolean bl3 = false;
                                byte[] buffer = new byte[1024];
                                int bytesRead = inputStream.read(buffer);
                                if (bytesRead == -1) {
                                    Log.e((String)"PdfValidator", (String)"Validation failed: Unable to read file content.");
                                    Boolean bl4 = Boxing.boxBoolean((boolean)false);
                                    return bl4;
                                }
                                String pdfContent = new String(buffer, Charsets.US_ASCII);
                                int pdfIndex = StringsKt.indexOf$default((CharSequence)pdfContent, (String)"%PDF", (int)0, (boolean)false, (int)6, null);
                                if (pdfIndex == -1) {
                                    Log.e((String)"PdfValidator", (String)"Validation failed: `%PDF` signature not found in first 1024 bytes.");
                                    Boolean bl5 = Boxing.boxBoolean((boolean)false);
                                    return bl5;
                                }
                                Log.d((String)"PdfValidator", (String)("PDF signature found at byte offset: " + pdfIndex));
                                Closeable closeable2 = (Closeable)ParcelFileDescriptor.open((File)file, (int)0x10000000);
                                Throwable throwable2 = null;
                                try {
                                    int n;
                                    ParcelFileDescriptor pfd = (ParcelFileDescriptor)closeable2;
                                    boolean bl6 = false;
                                    AutoCloseable autoCloseable = (AutoCloseable)new PdfRenderer(pfd);
                                    Throwable throwable3 = null;
                                    try {
                                        PdfRenderer renderer = (PdfRenderer)autoCloseable;
                                        boolean bl7 = false;
                                        if (renderer.getPageCount() <= 0) {
                                            Log.e((String)"PdfValidator", (String)"Validation failed: PDF has no pages.");
                                            Boolean bl8 = Boxing.boxBoolean((boolean)false);
                                            Boolean bl9 = bl8;
                                            Boolean bl10 = bl9;
                                            return bl10;
                                        }
                                        n = Log.d((String)"PdfValidator", (String)("Validation successful: PDF is valid with " + renderer.getPageCount() + " pages."));
                                    }
                                    catch (Throwable throwable4) {
                                        throwable3 = throwable4;
                                        throw throwable4;
                                    }
                                    finally {
                                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable3);
                                    }
                                    int n2 = n;
                                }
                                catch (Throwable throwable5) {
                                    throwable2 = throwable5;
                                    throw throwable5;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                                }
                                bl2 = true;
                            }
                            catch (Throwable throwable6) {
                                throwable = throwable6;
                                throw throwable6;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            bl = bl2;
                        }
                        catch (Exception e) {
                            Log.e((String)"PdfValidator", (String)("Validation failed: " + e.getMessage()), (Throwable)e);
                            bl = false;
                        }
                        return Boxing.boxBoolean((bl ? 1 : 0) != 0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public final String cachedFileNameWithFormat(@NotNull Object name, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return name + format;
    }

    public static /* synthetic */ String cachedFileNameWithFormat$default(FileUtils fileUtils, Object object, String string2, int n, Object object2) {
        if ((n & 2) != 0) {
            string2 = ".jpg";
        }
        return fileUtils.cachedFileNameWithFormat(object, string2);
    }

    private static final boolean clearPdfCache$lambda$3(String $exceptFileName, File file, String name) {
        Intrinsics.checkNotNull((Object)name);
        return StringsKt.endsWith$default((String)name, (String)".pdf", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)name, (Object)$exceptFileName);
    }
}

