/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer;

import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import android.widget.Toast;
import androidx.activity.ComponentActivity;
import androidx.activity.EdgeToEdge;
import androidx.activity.SystemBarStyle;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleCoroutineScope;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.ViewModelLazy;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.google.android.material.appbar.MaterialToolbar;
import com.rajat.pdfviewer.HeaderData;
import com.rajat.pdfviewer.PdfRendererView;
import com.rajat.pdfviewer.PdfViewerActivity;
import com.rajat.pdfviewer.PdfViewerViewModel;
import com.rajat.pdfviewer.R;
import com.rajat.pdfviewer.databinding.ActivityPdfViewerBinding;
import com.rajat.pdfviewer.util.CacheStrategy;
import com.rajat.pdfviewer.util.EdgeToEdgeHelper;
import com.rajat.pdfviewer.util.FileUtils;
import com.rajat.pdfviewer.util.NetworkUtil;
import com.rajat.pdfviewer.util.ThemeValidator;
import com.rajat.pdfviewer.util.ToolbarStyle;
import com.rajat.pdfviewer.util.ToolbarTitleBehavior;
import com.rajat.pdfviewer.util.ViewerStrings;
import com.rajat.pdfviewer.util.ViewerStyle;
import com.rajat.pdfviewer.util.saveTo;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0007\u0018\u0000 M2\u00020\u0001:\u0001MB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020&H\u0002J\b\u0010*\u001a\u00020&H\u0002J\b\u0010+\u001a\u00020&H\u0002J\b\u0010,\u001a\u00020&H\u0002J\b\u0010-\u001a\u00020&H\u0002J\u0012\u0010.\u001a\u00020&2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010/\u001a\u00020&2\b\u00100\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u00101\u001a\u00020\u0015H\u0007J\u0010\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u000204H\u0002J\u0012\u00105\u001a\u00020&2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u00106\u001a\u00020&2\b\u00107\u001a\u0004\u0018\u000108H\u0014J\u0010\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020&H\u0014J\u0010\u0010=\u001a\u00020\u00152\u0006\u0010>\u001a\u00020\u0017H\u0016J\u0010\u0010?\u001a\u00020&2\u0006\u0010@\u001a\u00020\u000bH\u0002J\u0010\u0010A\u001a\u00020&2\u0006\u0010B\u001a\u00020\u000bH\u0002J\b\u0010C\u001a\u00020&H\u0002J\u0018\u0010D\u001a\u00020&2\u0006\u00100\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020\u000bH\u0002J\u0018\u0010E\u001a\u00020&2\u0006\u00100\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020\u000bH\u0002J\u0018\u0010F\u001a\u00020&2\u0006\u0010G\u001a\u00020\u000b2\u0006\u0010H\u001a\u00020\u0015H\u0002J\b\u0010I\u001a\u00020&H\u0002J\u0010\u0010J\u001a\u00020&2\u0006\u0010K\u001a\u00020\u0015H\u0002J\f\u0010L\u001a\u00020&*\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"\u00a8\u0006N"}, d2={"Lcom/rajat/pdfviewer/PdfViewerActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "binding", "Lcom/rajat/pdfviewer/databinding/ActivityPdfViewerBinding;", "cacheStrategy", "Lcom/rajat/pdfviewer/util/CacheStrategy;", "createFileLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "downloadedFilePath", "", "error_no_internet_connection", "error_pdf_corrupted", "fileUrl", "file_not_downloaded_yet", "file_saved_successfully", "file_saved_to_downloads", "headers", "Lcom/rajat/pdfviewer/HeaderData;", "isDownloadButtonEnabled", "", "menuItem", "Landroid/view/MenuItem;", "pdf_viewer_cancel", "pdf_viewer_error", "pdf_viewer_grant", "pdf_viewer_retry", "permission_required", "permission_required_title", "requestPermissionLauncher", "viewModel", "Lcom/rajat/pdfviewer/PdfViewerViewModel;", "getViewModel", "()Lcom/rajat/pdfviewer/PdfViewerViewModel;", "viewModel$delegate", "Lkotlin/Lazy;", "applyEdgeToEdge", "", "window", "Landroid/view/Window;", "applyThemeAttributes", "checkAndStartDownload", "configureToolbar", "extractIntentExtras", "init", "initPdfViewer", "initPdfViewerWithPath", "filePath", "isDownloadButtonVisible", "isRetryable", "error", "", "loadFileFromNetwork", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "onDestroy", "onOptionsItemSelected", "item", "onPdfError", "e", "promptUserForLocation", "fileName", "requestStoragePermission", "saveFileToPublicDirectoryLegacy", "saveFileToPublicDirectoryScopedStorage", "showErrorDialog", "message", "shouldRetry", "startDownload", "updateDownloadButtonState", "isEnabled", "showProgressBar", "Companion", "pdfViewer_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPdfViewerActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfViewerActivity.kt\ncom/rajat/pdfviewer/PdfViewerActivity\n+ 2 ActivityViewModelLazy.kt\nandroidx/activity/ActivityViewModelLazyKt\n*L\n1#1,525:1\n70#2,11:526\n*S KotlinDebug\n*F\n+ 1 PdfViewerActivity.kt\ncom/rajat/pdfviewer/PdfViewerActivity\n*L\n70#1:526,11\n*E\n"})
public final class PdfViewerActivity
extends AppCompatActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private String file_not_downloaded_yet;
    private String file_saved_to_downloads;
    private String file_saved_successfully;
    private String error_no_internet_connection;
    private String permission_required;
    private String permission_required_title;
    private String error_pdf_corrupted;
    private String pdf_viewer_retry;
    private String pdf_viewer_grant;
    private String pdf_viewer_cancel;
    private String pdf_viewer_error;
    @Nullable
    private MenuItem menuItem;
    @Nullable
    private String fileUrl;
    private HeaderData headers;
    private ActivityPdfViewerBinding binding;
    @NotNull
    private final Lazy viewModel$delegate;
    @Nullable
    private String downloadedFilePath;
    private boolean isDownloadButtonEnabled;
    private CacheStrategy cacheStrategy;
    @NotNull
    private final ActivityResultLauncher<String> requestPermissionLauncher;
    @NotNull
    private final ActivityResultLauncher<Intent> createFileLauncher;
    public static final int $stable = 8;
    @NotNull
    public static final String FILE_URL = "pdf_file_url";
    @NotNull
    public static final String FILE_TITLE = "pdf_file_title";
    @NotNull
    public static final String ENABLE_FILE_DOWNLOAD = "enable_download";
    @NotNull
    public static final String FROM_ASSETS = "from_assests";
    @NotNull
    public static final String TITLE_BEHAVIOR = "title_behavior";
    @NotNull
    public static final String ENABLE_ZOOM = "enable_zoom";
    private static boolean enableDownload;
    private static boolean isPDFFromPath;
    private static boolean isFromAssets;
    private static boolean SAVE_TO_DOWNLOADS;
    private static boolean isZoomEnabled;
    @NotNull
    public static final String CACHE_STRATEGY = "cache_strategy";

    public PdfViewerActivity() {
        ComponentActivity $this$viewModels_u24default$iv = (ComponentActivity)this;
        Function0 extrasProducer$iv = null;
        Object factoryProducer$iv = null;
        boolean $i$f$viewModels = false;
        Function0 factoryPromise$iv = (Function0)new Function0<ViewModelProvider.Factory>($this$viewModels_u24default$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = $receiver;
                super(0);
            }

            public final ViewModelProvider.Factory invoke() {
                return this.$this_viewModels.getDefaultViewModelProviderFactory();
            }
        };
        this.viewModel$delegate = (Lazy)new ViewModelLazy(Reflection.getOrCreateKotlinClass(PdfViewerViewModel.class), (Function0)new Function0<ViewModelStore>($this$viewModels_u24default$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = $receiver;
                super(0);
            }

            public final ViewModelStore invoke() {
                return this.$this_viewModels.getViewModelStore();
            }
        }, factoryPromise$iv, (Function0)new Function0<CreationExtras>(extrasProducer$iv, $this$viewModels_u24default$iv){
            final /* synthetic */ Function0 $extrasProducer;
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$extrasProducer = $extrasProducer;
                this.$this_viewModels = $receiver;
                super(0);
            }

            public final CreationExtras invoke() {
                Function0 function0 = this.$extrasProducer;
                if (function0 == null || (function0 = (CreationExtras)function0.invoke()) == null) {
                    function0 = this.$this_viewModels.getDefaultViewModelCreationExtras();
                }
                return function0;
            }
        });
        this.requestPermissionLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), arg_0 -> PdfViewerActivity.requestPermissionLauncher$lambda$7(this, arg_0));
        this.createFileLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> PdfViewerActivity.createFileLauncher$lambda$13(this, arg_0));
    }

    private final PdfViewerViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (PdfViewerViewModel)((Object)lazy.getValue());
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.setTheme(R.style.Theme_PdfView_SelectedTheme);
        ThemeValidator.INSTANCE.validatePdfViewerTheme((Context)this);
        super.onCreate(savedInstanceState);
        ActivityPdfViewerBinding activityPdfViewerBinding = ActivityPdfViewerBinding.inflate(this.getLayoutInflater());
        Intrinsics.checkNotNullExpressionValue((Object)activityPdfViewerBinding, (String)"inflate(...)");
        this.binding = activityPdfViewerBinding;
        ActivityPdfViewerBinding activityPdfViewerBinding2 = this.binding;
        if (activityPdfViewerBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding2 = null;
        }
        this.setContentView((View)activityPdfViewerBinding2.getRoot());
        if (Build.VERSION.SDK_INT >= 34) {
            Window window = this.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindow(...)");
            this.applyEdgeToEdge(window);
        }
        this.configureToolbar();
        this.applyThemeAttributes();
        this.extractIntentExtras();
        this.init();
    }

    private final void configureToolbar() {
        ActivityPdfViewerBinding activityPdfViewerBinding;
        ActivityPdfViewerBinding activityPdfViewerBinding2;
        Context context = (Context)this;
        Intent intent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"getIntent(...)");
        ToolbarStyle toolbarStyle = ToolbarStyle.Companion.from(context, intent);
        String string2 = this.getIntent().getStringExtra(FILE_TITLE);
        if (string2 == null) {
            string2 = "PDF";
        }
        String toolbarTitle = string2;
        try {
            ActionBar actionBar = this.getSupportActionBar();
            if (actionBar != null) {
                actionBar.hide();
            }
        }
        catch (IllegalStateException e) {
            Log.w((String)"PdfViewer", (String)("supportActionBar check failed: " + e.getMessage()));
        }
        if ((activityPdfViewerBinding2 = this.binding) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding2 = null;
        }
        activityPdfViewerBinding2.myToolbar.setVisibility(0);
        try {
            ActivityPdfViewerBinding activityPdfViewerBinding3 = this.binding;
            if (activityPdfViewerBinding3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activityPdfViewerBinding3 = null;
            }
            this.setSupportActionBar((Toolbar)activityPdfViewerBinding3.myToolbar);
            ActionBar actionBar = this.getSupportActionBar();
            if (actionBar != null) {
                actionBar.setDisplayShowTitleEnabled(false);
            }
        }
        catch (IllegalStateException e) {
            Log.e((String)"PdfViewer", (String)("Can't setSupportActionBar(): " + e.getMessage()));
        }
        if ((activityPdfViewerBinding = this.binding) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding = null;
        }
        MaterialToolbar materialToolbar = activityPdfViewerBinding.myToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)materialToolbar, (String)"myToolbar");
        Toolbar toolbar = (Toolbar)materialToolbar;
        ActivityPdfViewerBinding activityPdfViewerBinding4 = this.binding;
        if (activityPdfViewerBinding4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding4 = null;
        }
        TextView textView = activityPdfViewerBinding4.toolbarTitle;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"toolbarTitle");
        toolbarStyle.applyTo(toolbar, textView);
        ActivityPdfViewerBinding activityPdfViewerBinding5 = this.binding;
        if (activityPdfViewerBinding5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding5 = null;
        }
        activityPdfViewerBinding5.toolbarTitle.setText((CharSequence)toolbarTitle);
    }

    private final void applyEdgeToEdge(Window window) {
        boolean isDarkMode = EdgeToEdgeHelper.INSTANCE.isDarkModeEnabled(this.getResources().getConfiguration().uiMode);
        Context context = (Context)this;
        Intent intent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"getIntent(...)");
        int toolbarColor = ToolbarStyle.Companion.from(context, intent).getToolbarColor();
        EdgeToEdge.enable$default((ComponentActivity)((ComponentActivity)this), (SystemBarStyle)(isDarkMode ? SystemBarStyle.Companion.dark(toolbarColor) : SystemBarStyle.Companion.light(toolbarColor, toolbarColor)), null, (int)2, null);
        ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
        if (activityPdfViewerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding = null;
        }
        ConstraintLayout constraintLayout = activityPdfViewerBinding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"getRoot(...)");
        EdgeToEdgeHelper.applyInsets$default(EdgeToEdgeHelper.INSTANCE, window, (View)constraintLayout, isDarkMode, null, 8, null);
    }

    private final void applyThemeAttributes() {
        ViewerStyle viewerStyle = ViewerStyle.Companion.from((Context)this);
        ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
        if (activityPdfViewerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding = null;
        }
        viewerStyle.applyTo(activityPdfViewerBinding);
    }

    private final void extractIntentExtras() {
        Object object;
        enableDownload = this.getIntent().getBooleanExtra(ENABLE_FILE_DOWNLOAD, false);
        isFromAssets = this.getIntent().getBooleanExtra(FROM_ASSETS, false);
        HeaderData headerData = Build.VERSION.SDK_INT >= 33 ? (HeaderData)this.getIntent().getParcelableExtra("headers", HeaderData.class) : (HeaderData)this.getIntent().getParcelableExtra("headers");
        if (headerData == null) {
            headerData = new HeaderData(MapsKt.emptyMap());
        }
        this.headers = headerData;
        isZoomEnabled = this.getIntent().getBooleanExtra(ENABLE_ZOOM, true);
        int strategyOrdinal = this.getIntent().getIntExtra(CACHE_STRATEGY, CacheStrategy.MAXIMIZE_PERFORMANCE.ordinal());
        PdfViewerActivity pdfViewerActivity = this;
        Object object2 = (List)EntriesMappings.entries$0;
        if (strategyOrdinal >= 0 && strategyOrdinal <= CollectionsKt.getLastIndex((List)object2)) {
            object = object2.get(strategyOrdinal);
        } else {
            int n = strategyOrdinal;
            PdfViewerActivity pdfViewerActivity2 = pdfViewerActivity;
            boolean bl = false;
            object = CacheStrategy.MAXIMIZE_PERFORMANCE;
            pdfViewerActivity = pdfViewerActivity2;
        }
        pdfViewerActivity.cacheStrategy = (CacheStrategy)((Object)object);
        Object strings = object2 = ViewerStrings.Companion.from((Context)this);
        boolean bl = false;
        this.error_pdf_corrupted = ((ViewerStrings)strings).getErrorPdfCorrupted();
        this.error_no_internet_connection = ((ViewerStrings)strings).getErrorNoInternet();
        this.file_saved_successfully = ((ViewerStrings)strings).getFileSavedSuccessfully();
        this.file_saved_to_downloads = ((ViewerStrings)strings).getFileSavedToDownloads();
        this.file_not_downloaded_yet = ((ViewerStrings)strings).getFileNotDownloadedYet();
        this.permission_required = ((ViewerStrings)strings).getPermissionRequired();
        this.permission_required_title = ((ViewerStrings)strings).getPermissionRequiredTitle();
        this.pdf_viewer_error = ((ViewerStrings)strings).getGenericError();
        this.pdf_viewer_retry = ((ViewerStrings)strings).getRetry();
        this.pdf_viewer_cancel = ((ViewerStrings)strings).getCancel();
        this.pdf_viewer_grant = ((ViewerStrings)strings).getGrant();
    }

    private final void init() {
        ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
        if (activityPdfViewerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding = null;
        }
        activityPdfViewerBinding.pdfView.setStatusListener(new PdfRendererView.StatusCallBack(this){
            final /* synthetic */ PdfViewerActivity this$0;
            {
                this.this$0 = $receiver;
            }

            public void onPdfLoadStart() {
                PdfViewerActivity.access$showProgressBar(this.this$0, true);
                PdfViewerActivity.access$updateDownloadButtonState(this.this$0, false);
            }

            public void onPdfLoadProgress(int progress, long downloadedBytes, @Nullable Long totalBytes) {
                PdfViewerActivity.access$showProgressBar(this.this$0, true);
            }

            public void onPdfLoadSuccess(@NotNull String absolutePath) {
                Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
                this.this$0.runOnUiThread(() -> init.1.onPdfLoadSuccess$lambda$0(this.this$0, absolutePath));
            }

            public void onError(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.this$0.runOnUiThread(() -> init.1.onError$lambda$1(this.this$0, error));
            }

            public void onPageChanged(int currentPage, int totalPage) {
            }

            private static final void onPdfLoadSuccess$lambda$0(PdfViewerActivity this$0, String $absolutePath) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$absolutePath, (String)"$absolutePath");
                PdfViewerActivity.access$showProgressBar(this$0, false);
                PdfViewerActivity.access$setDownloadedFilePath$p(this$0, $absolutePath);
                if (PdfViewerActivity.access$getMenuItem$p(this$0) == null) {
                    PdfViewerActivity.access$setDownloadButtonEnabled$p(this$0, true);
                } else {
                    PdfViewerActivity.access$updateDownloadButtonState(this$0, true);
                }
            }

            private static final void onError$lambda$1(PdfViewerActivity this$0, Throwable $error) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$error, (String)"$error");
                PdfViewerActivity.access$showProgressBar(this$0, false);
                ViewerStrings strings = ViewerStrings.Companion.from((Context)this$0);
                String errorMessage = ViewerStrings.Companion.getMessageForError(strings, $error);
                PdfViewerActivity.access$showErrorDialog(this$0, errorMessage, PdfViewerActivity.access$isRetryable(this$0, $error));
            }
        });
        Bundle bundle = this.getIntent().getExtras();
        Intrinsics.checkNotNull((Object)bundle);
        if (bundle.containsKey(FILE_URL)) {
            Bundle bundle2 = this.getIntent().getExtras();
            Intrinsics.checkNotNull((Object)bundle2);
            this.fileUrl = bundle2.getString(FILE_URL);
            if (isPDFFromPath) {
                this.initPdfViewerWithPath(this.fileUrl);
            } else if (NetworkUtil.INSTANCE.checkInternetConnection((Context)this)) {
                this.loadFileFromNetwork(this.fileUrl);
            } else {
                Context context = (Context)this;
                String string2 = this.error_no_internet_connection;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"error_no_internet_connection");
                    string2 = null;
                }
                Toast.makeText((Context)context, (CharSequence)string2, (int)0).show();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRetryable(Throwable error) {
        boolean bl;
        if (error instanceof UnknownHostException) return true;
        if (error instanceof SocketTimeoutException) return true;
        String string2 = error.getMessage();
        if (string2 != null) {
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"Failed to download", (boolean)false, (int)2, null)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        String string3 = error.getMessage();
        if (string3 == null) return false;
        if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"Incomplete download", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final void showErrorDialog(String message, boolean shouldRetry) {
        String string2;
        ViewerStrings strings = ViewerStrings.Companion.from((Context)this);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this).setTitle((CharSequence)strings.getErrorDialogTitle()).setMessage((CharSequence)message);
        if (shouldRetry) {
            String string3 = this.pdf_viewer_retry;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_retry");
                string3 = null;
            }
            builder.setPositiveButton((CharSequence)string3, (arg_0, arg_1) -> PdfViewerActivity.showErrorDialog$lambda$2(this, arg_0, arg_1));
        }
        if ((string2 = this.pdf_viewer_cancel) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_cancel");
            string2 = null;
        }
        builder.setNegativeButton((CharSequence)string2, null).show();
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        MenuInflater menuInflater = this.getMenuInflater();
        Intrinsics.checkNotNullExpressionValue((Object)menuInflater, (String)"getMenuInflater(...)");
        MenuInflater inflater = menuInflater;
        inflater.inflate(R.menu.menu, menu2);
        MenuItem menuItem = this.menuItem = menu2.findItem(R.id.download);
        if (menuItem != null) {
            menuItem.setVisible(enableDownload);
        }
        Context context = (Context)this;
        Intent intent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"getIntent(...)");
        ToolbarStyle toolbarStyle = ToolbarStyle.Companion.from(context, intent);
        MenuItem menuItem2 = this.menuItem;
        if (menuItem2 != null && (menuItem2 = menuItem2.getIcon()) != null && (menuItem2 = menuItem2.mutate()) != null) {
            MenuItem it = menuItem2;
            boolean bl = false;
            Drawable drawable2 = DrawableCompat.wrap((Drawable)it);
            Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"wrap(...)");
            Drawable wrappedIcon = drawable2;
            DrawableCompat.setTint((Drawable)wrappedIcon, (int)toolbarStyle.getDownloadIconTint());
            MenuItem menuItem3 = this.menuItem;
            if (menuItem3 != null) {
                menuItem3.setIcon(wrappedIcon);
            }
        }
        this.updateDownloadButtonState(this.isDownloadButtonEnabled);
        return true;
    }

    @TestOnly
    public final boolean isDownloadButtonVisible() {
        MenuItem menuItem = this.menuItem;
        return menuItem != null ? menuItem.isVisible() : false;
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int n = item.getItemId();
        if (n == R.id.download) {
            this.checkAndStartDownload();
            bl = true;
        } else if (n == 16908332) {
            this.finish();
            bl = true;
        } else {
            bl = super.onOptionsItemSelected(item);
        }
        return bl;
    }

    private final void loadFileFromNetwork(String fileUrl) {
        this.initPdfViewer(fileUrl);
    }

    private final void initPdfViewer(String fileUrl) {
        if (TextUtils.isEmpty((CharSequence)fileUrl)) {
            this.onPdfError("");
        }
        try {
            ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
            if (activityPdfViewerBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activityPdfViewerBinding = null;
            }
            activityPdfViewerBinding.pdfView.setZoomEnabled(isZoomEnabled);
            ActivityPdfViewerBinding activityPdfViewerBinding2 = this.binding;
            if (activityPdfViewerBinding2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activityPdfViewerBinding2 = null;
            }
            PdfRendererView pdfRendererView = activityPdfViewerBinding2.pdfView;
            String string2 = fileUrl;
            Intrinsics.checkNotNull((Object)string2);
            HeaderData headerData = this.headers;
            if (headerData == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"headers");
                headerData = null;
            }
            LifecycleCoroutineScope lifecycleCoroutineScope = LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this));
            Lifecycle lifecycle = this.getLifecycle();
            CacheStrategy cacheStrategy = this.cacheStrategy;
            if (cacheStrategy == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cacheStrategy");
                cacheStrategy = null;
            }
            pdfRendererView.initWithUrl(string2, headerData, lifecycleCoroutineScope, lifecycle, cacheStrategy);
        }
        catch (Exception e) {
            this.onPdfError(e.toString());
        }
    }

    private final void initPdfViewerWithPath(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            this.onPdfError("");
            return;
        }
        try {
            ActivityPdfViewerBinding activityPdfViewerBinding;
            File file;
            File file2;
            String string2 = filePath;
            Intrinsics.checkNotNull((Object)string2);
            if (StringsKt.startsWith$default((String)string2, (String)"content://", (boolean)false, (int)2, null)) {
                Context context = this.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
                Uri uri = Uri.parse((String)filePath);
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(...)");
                file2 = FileUtils.INSTANCE.uriToFile(context, uri);
            } else {
                file2 = file = isFromAssets ? FileUtils.INSTANCE.fileFromAsset((Context)this, filePath) : new File(filePath);
            }
            if ((activityPdfViewerBinding = this.binding) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activityPdfViewerBinding = null;
            }
            activityPdfViewerBinding.pdfView.setZoomEnabled(isZoomEnabled);
            ActivityPdfViewerBinding activityPdfViewerBinding2 = this.binding;
            if (activityPdfViewerBinding2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activityPdfViewerBinding2 = null;
            }
            PdfRendererView pdfRendererView = activityPdfViewerBinding2.pdfView;
            CacheStrategy cacheStrategy = this.cacheStrategy;
            if (cacheStrategy == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cacheStrategy");
                cacheStrategy = null;
            }
            pdfRendererView.initWithFile(file, cacheStrategy);
        }
        catch (Exception e) {
            this.onPdfError(e.toString());
        }
    }

    private final void onPdfError(String e) {
        Log.e((String)"Pdf render error", (String)e);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        String string2 = this.pdf_viewer_error;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_error");
            string2 = null;
        }
        AlertDialog.Builder builder2 = builder.setTitle((CharSequence)string2);
        String string3 = this.error_pdf_corrupted;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"error_pdf_corrupted");
            string3 = null;
        }
        AlertDialog.Builder builder3 = builder2.setMessage((CharSequence)string3);
        String string4 = this.pdf_viewer_retry;
        if (string4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_retry");
            string4 = null;
        }
        AlertDialog.Builder builder4 = builder3.setPositiveButton((CharSequence)string4, (arg_0, arg_1) -> PdfViewerActivity.onPdfError$lambda$5(this, arg_0, arg_1));
        String string5 = this.pdf_viewer_cancel;
        if (string5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_cancel");
            string5 = null;
        }
        builder4.setNegativeButton((CharSequence)string5, null).show();
    }

    private final void showProgressBar(boolean $this$showProgressBar) {
        ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
        if (activityPdfViewerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding = null;
        }
        activityPdfViewerBinding.progressBar.setVisibility($this$showProgressBar ? 0 : 8);
    }

    private final void requestStoragePermission() {
        this.requestPermissionLauncher.launch((Object)"android.permission.WRITE_EXTERNAL_STORAGE");
    }

    private final void checkAndStartDownload() {
        if (Build.VERSION.SDK_INT < 30) {
            if (ContextCompat.checkSelfPermission((Context)((Context)this), (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
                this.startDownload();
            } else {
                this.requestPermissionLauncher.launch((Object)"android.permission.WRITE_EXTERNAL_STORAGE");
            }
        } else {
            this.startDownload();
        }
    }

    private final void startDownload() {
        block8: {
            Unit unit;
            String string2 = this.getIntent().getStringExtra(FILE_TITLE);
            if (string2 == null) {
                string2 = "downloaded_file.pdf";
            }
            String fileName = string2;
            String string3 = this.downloadedFilePath;
            if (string3 != null) {
                String filePath = string3;
                boolean bl = false;
                if (SAVE_TO_DOWNLOADS) {
                    if (Build.VERSION.SDK_INT >= 29) {
                        this.saveFileToPublicDirectoryScopedStorage(filePath, fileName);
                    } else {
                        this.saveFileToPublicDirectoryLegacy(filePath, fileName);
                    }
                } else {
                    this.promptUserForLocation(fileName);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block8;
            Context context = (Context)this;
            String string4 = this.file_not_downloaded_yet;
            if (string4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"file_not_downloaded_yet");
                string4 = null;
            }
            Toast.makeText((Context)context, (CharSequence)string4, (int)0).show();
        }
    }

    private final void promptUserForLocation(String fileName) {
        Intent intent;
        Intent $this$promptUserForLocation_u24lambda_u249 = intent = new Intent("android.intent.action.CREATE_DOCUMENT");
        boolean bl = false;
        $this$promptUserForLocation_u24lambda_u249.addCategory("android.intent.category.OPENABLE");
        $this$promptUserForLocation_u24lambda_u249.setType("application/pdf");
        $this$promptUserForLocation_u24lambda_u249.putExtra("android.intent.extra.TITLE", fileName);
        Intent intent2 = intent;
        this.createFileLauncher.launch((Object)intent2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveFileToPublicDirectoryScopedStorage(String filePath, String fileName) {
        ContentResolver contentResolver = this.getApplicationContext().getContentResolver();
        Intrinsics.checkNotNull((Object)contentResolver);
        Uri uri = FileUtils.INSTANCE.createPdfDocumentUri(contentResolver, fileName);
        OutputStream outputStream = contentResolver.openOutputStream(uri);
        if (outputStream != null) {
            Closeable closeable = outputStream;
            Throwable throwable = null;
            try {
                OutputStream outputStream2 = (OutputStream)closeable;
                boolean bl = false;
                Long l = ByteStreamsKt.copyTo$default((InputStream)new FileInputStream(new File(filePath)), (OutputStream)outputStream2, (int)0, (int)2, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        Context context = (Context)this;
        String string2 = this.file_saved_to_downloads;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file_saved_to_downloads");
            string2 = null;
        }
        Toast.makeText((Context)context, (CharSequence)string2, (int)0).show();
    }

    private final void saveFileToPublicDirectoryLegacy(String filePath, String fileName) {
        File destinationFile = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS), fileName);
        FilesKt.copyTo$default((File)new File(filePath), (File)destinationFile, (boolean)true, (int)0, (int)4, null);
        Context context = (Context)this;
        String string2 = this.file_saved_to_downloads;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file_saved_to_downloads");
            string2 = null;
        }
        Toast.makeText((Context)context, (CharSequence)string2, (int)0).show();
    }

    protected void onDestroy() {
        super.onDestroy();
        ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
        if (activityPdfViewerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding = null;
        }
        activityPdfViewerBinding.pdfView.closePdfRender();
    }

    private final void updateDownloadButtonState(boolean isEnabled) {
        block1: {
            this.isDownloadButtonEnabled = isEnabled;
            MenuItem menuItem = this.menuItem;
            if (menuItem == null) break block1;
            MenuItem item = menuItem;
            boolean bl = false;
            item.setEnabled(isEnabled);
            Drawable drawable2 = item.getIcon();
            if (drawable2 != null) {
                drawable2.setAlpha(isEnabled ? 255 : 100);
            }
        }
    }

    private static final void showErrorDialog$lambda$2(PdfViewerActivity this$0, DialogInterface dialogInterface, int n) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.loadFileFromNetwork(this$0.fileUrl);
    }

    private static final void onPdfError$lambda$5$lambda$4(PdfViewerActivity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.init();
    }

    private static final void onPdfError$lambda$5(PdfViewerActivity this$0, DialogInterface dialog, int which) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.runOnUiThread(() -> PdfViewerActivity.onPdfError$lambda$5$lambda$4(this$0));
    }

    private static final void requestPermissionLauncher$lambda$7$lambda$6(PdfViewerActivity this$0, DialogInterface dialog, int which) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        this$0.requestStoragePermission();
    }

    private static final void requestPermissionLauncher$lambda$7(PdfViewerActivity this$0, boolean isGranted) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (isGranted) {
            this$0.startDownload();
        } else {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this$0);
            String string2 = this$0.permission_required_title;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"permission_required_title");
                string2 = null;
            }
            AlertDialog.Builder builder2 = builder.setTitle((CharSequence)string2);
            String string3 = this$0.permission_required;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"permission_required");
                string3 = null;
            }
            AlertDialog.Builder builder3 = builder2.setMessage((CharSequence)string3);
            String string4 = this$0.pdf_viewer_grant;
            if (string4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_grant");
                string4 = null;
            }
            AlertDialog.Builder builder4 = builder3.setPositiveButton((CharSequence)string4, (arg_0, arg_1) -> PdfViewerActivity.requestPermissionLauncher$lambda$7$lambda$6(this$0, arg_0, arg_1));
            String string5 = this$0.pdf_viewer_cancel;
            if (string5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_cancel");
                string5 = null;
            }
            builder4.setNegativeButton((CharSequence)string5, null).show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createFileLauncher$lambda$13(PdfViewerActivity this$0, ActivityResult result) {
        block10: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            if (result.getResultCode() != -1) break block10;
            Intent intent = result.getData();
            if (intent != null && (intent = intent.getData()) != null) {
                Intent uri = intent;
                boolean bl = false;
                OutputStream outputStream = this$0.getContentResolver().openOutputStream((Uri)uri);
                if (outputStream != null) {
                    Closeable closeable = outputStream;
                    Throwable throwable = null;
                    try {
                        Long l;
                        OutputStream outputStream2 = (OutputStream)closeable;
                        boolean bl2 = false;
                        String string2 = this$0.downloadedFilePath;
                        if (string2 != null) {
                            String filePath = string2;
                            boolean bl3 = false;
                            InputStream inputStream = new FileInputStream(new File(filePath));
                            Intrinsics.checkNotNull((Object)outputStream2);
                            l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream2, (int)0, (int)2, null);
                        } else {
                            l = null;
                        }
                        Long l2 = l;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                Context context = (Context)this$0;
                String string3 = this$0.file_saved_successfully;
                if (string3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"file_saved_successfully");
                    string3 = null;
                }
                Toast.makeText((Context)context, (CharSequence)string3, (int)0).show();
            }
        }
    }

    public static final /* synthetic */ void access$showProgressBar(PdfViewerActivity $this, boolean $receiver) {
        $this.showProgressBar($receiver);
    }

    public static final /* synthetic */ void access$updateDownloadButtonState(PdfViewerActivity $this, boolean isEnabled) {
        $this.updateDownloadButtonState(isEnabled);
    }

    public static final /* synthetic */ void access$setDownloadedFilePath$p(PdfViewerActivity $this, String string2) {
        $this.downloadedFilePath = string2;
    }

    public static final /* synthetic */ MenuItem access$getMenuItem$p(PdfViewerActivity $this) {
        return $this.menuItem;
    }

    public static final /* synthetic */ void access$setDownloadButtonEnabled$p(PdfViewerActivity $this, boolean bl) {
        $this.isDownloadButtonEnabled = bl;
    }

    public static final /* synthetic */ void access$showErrorDialog(PdfViewerActivity $this, String message, boolean shouldRetry) {
        $this.showErrorDialog(message, shouldRetry);
    }

    public static final /* synthetic */ boolean access$isRetryable(PdfViewerActivity $this, Throwable error) {
        return $this.isRetryable(error);
    }

    static {
        SAVE_TO_DOWNLOADS = true;
        isZoomEnabled = true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JV\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020\u000b2\b\b\u0002\u0010#\u001a\u00020\u000b2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%2\b\b\u0002\u0010&\u001a\u00020'Jl\u0010(\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010)\u001a\u0004\u0018\u00010\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\u0011\u001a\u00020\u000b2\b\b\u0002\u0010#\u001a\u00020\u000b2\u0014\b\u0002\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040+2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%2\b\b\u0002\u0010&\u001a\u00020'R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000fR\u001a\u0010\u0014\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\r\"\u0004\b\u0017\u0010\u000fR\u001a\u0010\u0018\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000f\u00a8\u0006,"}, d2={"Lcom/rajat/pdfviewer/PdfViewerActivity$Companion;", "", "()V", "CACHE_STRATEGY", "", "ENABLE_FILE_DOWNLOAD", "ENABLE_ZOOM", "FILE_TITLE", "FILE_URL", "FROM_ASSETS", "SAVE_TO_DOWNLOADS", "", "getSAVE_TO_DOWNLOADS", "()Z", "setSAVE_TO_DOWNLOADS", "(Z)V", "TITLE_BEHAVIOR", "enableDownload", "getEnableDownload", "setEnableDownload", "isFromAssets", "setFromAssets", "isPDFFromPath", "setPDFFromPath", "isZoomEnabled", "setZoomEnabled", "launchPdfFromPath", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "path", "pdfTitle", "saveTo", "Lcom/rajat/pdfviewer/util/saveTo;", "fromAssets", "enableZoom", "toolbarTitleBehavior", "Lcom/rajat/pdfviewer/util/ToolbarTitleBehavior;", "cacheStrategy", "Lcom/rajat/pdfviewer/util/CacheStrategy;", "launchPdfFromUrl", "pdfUrl", "headers", "", "pdfViewer_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getEnableDownload() {
            return enableDownload;
        }

        public final void setEnableDownload(boolean bl) {
            enableDownload = bl;
        }

        public final boolean isPDFFromPath() {
            return isPDFFromPath;
        }

        public final void setPDFFromPath(boolean bl) {
            isPDFFromPath = bl;
        }

        public final boolean isFromAssets() {
            return isFromAssets;
        }

        public final void setFromAssets(boolean bl) {
            isFromAssets = bl;
        }

        public final boolean getSAVE_TO_DOWNLOADS() {
            return SAVE_TO_DOWNLOADS;
        }

        public final void setSAVE_TO_DOWNLOADS(boolean bl) {
            SAVE_TO_DOWNLOADS = bl;
        }

        public final boolean isZoomEnabled() {
            return isZoomEnabled;
        }

        public final void setZoomEnabled(boolean bl) {
            isZoomEnabled = bl;
        }

        @NotNull
        public final Intent launchPdfFromUrl(@Nullable Context context, @Nullable String pdfUrl, @Nullable String pdfTitle, @NotNull saveTo saveTo2, boolean enableDownload, boolean enableZoom, @NotNull Map<String, String> headers, @Nullable ToolbarTitleBehavior toolbarTitleBehavior, @NotNull CacheStrategy cacheStrategy) {
            Intrinsics.checkNotNullParameter((Object)((Object)saveTo2), (String)"saveTo");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)((Object)cacheStrategy), (String)"cacheStrategy");
            Intent intent = new Intent(context, PdfViewerActivity.class);
            intent.putExtra(PdfViewerActivity.FILE_URL, pdfUrl);
            intent.putExtra(PdfViewerActivity.FILE_TITLE, pdfTitle);
            intent.putExtra(PdfViewerActivity.ENABLE_FILE_DOWNLOAD, enableDownload);
            intent.putExtra("headers", (Parcelable)new HeaderData(headers));
            intent.putExtra(PdfViewerActivity.ENABLE_ZOOM, enableZoom);
            ToolbarTitleBehavior toolbarTitleBehavior2 = toolbarTitleBehavior;
            if (toolbarTitleBehavior2 != null) {
                ToolbarTitleBehavior it = toolbarTitleBehavior2;
                boolean bl = false;
                intent.putExtra(PdfViewerActivity.TITLE_BEHAVIOR, it.ordinal());
            }
            intent.putExtra(PdfViewerActivity.CACHE_STRATEGY, cacheStrategy.ordinal());
            this.setPDFFromPath(false);
            this.setSAVE_TO_DOWNLOADS(saveTo2 == saveTo.DOWNLOADS);
            return intent;
        }

        public static /* synthetic */ Intent launchPdfFromUrl$default(Companion companion, Context context, String string2, String string3, saveTo saveTo2, boolean bl, boolean bl2, Map map, ToolbarTitleBehavior toolbarTitleBehavior, CacheStrategy cacheStrategy, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl = true;
            }
            if ((n & 0x20) != 0) {
                bl2 = true;
            }
            if ((n & 0x40) != 0) {
                map = MapsKt.emptyMap();
            }
            if ((n & 0x80) != 0) {
                toolbarTitleBehavior = null;
            }
            if ((n & 0x100) != 0) {
                cacheStrategy = CacheStrategy.MAXIMIZE_PERFORMANCE;
            }
            return companion.launchPdfFromUrl(context, string2, string3, saveTo2, bl, bl2, map, toolbarTitleBehavior, cacheStrategy);
        }

        @NotNull
        public final Intent launchPdfFromPath(@Nullable Context context, @Nullable String path, @Nullable String pdfTitle, @NotNull saveTo saveTo2, boolean fromAssets, boolean enableZoom, @Nullable ToolbarTitleBehavior toolbarTitleBehavior, @NotNull CacheStrategy cacheStrategy) {
            Intrinsics.checkNotNullParameter((Object)((Object)saveTo2), (String)"saveTo");
            Intrinsics.checkNotNullParameter((Object)((Object)cacheStrategy), (String)"cacheStrategy");
            Intent intent = new Intent(context, PdfViewerActivity.class);
            intent.putExtra(PdfViewerActivity.FILE_URL, path);
            intent.putExtra(PdfViewerActivity.FILE_TITLE, pdfTitle);
            intent.putExtra(PdfViewerActivity.ENABLE_FILE_DOWNLOAD, false);
            intent.putExtra(PdfViewerActivity.FROM_ASSETS, fromAssets);
            ToolbarTitleBehavior toolbarTitleBehavior2 = toolbarTitleBehavior;
            if (toolbarTitleBehavior2 != null) {
                ToolbarTitleBehavior it = toolbarTitleBehavior2;
                boolean bl = false;
                intent.putExtra(PdfViewerActivity.TITLE_BEHAVIOR, it.ordinal());
            }
            intent.putExtra(PdfViewerActivity.ENABLE_ZOOM, enableZoom);
            intent.putExtra(PdfViewerActivity.CACHE_STRATEGY, cacheStrategy.ordinal());
            this.setPDFFromPath(true);
            this.setSAVE_TO_DOWNLOADS(saveTo2 == saveTo.DOWNLOADS);
            return intent;
        }

        public static /* synthetic */ Intent launchPdfFromPath$default(Companion companion, Context context, String string2, String string3, saveTo saveTo2, boolean bl, boolean bl2, ToolbarTitleBehavior toolbarTitleBehavior, CacheStrategy cacheStrategy, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl = false;
            }
            if ((n & 0x20) != 0) {
                bl2 = true;
            }
            if ((n & 0x40) != 0) {
                toolbarTitleBehavior = null;
            }
            if ((n & 0x80) != 0) {
                cacheStrategy = CacheStrategy.MAXIMIZE_PERFORMANCE;
            }
            return companion.launchPdfFromPath(context, string2, string3, saveTo2, bl, bl2, toolbarTitleBehavior, cacheStrategy);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<CacheStrategy> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])CacheStrategy.values());
        }
    }
}

