/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.Size;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.recyclerview.widget.RecyclerView;
import com.rajat.pdfviewer.PdfRendererCore;
import com.rajat.pdfviewer.databinding.ListItemPdfPageBinding;
import com.rajat.pdfviewer.util.CommonUtils;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0001\u0016B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u001c\u0010\u0012\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/rajat/pdfviewer/PdfViewAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/rajat/pdfviewer/PdfViewAdapter$PdfPageViewHolder;", "context", "Landroid/content/Context;", "renderer", "Lcom/rajat/pdfviewer/PdfRendererCore;", "pageSpacing", "Landroid/graphics/Rect;", "enableLoadingForPages", "", "(Landroid/content/Context;Lcom/rajat/pdfviewer/PdfRendererCore;Landroid/graphics/Rect;Z)V", "getItemCount", "", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "PdfPageViewHolder", "pdfViewer_release"})
@StabilityInferred(parameters=0)
public final class PdfViewAdapter
extends RecyclerView.Adapter<PdfPageViewHolder> {
    @NotNull
    private final Context context;
    @NotNull
    private final PdfRendererCore renderer;
    @NotNull
    private final Rect pageSpacing;
    private final boolean enableLoadingForPages;
    public static final int $stable = 8;

    public PdfViewAdapter(@NotNull Context context, @NotNull PdfRendererCore renderer, @NotNull Rect pageSpacing, boolean enableLoadingForPages) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)pageSpacing, (String)"pageSpacing");
        this.context = context;
        this.renderer = renderer;
        this.pageSpacing = pageSpacing;
        this.enableLoadingForPages = enableLoadingForPages;
    }

    @NotNull
    public PdfPageViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        ListItemPdfPageBinding listItemPdfPageBinding = ListItemPdfPageBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)listItemPdfPageBinding, (String)"inflate(...)");
        return new PdfPageViewHolder(listItemPdfPageBinding);
    }

    public int getItemCount() {
        return this.renderer.getPageCount();
    }

    public void onBindViewHolder(@NotNull PdfPageViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        holder.bind(position);
    }

    public static final /* synthetic */ Context access$getContext$p(PdfViewAdapter $this) {
        return $this.context;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\r\u001a\u00020\u0006*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/rajat/pdfviewer/PdfViewAdapter$PdfPageViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemBinding", "Lcom/rajat/pdfviewer/databinding/ListItemPdfPageBinding;", "(Lcom/rajat/pdfviewer/PdfViewAdapter;Lcom/rajat/pdfviewer/databinding/ListItemPdfPageBinding;)V", "applyFadeInAnimation", "", "view", "Landroid/view/View;", "bind", "position", "", "handleLoadingForPage", "updateLayoutParams", "height", "pdfViewer_release"})
    public final class PdfPageViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final ListItemPdfPageBinding itemBinding;

        public PdfPageViewHolder(ListItemPdfPageBinding itemBinding) {
            Intrinsics.checkNotNullParameter((Object)itemBinding, (String)"itemBinding");
            super((View)itemBinding.getRoot());
            this.itemBinding = itemBinding;
        }

        public final void bind(int position) {
            ListItemPdfPageBinding listItemPdfPageBinding = this.itemBinding;
            PdfViewAdapter pdfViewAdapter = PdfViewAdapter.this;
            ListItemPdfPageBinding $this$bind_u24lambda_u241 = listItemPdfPageBinding;
            boolean bl = false;
            $this$bind_u24lambda_u241.pageLoadingLayout.pdfViewPageLoadingProgress.setVisibility(pdfViewAdapter.enableLoadingForPages ? 0 : 8);
            Bitmap bitmap = pdfViewAdapter.renderer.getBitmapFromCache$pdfViewer_release(position);
            if (bitmap != null) {
                Bitmap cachedBitmap = bitmap;
                boolean bl2 = false;
                $this$bind_u24lambda_u241.pageView.setImageBitmap(cachedBitmap);
                $this$bind_u24lambda_u241.pageLoadingLayout.pdfViewPageLoadingProgress.setVisibility(8);
                ImageView imageView = $this$bind_u24lambda_u241.pageView;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"pageView");
                this.applyFadeInAnimation((View)imageView);
                return;
            }
            pdfViewAdapter.renderer.getPageDimensionsAsync(position, (Function1<? super Size, Unit>)((Function1)new Function1<Size, Unit>($this$bind_u24lambda_u241, pdfViewAdapter, this, position){
                final /* synthetic */ ListItemPdfPageBinding $this_with;
                final /* synthetic */ PdfViewAdapter this$0;
                final /* synthetic */ PdfPageViewHolder this$1;
                final /* synthetic */ int $position;
                {
                    this.$this_with = $receiver;
                    this.this$0 = $receiver2;
                    this.this$1 = $receiver3;
                    this.$position = $position;
                    super(1);
                }

                public final void invoke(@NotNull Size size2) {
                    Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
                    Integer n = this.$this_with.pageView.getWidth();
                    int it = ((Number)n).intValue();
                    boolean bl = false;
                    Integer n2 = it > 0 ? n : null;
                    int width = n2 != null ? n2 : PdfViewAdapter.access$getContext$p((PdfViewAdapter)this.this$0).getResources().getDisplayMetrics().widthPixels;
                    float aspectRatio = (float)size2.getWidth() / (float)size2.getHeight();
                    int height = (int)((float)width / aspectRatio);
                    PdfPageViewHolder.access$updateLayoutParams(this.this$1, this.$this_with, height);
                    Bitmap bitmap = CommonUtils.Companion.BitmapPool.getBitmap$default(CommonUtils.Companion.BitmapPool.INSTANCE, width, Math.max(1, height), null, 4, null);
                    PdfViewAdapter.access$getRenderer$p(this.this$0).renderPage(this.$position, bitmap, (Function3<? super Boolean, ? super Integer, ? super Bitmap, Unit>)((Function3)new Function3<Boolean, Integer, Bitmap, Unit>(this.$position, bitmap, this.$this_with, this.this$1, this.this$0){
                        final /* synthetic */ int $position;
                        final /* synthetic */ Bitmap $bitmap;
                        final /* synthetic */ ListItemPdfPageBinding $this_with;
                        final /* synthetic */ PdfPageViewHolder this$0;
                        final /* synthetic */ PdfViewAdapter this$1;
                        {
                            this.$position = $position;
                            this.$bitmap = $bitmap;
                            this.$this_with = $receiver;
                            this.this$0 = $receiver2;
                            this.this$1 = $receiver3;
                            super(3);
                        }

                        public final void invoke(boolean success, int pageNo, @Nullable Bitmap renderedBitmap) {
                            if (success && pageNo == this.$position) {
                                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$this_with, renderedBitmap, this.$bitmap, this.this$0, this.this$1, this.$position, null){
                                    int label;
                                    final /* synthetic */ ListItemPdfPageBinding $this_with;
                                    final /* synthetic */ Bitmap $renderedBitmap;
                                    final /* synthetic */ Bitmap $bitmap;
                                    final /* synthetic */ PdfPageViewHolder this$0;
                                    final /* synthetic */ PdfViewAdapter this$1;
                                    final /* synthetic */ int $position;
                                    {
                                        this.$this_with = $receiver;
                                        this.$renderedBitmap = $renderedBitmap;
                                        this.$bitmap = $bitmap;
                                        this.this$0 = $receiver2;
                                        this.this$1 = $receiver3;
                                        this.$position = $position;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                ImageView imageView = this.$this_with.pageView;
                                                Bitmap bitmap = this.$renderedBitmap;
                                                if (bitmap == null) {
                                                    bitmap = this.$bitmap;
                                                }
                                                imageView.setImageBitmap(bitmap);
                                                ImageView imageView2 = this.$this_with.pageView;
                                                Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"pageView");
                                                PdfPageViewHolder.access$applyFadeInAnimation(this.this$0, (View)imageView2);
                                                this.$this_with.pageLoadingLayout.pdfViewPageLoadingProgress.setVisibility(8);
                                                Integer n = Boxing.boxInt((int)this.$this_with.pageView.getWidth());
                                                int it = ((Number)n).intValue();
                                                int n2 = this.$position;
                                                PdfRendererCore pdfRendererCore = PdfViewAdapter.access$getRenderer$p(this.this$1);
                                                boolean bl = false;
                                                int n3 = it > 0 ? 1 : 0;
                                                Integer n4 = n3 != 0 ? n : null;
                                                n = Boxing.boxInt((int)this.$this_with.pageView.getHeight());
                                                it = ((Number)n).intValue();
                                                n3 = n4 != null ? n4 : PdfViewAdapter.access$getContext$p((PdfViewAdapter)this.this$1).getResources().getDisplayMetrics().widthPixels;
                                                boolean bl2 = false;
                                                boolean bl3 = it > 0;
                                                Integer n5 = bl3 ? n : null;
                                                PdfRendererCore.prefetchPagesAround$default(pdfRendererCore, n2, n3, n5 != null ? n5 : PdfViewAdapter.access$getContext$p((PdfViewAdapter)this.this$1).getResources().getDisplayMetrics().heightPixels, 0, 8, null);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                            } else {
                                CommonUtils.Companion.BitmapPool.INSTANCE.recycleBitmap(this.$bitmap);
                            }
                        }
                    }));
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        private final void updateLayoutParams(ListItemPdfPageBinding $this$updateLayoutParams, int height) {
            void $this$updateLayoutParams_u24lambda_u242;
            ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams.getRoot().getLayoutParams();
            PdfViewAdapter pdfViewAdapter = PdfViewAdapter.this;
            ViewGroup.LayoutParams layoutParams2 = layoutParams;
            FrameLayout frameLayout = $this$updateLayoutParams.getRoot();
            boolean bl = false;
            $this$updateLayoutParams_u24lambda_u242.height = height;
            ViewGroup.MarginLayoutParams marginLayoutParams = $this$updateLayoutParams_u24lambda_u242 instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)$this$updateLayoutParams_u24lambda_u242 : null;
            if (marginLayoutParams != null) {
                marginLayoutParams.setMargins(((PdfViewAdapter)pdfViewAdapter).pageSpacing.left, ((PdfViewAdapter)pdfViewAdapter).pageSpacing.top, ((PdfViewAdapter)pdfViewAdapter).pageSpacing.right, ((PdfViewAdapter)pdfViewAdapter).pageSpacing.bottom);
            }
            frameLayout.setLayoutParams(layoutParams);
        }

        /*
         * WARNING - void declaration
         */
        private final void applyFadeInAnimation(View view) {
            void $this$applyFadeInAnimation_u24lambda_u243;
            AlphaAnimation alphaAnimation;
            AlphaAnimation alphaAnimation2 = alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
            View view2 = view;
            boolean bl = false;
            $this$applyFadeInAnimation_u24lambda_u243.setInterpolator((Interpolator)new LinearInterpolator());
            $this$applyFadeInAnimation_u24lambda_u243.setDuration(300L);
            view2.startAnimation((Animation)alphaAnimation);
        }

        private final void handleLoadingForPage(int position) {
            this.itemBinding.pageLoadingLayout.pdfViewPageLoadingProgress.setVisibility(PdfViewAdapter.this.enableLoadingForPages && !PdfViewAdapter.this.renderer.pageExistInCache(position) ? 0 : 8);
        }

        public static final /* synthetic */ void access$updateLayoutParams(PdfPageViewHolder $this, ListItemPdfPageBinding $receiver, int height) {
            $this.updateLayoutParams($receiver, height);
        }

        public static final /* synthetic */ void access$applyFadeInAnimation(PdfPageViewHolder $this, View view) {
            $this.applyFadeInAnimation(view);
        }
    }
}

