/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.pdf.PdfRenderer;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.util.Size;
import androidx.compose.runtime.internal.StabilityInferred;
import com.rajat.pdfviewer.util.CacheManager;
import com.rajat.pdfviewer.util.CacheStrategy;
import com.rajat.pdfviewer.util.CommonUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0017\u0018\u0000 I2\u00020\u0001:\u0001IB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020'H\u0002J\u0006\u0010,\u001a\u00020'J\u0017\u0010-\u001a\u0004\u0018\u00010*2\u0006\u0010(\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b.J\u0006\u0010/\u001a\u00020\u0011J\"\u00100\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00112\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020'02J\u0016\u00103\u001a\b\u0018\u00010\u0012R\u00020\u00132\u0006\u0010(\u001a\u00020\u0011H\u0002J\u000e\u00104\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u0011J(\u00105\u001a\u00020'2\u0006\u00106\u001a\u00020\u00112\u0006\u00107\u001a\u00020\u00112\u0006\u00108\u001a\u00020\u00112\b\b\u0002\u00109\u001a\u00020\u0011Ji\u0010:\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*2Q\b\u0002\u0010;\u001aK\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b=\u0012\b\b>\u0012\u0004\b\b(?\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b=\u0012\b\b>\u0012\u0004\b\b((\u0012\u0015\u0012\u0013\u0018\u00010*\u00a2\u0006\f\b=\u0012\b\b>\u0012\u0004\b\b()\u0012\u0004\u0012\u00020'\u0018\u00010<J(\u0010@\u001a\u0004\u0018\u00010*2\u0006\u0010(\u001a\u00020\u00112\u0006\u00107\u001a\u00020\u00112\u0006\u00108\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010AJ\u0018\u0010B\u001a\u00020'2\u0006\u0010C\u001a\u00020\u00112\u0006\u0010D\u001a\u00020#H\u0002J6\u0010E\u001a\u0004\u0018\u0001HF\"\u0004\b\u0000\u0010F2\u0006\u0010(\u001a\u00020\u00112\u0016\u0010G\u001a\u0012\u0012\b\u0012\u00060\u0012R\u00020\u0013\u0012\u0004\u0012\u0002HF02H\u0082@\u00a2\u0006\u0002\u0010HR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u00060\u0012R\u00020\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/rajat/pdfviewer/PdfRendererCore;", "", "context", "Landroid/content/Context;", "fileDescriptor", "Landroid/os/ParcelFileDescriptor;", "cacheIdentifier", "", "cacheStrategy", "Lcom/rajat/pdfviewer/util/CacheStrategy;", "(Landroid/content/Context;Landroid/os/ParcelFileDescriptor;Ljava/lang/String;Lcom/rajat/pdfviewer/util/CacheStrategy;)V", "cacheManager", "Lcom/rajat/pdfviewer/util/CacheManager;", "isRendererOpen", "", "openPages", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Landroid/graphics/pdf/PdfRenderer$Page;", "Landroid/graphics/pdf/PdfRenderer;", "pageCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "pageDimensionCache", "", "Landroid/util/Size;", "pdfRenderer", "renderJobs", "Lkotlinx/coroutines/Job;", "renderLock", "Lkotlinx/coroutines/sync/Mutex;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "slowestPage", "Ljava/lang/Integer;", "slowestRenderTime", "", "totalPagesRendered", "totalRenderTime", "addBitmapToMemoryCache", "", "pageNo", "bitmap", "Landroid/graphics/Bitmap;", "closeAllOpenPages", "closePdfRender", "getBitmapFromCache", "getBitmapFromCache$pdfViewer_release", "getPageCount", "getPageDimensionsAsync", "callback", "Lkotlin/Function1;", "openPageSafely", "pageExistInCache", "prefetchPagesAround", "currentPage", "width", "height", "direction", "renderPage", "onBitmapReady", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "success", "renderPageAsync", "(IIILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateAggregateMetrics", "page", "duration", "withPdfPage", "T", "block", "(ILkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "pdfViewer_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPdfRendererCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfRendererCore.kt\ncom/rajat/pdfviewer/PdfRendererCore\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,290:1\n314#2,11:291\n766#3:302\n857#3,2:303\n1855#3,2:305\n1#4:307\n*S KotlinDebug\n*F\n+ 1 PdfRendererCore.kt\ncom/rajat/pdfviewer/PdfRendererCore\n*L\n153#1:291,11\n184#1:302\n184#1:303,2\n185#1:305,2\n*E\n"})
public class PdfRendererCore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final ParcelFileDescriptor fileDescriptor;
    @NotNull
    private final String cacheIdentifier;
    @NotNull
    private final CacheStrategy cacheStrategy;
    private boolean isRendererOpen;
    @NotNull
    private final CacheManager cacheManager;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Mutex renderLock;
    @NotNull
    private final AtomicInteger pageCount;
    private int totalPagesRendered;
    private long totalRenderTime;
    private long slowestRenderTime;
    @Nullable
    private Integer slowestPage;
    @NotNull
    private final ConcurrentHashMap<Integer, PdfRenderer.Page> openPages;
    @NotNull
    private PdfRenderer pdfRenderer;
    @NotNull
    private final ConcurrentHashMap<Integer, Job> renderJobs;
    @NotNull
    private final Map<Integer, Size> pageDimensionCache;
    public static final int $stable = 8;
    private static boolean enableDebugMetrics;
    private static int prefetchDistance;

    /*
     * WARNING - void declaration
     */
    public PdfRendererCore(@NotNull Context context, @NotNull ParcelFileDescriptor fileDescriptor, @NotNull String cacheIdentifier, @NotNull CacheStrategy cacheStrategy) {
        void it;
        PdfRenderer pdfRenderer;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileDescriptor, (String)"fileDescriptor");
        Intrinsics.checkNotNullParameter((Object)cacheIdentifier, (String)"cacheIdentifier");
        Intrinsics.checkNotNullParameter((Object)((Object)cacheStrategy), (String)"cacheStrategy");
        this.context = context;
        this.fileDescriptor = fileDescriptor;
        this.cacheIdentifier = cacheIdentifier;
        this.cacheStrategy = cacheStrategy;
        this.cacheManager = new CacheManager(this.context, this.cacheIdentifier, this.cacheStrategy);
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.renderLock = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.pageCount = new AtomicInteger(-1);
        this.openPages = new ConcurrentHashMap();
        PdfRenderer pdfRenderer2 = pdfRenderer = new PdfRenderer(this.fileDescriptor);
        PdfRendererCore pdfRendererCore = this;
        boolean bl = false;
        this.isRendererOpen = true;
        this.pageCount.set(it.getPageCount());
        pdfRendererCore.pdfRenderer = pdfRenderer;
        this.isRendererOpen = true;
        this.renderJobs = new ConcurrentHashMap();
        this.pageDimensionCache = new LinkedHashMap();
    }

    @Nullable
    public final Bitmap getBitmapFromCache$pdfViewer_release(int pageNo) {
        return this.cacheManager.getBitmapFromCache(pageNo);
    }

    private final void addBitmapToMemoryCache(int pageNo, Bitmap bitmap) {
        this.cacheManager.addBitmapToCache(pageNo, bitmap);
    }

    public final boolean pageExistInCache(int pageNo) {
        return this.cacheManager.pageExistsInCache(pageNo);
    }

    public final int getPageCount() {
        return !this.isRendererOpen ? 0 : this.pageCount.get();
    }

    public final void renderPage(int pageNo, @NotNull Bitmap bitmap, @Nullable Function3<? super Boolean, ? super Integer, ? super Bitmap, Unit> onBitmapReady) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        long startTime = System.nanoTime();
        if (pageNo >= this.getPageCount()) {
            Function3<? super Boolean, ? super Integer, ? super Bitmap, Unit> function3 = onBitmapReady;
            if (function3 != null) {
                function3.invoke((Object)false, (Object)pageNo, null);
            }
            return;
        }
        Bitmap bitmap2 = this.getBitmapFromCache$pdfViewer_release(pageNo);
        if (bitmap2 != null) {
            Bitmap cachedBitmap = bitmap2;
            boolean bl = false;
            BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(onBitmapReady, pageNo, cachedBitmap, null){
                int label;
                final /* synthetic */ Function3<Boolean, Integer, Bitmap, Unit> $onBitmapReady;
                final /* synthetic */ int $pageNo;
                final /* synthetic */ Bitmap $cachedBitmap;
                {
                    this.$onBitmapReady = $onBitmapReady;
                    this.$pageNo = $pageNo;
                    this.$cachedBitmap = $cachedBitmap;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Function3<Boolean, Integer, Bitmap, Unit> function3 = this.$onBitmapReady;
                            if (function3 != null) {
                                function3.invoke((Object)Boxing.boxBoolean((boolean)true), (Object)Boxing.boxInt((int)this.$pageNo), (Object)this.$cachedBitmap);
                            }
                            if (PdfRendererCore.Companion.getEnableDebugMetrics()) {
                                Log.d((String)"PdfRendererCore", (String)("Page " + this.$pageNo + " loaded from cache"));
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        Job job = this.renderJobs.get(pageNo);
        boolean bl = job != null ? job.isActive() : false;
        if (bl) {
            return;
        }
        Job job2 = this.renderJobs.get(pageNo);
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        Integer n = pageNo;
        ((Map)this.renderJobs).put(n, BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, startTime, pageNo, bitmap, onBitmapReady, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int I$0;
            int label;
            final /* synthetic */ PdfRendererCore this$0;
            final /* synthetic */ long $startTime;
            final /* synthetic */ int $pageNo;
            final /* synthetic */ Bitmap $bitmap;
            final /* synthetic */ Function3<Boolean, Integer, Bitmap, Unit> $onBitmapReady;
            {
                this.this$0 = $receiver;
                this.$startTime = $startTime;
                this.$pageNo = $pageNo;
                this.$bitmap = $bitmap;
                this.$onBitmapReady = $onBitmapReady;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var19_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        success = new Ref.BooleanRef();
                        renderedBitmap = new Ref.ObjectRef();
                        var4_5 = PdfRendererCore.access$getRenderLock$p(this.this$0);
                        var6_7 = this.this$0;
                        var7_8 = this.$pageNo;
                        var8_9 = this.$bitmap;
                        owner$iv = null;
                        $i$f$withLock = false;
                        this.L$0 = success;
                        this.L$1 = renderedBitmap;
                        this.L$2 = $this$withLock_u24default$iv;
                        this.L$3 = var6_7;
                        this.L$4 = var8_9;
                        this.I$0 = var7_8;
                        this.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                        if (v0 == var19_2) {
                            return var19_2;
                        }
                        ** GOTO lbl36
                    }
                    case 1: {
                        $i$f$withLock = false;
                        var7_8 = this.I$0;
                        var8_9 = (Bitmap)this.L$4;
                        var6_7 = (PdfRendererCore)this.L$3;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$2;
                        renderedBitmap = (Ref.ObjectRef)this.L$1;
                        success = (Ref.BooleanRef)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl36:
                        // 2 sources

                        try {
                            $i$a$-withLock$default-PdfRendererCore$renderPage$2$1 = false;
                            if (!PdfRendererCore.access$isRendererOpen$p(var6_7)) {
                                var18_14 = Unit.INSTANCE;
                                return var18_14;
                            }
                            if (PdfRendererCore.access$openPageSafely(var6_7, var7_8) == null) {
                                var17_15 = Unit.INSTANCE;
                                return var17_15;
                            }
                            pdfPage = v1;
                            try {
                                aspectRatio = (float)pdfPage.getWidth() / (float)pdfPage.getHeight();
                                height = var8_9.getHeight();
                                width = (int)((float)height * aspectRatio);
                                tempBitmap = CommonUtils.Companion.BitmapPool.getBitmap$default(CommonUtils.Companion.BitmapPool.INSTANCE, width, height, null, 4, null);
                                pdfPage.render(tempBitmap, null, null, 1);
                                PdfRendererCore.access$addBitmapToMemoryCache(var6_7, var7_8, tempBitmap);
                                success.element = true;
                                renderedBitmap.element = tempBitmap;
                                var12_18 = Unit.INSTANCE;
                            }
                            catch (Exception e) {
                                var12_18 = Boxing.boxInt((int)Log.e((String)"PdfRendererCore", (String)("Error rendering page " + var7_8 + ": " + e.getMessage()), (Throwable)e));
                            }
                            var16_23 = var12_18;
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
                        renderTime = (System.nanoTime() - this.$startTime) / (long)1000000;
                        if (PdfRendererCore.Companion.getEnableDebugMetrics()) {
                            Log.d((String)"PdfRendererCore_Metrics", (String)("Page " + this.$pageNo + " rendered in " + renderTime + "ms"));
                            if (renderTime > 500L) {
                                Log.w((String)"PdfRendererCore_Metrics", (String)("\u26a0\ufe0f Slow render: Page " + this.$pageNo + " took " + renderTime + "ms"));
                            }
                        }
                        PdfRendererCore.access$updateAggregateMetrics(this.this$0, this.$pageNo, renderTime);
                        this.L$0 = null;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.L$3 = null;
                        this.L$4 = null;
                        this.label = 2;
                        v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$onBitmapReady, success, this.$pageNo, (Ref.ObjectRef<Bitmap>)renderedBitmap, null){
                            int label;
                            final /* synthetic */ Function3<Boolean, Integer, Bitmap, Unit> $onBitmapReady;
                            final /* synthetic */ Ref.BooleanRef $success;
                            final /* synthetic */ int $pageNo;
                            final /* synthetic */ Ref.ObjectRef<Bitmap> $renderedBitmap;
                            {
                                this.$onBitmapReady = $onBitmapReady;
                                this.$success = $success;
                                this.$pageNo = $pageNo;
                                this.$renderedBitmap = $renderedBitmap;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        Function3<Boolean, Integer, Bitmap, Unit> function3 = this.$onBitmapReady;
                                        if (function3 != null) {
                                            function3.invoke((Object)Boxing.boxBoolean((boolean)this.$success.element), (Object)Boxing.boxInt((int)this.$pageNo), this.$renderedBitmap.element);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v2 == var19_2) {
                            return var19_2;
                        }
                        ** GOTO lbl87
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl87:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null));
    }

    public static /* synthetic */ void renderPage$default(PdfRendererCore pdfRendererCore, int n, Bitmap bitmap, Function3 function3, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: renderPage");
        }
        if ((n2 & 4) != 0) {
            function3 = null;
        }
        pdfRendererCore.renderPage(n, bitmap, (Function3<? super Boolean, ? super Integer, ? super Bitmap, Unit>)function3);
    }

    @Nullable
    public final Object renderPageAsync(int pageNo, int width, int height, @NotNull Continuation<? super Bitmap> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Bitmap> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        Bitmap bitmap = CommonUtils.Companion.BitmapPool.getBitmap$default(CommonUtils.Companion.BitmapPool.INSTANCE, width, height, null, 4, null);
        this.renderPage(pageNo, bitmap, (Function3<? super Boolean, ? super Integer, ? super Bitmap, Unit>)((Function3)new Function3<Boolean, Integer, Bitmap, Unit>((CancellableContinuation<? super Bitmap>)continuation, bitmap){
            final /* synthetic */ CancellableContinuation<Bitmap> $continuation;
            final /* synthetic */ Bitmap $bitmap;
            {
                this.$continuation = $continuation;
                this.$bitmap = $bitmap;
                super(3);
            }

            public final void invoke(boolean success, int n, @Nullable Bitmap renderedBitmap) {
                if (success) {
                    Bitmap bitmap = renderedBitmap;
                    if (bitmap == null) {
                        bitmap = this.$bitmap;
                    }
                    this.$continuation.resume((Object)bitmap, null);
                } else {
                    CommonUtils.Companion.BitmapPool.INSTANCE.recycleBitmap(this.$bitmap);
                    this.$continuation.resume(null, null);
                }
            }
        }));
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final void updateAggregateMetrics(int page, long duration) {
        int n = this.totalPagesRendered;
        this.totalPagesRendered = n + 1;
        this.totalRenderTime += duration;
        if (duration > this.slowestRenderTime) {
            this.slowestRenderTime = duration;
            this.slowestPage = page;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void prefetchPagesAround(int currentPage, int width, int height, int direction) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        IntRange intRange;
        switch (direction) {
            case 1: {
                intRange = new IntRange(currentPage + 1, currentPage + prefetchDistance);
                break;
            }
            case -1: {
                intRange = RangesKt.until((int)(currentPage - prefetchDistance), (int)currentPage);
                break;
            }
            default: {
                intRange = new IntRange(currentPage - prefetchDistance, currentPage + prefetchDistance);
            }
        }
        IntRange range = intRange;
        Iterable iterable = (Iterable)range;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            boolean bl2 = 0 <= it ? it < this.getPageCount() : false;
            if (!(bl2 && !this.pageExistInCache(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Job job;
            int pageNo = ((Number)element$iv).intValue();
            boolean bl = false;
            Job job2 = this.renderJobs.get(pageNo);
            if (job2 != null ? job2.isActive() : false) continue;
            Job job3 = job = this.renderJobs.get(pageNo);
            if (job3 != null) {
                Intrinsics.checkNotNull((Object)job3);
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            Integer n = pageNo;
            ((Map)this.renderJobs).put(n, BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(width, height, this, pageNo, null){
                int label;
                final /* synthetic */ int $width;
                final /* synthetic */ int $height;
                final /* synthetic */ PdfRendererCore this$0;
                final /* synthetic */ int $pageNo;
                {
                    this.$width = $width;
                    this.$height = $height;
                    this.this$0 = $receiver;
                    this.$pageNo = $pageNo;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Bitmap bitmap = CommonUtils.Companion.BitmapPool.getBitmap$default(CommonUtils.Companion.BitmapPool.INSTANCE, this.$width, this.$height, null, 4, null);
                            this.this$0.renderPage(this.$pageNo, bitmap, (Function3<? super Boolean, ? super Integer, ? super Bitmap, Unit>)((Function3)new Function3<Boolean, Integer, Bitmap, Unit>(bitmap){
                                final /* synthetic */ Bitmap $bitmap;
                                {
                                    this.$bitmap = $bitmap;
                                    super(3);
                                }

                                public final void invoke(boolean success, int n, @Nullable Bitmap bitmap) {
                                    if (!success) {
                                        CommonUtils.Companion.BitmapPool.INSTANCE.recycleBitmap(this.$bitmap);
                                    }
                                }
                            }));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null));
        }
    }

    public static /* synthetic */ void prefetchPagesAround$default(PdfRendererCore pdfRendererCore, int n, int n2, int n3, int n4, int n5, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prefetchPagesAround");
        }
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        pdfRendererCore.prefetchPagesAround(n, n2, n3, n4);
    }

    private final <T> Object withPdfPage(int pageNo, Function1<? super PdfRenderer.Page, ? extends T> block, Continuation<? super T> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(this, pageNo, block, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int I$0;
            int label;
            final /* synthetic */ PdfRendererCore this$0;
            final /* synthetic */ int $pageNo;
            final /* synthetic */ Function1<PdfRenderer.Page, T> $block;
            {
                this.this$0 = $receiver;
                this.$pageNo = $pageNo;
                this.$block = $block;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = PdfRendererCore.access$getRenderLock$p(this.this$0);
                        var4_4 = this.this$0;
                        var5_5 = this.$pageNo;
                        var6_6 = this.$block;
                        owner$iv = null;
                        $i$f$withLock = false;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var4_4;
                        this.L$2 = var6_6;
                        this.I$0 = var5_5;
                        this.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                        if (v0 == var15_2) {
                            return var15_2;
                        }
                        ** GOTO lbl30
                    }
                    case 1: {
                        $i$f$withLock = false;
                        var5_5 = this.I$0;
                        var6_6 = (Function1<PdfRenderer.Page, T>)this.L$2;
                        var4_4 = (PdfRendererCore)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl30:
                        // 2 sources

                        try {
                            $i$a$-withLock$default-PdfRendererCore$withPdfPage$2$1 = false;
                            if (!PdfRendererCore.access$isRendererOpen$p(var4_4)) {
                                var14_11 = null;
                                return var14_11;
                            }
                            if (Build.VERSION.SDK_INT < 34) {
                                PdfRendererCore.access$closeAllOpenPages(var4_4);
                            }
                            try {
                                var9_12 = (AutoCloseable)PdfRendererCore.access$getPdfRenderer$p(var4_4).openPage(var5_5);
                                var10_13 = null;
                                try {
                                    page = (PdfRenderer.Page)var9_12;
                                    $i$a$-use-PdfRendererCore$withPdfPage$2$1$1 = false;
                                    Intrinsics.checkNotNull((Object)page);
                                    var11_15 = var6_6.invoke((Object)page);
                                }
                                catch (Throwable var11_16) {
                                    var10_13 = var11_16;
                                    throw var11_16;
                                }
                                finally {
                                    AutoCloseableKt.closeFinally((AutoCloseable)var9_12, (Throwable)var10_13);
                                }
                                var9_12 = var11_15;
                            }
                            catch (Exception e) {
                                Log.e((String)"PdfRendererCore", (String)("withPdfPage error: " + e.getMessage()), (Throwable)e);
                                var9_12 = null;
                            }
                            var13_19 = var9_12;
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
                        return var13_19;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super T> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    public final void getPageDimensionsAsync(int pageNo, @NotNull Function1<? super Size, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Size size2 = this.pageDimensionCache.get(pageNo);
        if (size2 != null) {
            Size it = size2;
            boolean bl = false;
            callback.invoke((Object)it);
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, pageNo, callback, null){
            int label;
            final /* synthetic */ PdfRendererCore this$0;
            final /* synthetic */ int $pageNo;
            final /* synthetic */ Function1<Size, Unit> $callback;
            {
                this.this$0 = $receiver;
                this.$pageNo = $pageNo;
                this.$callback = $callback;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = PdfRendererCore.access$withPdfPage(this.this$0, this.$pageNo, (Function1)new Function1<PdfRenderer.Page, Size>(this.this$0, this.$pageNo){
                            final /* synthetic */ PdfRendererCore this$0;
                            final /* synthetic */ int $pageNo;
                            {
                                this.this$0 = $receiver;
                                this.$pageNo = $pageNo;
                                super(1);
                            }

                            @NotNull
                            public final Size invoke(@NotNull PdfRenderer.Page page) {
                                Intrinsics.checkNotNullParameter((Object)page, (String)"page");
                                Size size2 = new Size(page.getWidth(), page.getHeight());
                                PdfRendererCore pdfRendererCore = this.this$0;
                                int n = this.$pageNo;
                                Size it = size2;
                                boolean bl = false;
                                Integer n2 = n;
                                PdfRendererCore.access$getPageDimensionCache$p(pdfRendererCore).put(n2, it);
                                return size2;
                            }
                        }, (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((v1 = (Size)v0) == null) {
                            v1 = new Size(1, 1);
                        }
                        size = v1;
                        this.label = 2;
                        v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$callback, size, null){
                            int label;
                            final /* synthetic */ Function1<Size, Unit> $callback;
                            final /* synthetic */ Size $size;
                            {
                                this.$callback = $callback;
                                this.$size = $size;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.$callback.invoke((Object)this.$size);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v2 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl24:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final PdfRenderer.Page openPageSafely(int pageNo) {
        PdfRenderer.Page page;
        if (!this.isRendererOpen) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 34) {
            this.closeAllOpenPages();
        }
        if ((page = this.openPages.get(pageNo)) != null) {
            PdfRenderer.Page it = page;
            boolean bl = false;
            return it;
        }
        try {
            PdfRenderer.Page page2 = this.pdfRenderer.openPage(pageNo);
            Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"openPage(...)");
            PdfRenderer.Page page3 = page2;
            Integer n = pageNo;
            ((Map)this.openPages).put(n, page3);
            if (Build.VERSION.SDK_INT >= 34 && this.openPages.size() > 5) {
                Integer oldest;
                Set set = this.openPages.keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
                Integer n2 = oldest = (Integer)CollectionsKt.minOrNull((Iterable)set);
                if (n2 != null) {
                    int it = ((Number)n2).intValue();
                    boolean bl = false;
                    PdfRenderer.Page page4 = this.openPages.remove(it);
                    if (page4 != null) {
                        page4.close();
                    }
                }
            }
        }
        catch (Exception e) {
            Log.e((String)"PDF_OPEN_TRACKER", (String)("Error opening page " + pageNo + ": " + e.getMessage()), (Throwable)e);
            page = null;
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeAllOpenPages() {
        Iterator iterator = ((Map)this.openPages).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            try {
                ((PdfRenderer.Page)entry.getValue()).close();
            }
            catch (IllegalStateException e) {
                Log.e((String)"PdfRendererCore", (String)("Page " + ((Number)entry.getKey()).intValue() + " was already closed"), (Throwable)e);
            }
            finally {
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closePdfRender() {
        Log.d((String)"PdfRendererCore", (String)"Closing PdfRenderer and releasing resources.");
        JobKt.cancelChildren$default((CoroutineContext)this.scope.getCoroutineContext(), null, (int)1, null);
        this.closeAllOpenPages();
        if (this.isRendererOpen) {
            try {
                this.pdfRenderer.close();
            }
            catch (Exception e) {
                Log.e((String)"PdfRendererCore", (String)("Error closing PdfRenderer: " + e.getMessage()), (Throwable)e);
            }
            finally {
                this.isRendererOpen = false;
            }
        }
        try {
            this.fileDescriptor.close();
        }
        catch (Exception e) {
            Log.e((String)"PdfRendererCore", (String)("Error closing file descriptor: " + e.getMessage()), (Throwable)e);
        }
    }

    public static final /* synthetic */ Mutex access$getRenderLock$p(PdfRendererCore $this) {
        return $this.renderLock;
    }

    public static final /* synthetic */ void access$updateAggregateMetrics(PdfRendererCore $this, int page, long duration) {
        $this.updateAggregateMetrics(page, duration);
    }

    public static final /* synthetic */ boolean access$isRendererOpen$p(PdfRendererCore $this) {
        return $this.isRendererOpen;
    }

    public static final /* synthetic */ PdfRenderer.Page access$openPageSafely(PdfRendererCore $this, int pageNo) {
        return $this.openPageSafely(pageNo);
    }

    public static final /* synthetic */ void access$addBitmapToMemoryCache(PdfRendererCore $this, int pageNo, Bitmap bitmap) {
        $this.addBitmapToMemoryCache(pageNo, bitmap);
    }

    public static final /* synthetic */ Object access$withPdfPage(PdfRendererCore $this, int pageNo, Function1 block, Continuation $completion) {
        return $this.withPdfPage(pageNo, block, $completion);
    }

    public static final /* synthetic */ void access$closeAllOpenPages(PdfRendererCore $this) {
        $this.closeAllOpenPages();
    }

    public static final /* synthetic */ PdfRenderer access$getPdfRenderer$p(PdfRendererCore $this) {
        return $this.pdfRenderer;
    }

    public static final /* synthetic */ Map access$getPageDimensionCache$p(PdfRendererCore $this) {
        return $this.pageDimensionCache;
    }

    static {
        prefetchDistance = 2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/rajat/pdfviewer/PdfRendererCore$Companion;", "", "()V", "enableDebugMetrics", "", "getEnableDebugMetrics", "()Z", "setEnableDebugMetrics", "(Z)V", "prefetchDistance", "", "getPrefetchDistance", "()I", "setPrefetchDistance", "(I)V", "getCacheIdentifierFromFile", "", "file", "Ljava/io/File;", "getCacheIdentifierFromFile$pdfViewer_release", "getFileDescriptor", "Landroid/os/ParcelFileDescriptor;", "getFileDescriptor$pdfViewer_release", "sanitizeFilePath", "filePath", "pdfViewer_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getEnableDebugMetrics() {
            return enableDebugMetrics;
        }

        public final void setEnableDebugMetrics(boolean bl) {
            enableDebugMetrics = bl;
        }

        public final int getPrefetchDistance() {
            return prefetchDistance;
        }

        public final void setPrefetchDistance(int n) {
            prefetchDistance = n;
        }

        private final String sanitizeFilePath(String filePath) {
            String string;
            try {
                Path path;
                string = Build.VERSION.SDK_INT >= 26 ? (Files.exists(path = Paths.get(filePath, new String[0]), new LinkOption[0]) ? filePath : "") : filePath;
            }
            catch (Exception e) {
                string = "";
            }
            return string;
        }

        @NotNull
        public final ParcelFileDescriptor getFileDescriptor$pdfViewer_release(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            File safeFile = new File(this.sanitizeFilePath(string));
            ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open((File)safeFile, (int)0x10000000);
            Intrinsics.checkNotNullExpressionValue((Object)parcelFileDescriptor, (String)"open(...)");
            return parcelFileDescriptor;
        }

        @NotNull
        public final String getCacheIdentifierFromFile$pdfViewer_release(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return file.getName().toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

