/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.markup.builder;

import io.github.swagger2markup.markup.builder.LineSeparator;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.markup.builder.MarkupLanguage;
import io.github.swagger2markup.markup.builder.internal.asciidoc.AsciiDocBuilder;
import io.github.swagger2markup.markup.builder.internal.confluenceMarkup.ConfluenceMarkupBuilder;
import io.github.swagger2markup.markup.builder.internal.markdown.MarkdownBuilder;

public final class MarkupDocBuilders {
    private MarkupDocBuilders() {
    }

    public static MarkupDocBuilder documentBuilder(MarkupLanguage markupLanguage) {
        switch (markupLanguage) {
            case MARKDOWN: {
                return new MarkdownBuilder();
            }
            case ASCIIDOC: {
                return new AsciiDocBuilder();
            }
            case CONFLUENCE_MARKUP: {
                return new ConfluenceMarkupBuilder();
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported markup language %s", new Object[]{markupLanguage}));
    }

    public static MarkupDocBuilder documentBuilder(MarkupLanguage markupLanguage, LineSeparator lineSeparator) {
        switch (markupLanguage) {
            case MARKDOWN: {
                if (lineSeparator == null) {
                    return new MarkdownBuilder();
                }
                return new MarkdownBuilder(lineSeparator.toString());
            }
            case ASCIIDOC: {
                if (lineSeparator == null) {
                    return new AsciiDocBuilder();
                }
                return new AsciiDocBuilder(lineSeparator.toString());
            }
            case CONFLUENCE_MARKUP: {
                if (lineSeparator == null) {
                    return new ConfluenceMarkupBuilder();
                }
                return new ConfluenceMarkupBuilder(lineSeparator.toString());
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported markup language %s", new Object[]{markupLanguage}));
    }

    public static MarkupDocBuilder documentBuilder(MarkupLanguage markupLanguage, LineSeparator lineSeparator, int asciidocPegdownTimeoutMillis) {
        switch (markupLanguage) {
            case MARKDOWN: {
                if (lineSeparator == null) {
                    return new MarkdownBuilder();
                }
                return new MarkdownBuilder(lineSeparator.toString());
            }
            case ASCIIDOC: {
                if (lineSeparator == null) {
                    return new AsciiDocBuilder(asciidocPegdownTimeoutMillis);
                }
                return new AsciiDocBuilder(lineSeparator.toString(), asciidocPegdownTimeoutMillis);
            }
            case CONFLUENCE_MARKUP: {
                if (lineSeparator == null) {
                    return new ConfluenceMarkupBuilder();
                }
                return new ConfluenceMarkupBuilder(lineSeparator.toString());
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported markup language %s", new Object[]{markupLanguage}));
    }
}

