/*
 * Decompiled with CFR 0.152.
 */
package io.github.adraffy.ens;

import io.github.adraffy.ens.IntList;
import io.github.adraffy.ens.StringUtils;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;

public class Decoder {
    private final IntBuffer buf;
    private final int[] magic;
    private int word = 0;
    private int bits = 0;

    static int asSigned(int i) {
        return (i & 1) != 0 ? ~i >> 1 : i >> 1;
    }

    public Decoder(IntBuffer buf) {
        this.buf = buf;
        this.magic = this.readMagic();
    }

    private int[] readMagic() {
        int dw;
        ArrayList<Integer> list = new ArrayList<Integer>();
        int w = 0;
        while ((dw = this.readUnary()) != 0) {
            list.add(w += dw);
        }
        return list.stream().mapToInt(x -> x).toArray();
    }

    public boolean readBit() {
        if (this.bits == 0) {
            this.word = this.buf.get();
            this.bits = 1;
        }
        boolean bit = (this.word & this.bits) != 0;
        this.bits <<= 1;
        return bit;
    }

    public int readUnary() {
        int x = 0;
        while (this.readBit()) {
            ++x;
        }
        return x;
    }

    public int readBinary(int w) {
        int x = 0;
        for (int b = 1 << w - 1; b != 0; b >>= 1) {
            if (!this.readBit()) continue;
            x |= b;
        }
        return x;
    }

    public int readUnsigned() {
        int w;
        int a = 0;
        int i = 0;
        while (true) {
            w = this.magic[i];
            int n = 1 << w;
            if (++i == this.magic.length || !this.readBit()) break;
            a += n;
        }
        return a + this.readBinary(w);
    }

    public int[] readSortedAscending(int n) {
        return this.readArray(n, (prev, x) -> prev + 1 + x);
    }

    public int[] readUnsortedDeltas(int n) {
        return this.readArray(n, (prev, x) -> prev + Decoder.asSigned(x));
    }

    public int[] readArray(int count, ReadArrayFunction fn) {
        int[] v = new int[count];
        int prev = -1;
        for (int i = 0; i < count; ++i) {
            v[i] = prev = fn.get(prev, this.readUnsigned());
        }
        return v;
    }

    public int[] readUnique() {
        int pos = this.readUnsigned();
        int[] v = this.readSortedAscending(pos);
        int n = this.readUnsigned();
        if (n > 0) {
            int[] vX = this.readSortedAscending(n);
            int[] vS = this.readUnsortedDeltas(n);
            v = Arrays.copyOf(v, pos + Arrays.stream(vS).sum());
            for (int i = 0; i < n; ++i) {
                int x = vX[i];
                int e = x + vS[i];
                while (x < e) {
                    v[pos++] = x++;
                }
            }
        }
        return v;
    }

    public <T> ArrayList<T> readTree(Function<int[], T> fn) {
        ArrayList ret = new ArrayList();
        this.readTree(ret, fn, new IntList());
        return ret;
    }

    private <T> void readTree(ArrayList<T> ret, Function<int[], T> fn, IntList path) {
        int x;
        int n;
        int i = path.count;
        path.add(0);
        int[] nArray = this.readSortedAscending(this.readUnsigned());
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            path.array[i] = x = nArray[n];
            ret.add(fn.apply(path.toArray()));
        }
        nArray = this.readSortedAscending(this.readUnsigned());
        n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            path.array[i] = x = nArray[n];
            this.readTree(ret, fn, path);
        }
        path.count = i;
    }

    public String readString() {
        return StringUtils.implode(this.readUnsortedDeltas(this.readUnsigned()));
    }

    public int[] readSortedUnique() {
        int[] v = this.readUnique();
        Arrays.sort(v);
        return v;
    }

    public static interface ReadArrayFunction {
        public int get(int var1, int var2);
    }
}

