/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.transport.grpc.handler;

import com.google.protobuf.Empty;
import io.a2a.grpc.A2AServiceGrpc;
import io.a2a.grpc.CancelTaskRequest;
import io.a2a.grpc.CancelTaskRequestOrBuilder;
import io.a2a.grpc.CreateTaskPushNotificationConfigRequest;
import io.a2a.grpc.CreateTaskPushNotificationConfigRequestOrBuilder;
import io.a2a.grpc.DeleteTaskPushNotificationConfigRequest;
import io.a2a.grpc.DeleteTaskPushNotificationConfigRequestOrBuilder;
import io.a2a.grpc.GetAgentCardRequest;
import io.a2a.grpc.GetTaskPushNotificationConfigRequest;
import io.a2a.grpc.GetTaskPushNotificationConfigRequestOrBuilder;
import io.a2a.grpc.GetTaskRequest;
import io.a2a.grpc.GetTaskRequestOrBuilder;
import io.a2a.grpc.ListTaskPushNotificationConfigRequest;
import io.a2a.grpc.ListTaskPushNotificationConfigRequestOrBuilder;
import io.a2a.grpc.ListTaskPushNotificationConfigResponse;
import io.a2a.grpc.SendMessageRequest;
import io.a2a.grpc.SendMessageRequestOrBuilder;
import io.a2a.grpc.SendMessageResponse;
import io.a2a.grpc.StreamResponse;
import io.a2a.grpc.Task;
import io.a2a.grpc.TaskPushNotificationConfig;
import io.a2a.grpc.TaskSubscriptionRequest;
import io.a2a.grpc.TaskSubscriptionRequestOrBuilder;
import io.a2a.grpc.utils.ProtoUtils;
import io.a2a.server.AgentCardValidator;
import io.a2a.server.ServerCallContext;
import io.a2a.server.auth.UnauthenticatedUser;
import io.a2a.server.auth.User;
import io.a2a.server.extensions.A2AExtensions;
import io.a2a.server.requesthandlers.RequestHandler;
import io.a2a.spec.AgentCard;
import io.a2a.spec.ContentTypeNotSupportedError;
import io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import io.a2a.spec.EventKind;
import io.a2a.spec.GetTaskPushNotificationConfigParams;
import io.a2a.spec.InternalError;
import io.a2a.spec.InvalidAgentResponseError;
import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.InvalidRequestError;
import io.a2a.spec.JSONParseError;
import io.a2a.spec.JSONRPCError;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.MethodNotFoundError;
import io.a2a.spec.PushNotificationNotSupportedError;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskNotCancelableError;
import io.a2a.spec.TaskNotFoundError;
import io.a2a.spec.TaskQueryParams;
import io.a2a.spec.UnsupportedOperationError;
import io.a2a.transport.grpc.context.GrpcContextKeys;
import io.a2a.transport.grpc.handler.CallContextFactory;
import io.grpc.Context;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import jakarta.enterprise.inject.Vetoed;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

@Vetoed
public abstract class GrpcHandler
extends A2AServiceGrpc.A2AServiceImplBase {
    private static volatile Runnable streamingSubscribedRunnable;
    private AtomicBoolean initialised = new AtomicBoolean(false);
    private static final Logger LOGGER;

    public void sendMessage(SendMessageRequest request, StreamObserver<SendMessageResponse> responseObserver) {
        try {
            ServerCallContext context = this.createCallContext(responseObserver);
            MessageSendParams params = ProtoUtils.FromProto.messageSendParams((SendMessageRequestOrBuilder)request);
            EventKind taskOrMessage = this.getRequestHandler().onMessageSend(params, context);
            SendMessageResponse response = ProtoUtils.ToProto.taskOrMessage((EventKind)taskOrMessage);
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (JSONRPCError e) {
            this.handleError(responseObserver, e);
        }
        catch (SecurityException e) {
            this.handleSecurityException(responseObserver, e);
        }
        catch (Throwable t) {
            this.handleInternalError(responseObserver, t);
        }
    }

    public void getTask(GetTaskRequest request, StreamObserver<Task> responseObserver) {
        try {
            ServerCallContext context = this.createCallContext(responseObserver);
            TaskQueryParams params = ProtoUtils.FromProto.taskQueryParams((GetTaskRequestOrBuilder)request);
            io.a2a.spec.Task task = this.getRequestHandler().onGetTask(params, context);
            if (task != null) {
                responseObserver.onNext((Object)ProtoUtils.ToProto.task((io.a2a.spec.Task)task));
                responseObserver.onCompleted();
            } else {
                this.handleError(responseObserver, (JSONRPCError)new TaskNotFoundError());
            }
        }
        catch (JSONRPCError e) {
            this.handleError(responseObserver, e);
        }
        catch (SecurityException e) {
            this.handleSecurityException(responseObserver, e);
        }
        catch (Throwable t) {
            this.handleInternalError(responseObserver, t);
        }
    }

    public void cancelTask(CancelTaskRequest request, StreamObserver<Task> responseObserver) {
        try {
            ServerCallContext context = this.createCallContext(responseObserver);
            TaskIdParams params = ProtoUtils.FromProto.taskIdParams((CancelTaskRequestOrBuilder)request);
            io.a2a.spec.Task task = this.getRequestHandler().onCancelTask(params, context);
            if (task != null) {
                responseObserver.onNext((Object)ProtoUtils.ToProto.task((io.a2a.spec.Task)task));
                responseObserver.onCompleted();
            } else {
                this.handleError(responseObserver, (JSONRPCError)new TaskNotFoundError());
            }
        }
        catch (JSONRPCError e) {
            this.handleError(responseObserver, e);
        }
        catch (SecurityException e) {
            this.handleSecurityException(responseObserver, e);
        }
        catch (Throwable t) {
            this.handleInternalError(responseObserver, t);
        }
    }

    public void createTaskPushNotificationConfig(CreateTaskPushNotificationConfigRequest request, StreamObserver<TaskPushNotificationConfig> responseObserver) {
        if (!this.getAgentCardInternal().capabilities().pushNotifications()) {
            this.handleError(responseObserver, (JSONRPCError)new PushNotificationNotSupportedError());
            return;
        }
        try {
            ServerCallContext context = this.createCallContext(responseObserver);
            io.a2a.spec.TaskPushNotificationConfig config = ProtoUtils.FromProto.taskPushNotificationConfig((CreateTaskPushNotificationConfigRequestOrBuilder)request);
            io.a2a.spec.TaskPushNotificationConfig responseConfig = this.getRequestHandler().onSetTaskPushNotificationConfig(config, context);
            responseObserver.onNext((Object)ProtoUtils.ToProto.taskPushNotificationConfig((io.a2a.spec.TaskPushNotificationConfig)responseConfig));
            responseObserver.onCompleted();
        }
        catch (JSONRPCError e) {
            this.handleError(responseObserver, e);
        }
        catch (SecurityException e) {
            this.handleSecurityException(responseObserver, e);
        }
        catch (Throwable t) {
            this.handleInternalError(responseObserver, t);
        }
    }

    public void getTaskPushNotificationConfig(GetTaskPushNotificationConfigRequest request, StreamObserver<TaskPushNotificationConfig> responseObserver) {
        if (!this.getAgentCardInternal().capabilities().pushNotifications()) {
            this.handleError(responseObserver, (JSONRPCError)new PushNotificationNotSupportedError());
            return;
        }
        try {
            ServerCallContext context = this.createCallContext(responseObserver);
            GetTaskPushNotificationConfigParams params = ProtoUtils.FromProto.getTaskPushNotificationConfigParams((GetTaskPushNotificationConfigRequestOrBuilder)request);
            io.a2a.spec.TaskPushNotificationConfig config = this.getRequestHandler().onGetTaskPushNotificationConfig(params, context);
            responseObserver.onNext((Object)ProtoUtils.ToProto.taskPushNotificationConfig((io.a2a.spec.TaskPushNotificationConfig)config));
            responseObserver.onCompleted();
        }
        catch (JSONRPCError e) {
            this.handleError(responseObserver, e);
        }
        catch (SecurityException e) {
            this.handleSecurityException(responseObserver, e);
        }
        catch (Throwable t) {
            this.handleInternalError(responseObserver, t);
        }
    }

    public void listTaskPushNotificationConfig(ListTaskPushNotificationConfigRequest request, StreamObserver<ListTaskPushNotificationConfigResponse> responseObserver) {
        if (!this.getAgentCardInternal().capabilities().pushNotifications()) {
            this.handleError(responseObserver, (JSONRPCError)new PushNotificationNotSupportedError());
            return;
        }
        try {
            ServerCallContext context = this.createCallContext(responseObserver);
            ListTaskPushNotificationConfigParams params = ProtoUtils.FromProto.listTaskPushNotificationConfigParams((ListTaskPushNotificationConfigRequestOrBuilder)request);
            List configList = this.getRequestHandler().onListTaskPushNotificationConfig(params, context);
            ListTaskPushNotificationConfigResponse.Builder responseBuilder = ListTaskPushNotificationConfigResponse.newBuilder();
            for (io.a2a.spec.TaskPushNotificationConfig config : configList) {
                responseBuilder.addConfigs(ProtoUtils.ToProto.taskPushNotificationConfig((io.a2a.spec.TaskPushNotificationConfig)config));
            }
            responseObserver.onNext((Object)responseBuilder.build());
            responseObserver.onCompleted();
        }
        catch (JSONRPCError e) {
            this.handleError(responseObserver, e);
        }
        catch (SecurityException e) {
            this.handleSecurityException(responseObserver, e);
        }
        catch (Throwable t) {
            this.handleInternalError(responseObserver, t);
        }
    }

    public void sendStreamingMessage(SendMessageRequest request, StreamObserver<StreamResponse> responseObserver) {
        if (!this.getAgentCardInternal().capabilities().streaming()) {
            this.handleError(responseObserver, (JSONRPCError)new InvalidRequestError());
            return;
        }
        try {
            ServerCallContext context = this.createCallContext(responseObserver);
            MessageSendParams params = ProtoUtils.FromProto.messageSendParams((SendMessageRequestOrBuilder)request);
            Flow.Publisher publisher = this.getRequestHandler().onMessageSendStream(params, context);
            this.convertToStreamResponse(publisher, responseObserver);
        }
        catch (JSONRPCError e) {
            this.handleError(responseObserver, e);
        }
        catch (SecurityException e) {
            this.handleSecurityException(responseObserver, e);
        }
        catch (Throwable t) {
            this.handleInternalError(responseObserver, t);
        }
    }

    public void taskSubscription(TaskSubscriptionRequest request, StreamObserver<StreamResponse> responseObserver) {
        if (!this.getAgentCardInternal().capabilities().streaming()) {
            this.handleError(responseObserver, (JSONRPCError)new InvalidRequestError());
            return;
        }
        try {
            ServerCallContext context = this.createCallContext(responseObserver);
            TaskIdParams params = ProtoUtils.FromProto.taskIdParams((TaskSubscriptionRequestOrBuilder)request);
            Flow.Publisher publisher = this.getRequestHandler().onResubscribeToTask(params, context);
            this.convertToStreamResponse(publisher, responseObserver);
        }
        catch (JSONRPCError e) {
            this.handleError(responseObserver, e);
        }
        catch (SecurityException e) {
            this.handleSecurityException(responseObserver, e);
        }
        catch (Throwable t) {
            this.handleInternalError(responseObserver, t);
        }
    }

    private void convertToStreamResponse(Flow.Publisher<StreamingEventKind> publisher, final StreamObserver<StreamResponse> responseObserver) {
        CompletableFuture.runAsync(() -> publisher.subscribe(new Flow.Subscriber<StreamingEventKind>(){
            private Flow.Subscription subscription;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                subscription.request(1L);
                Runnable runnable = streamingSubscribedRunnable;
                if (runnable != null) {
                    runnable.run();
                }
            }

            @Override
            public void onNext(StreamingEventKind event) {
                StreamResponse response = ProtoUtils.ToProto.streamResponse((StreamingEventKind)event);
                responseObserver.onNext((Object)response);
                if (response.hasStatusUpdate() && response.getStatusUpdate().getFinal()) {
                    responseObserver.onCompleted();
                } else {
                    this.subscription.request(1L);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                if (throwable instanceof JSONRPCError) {
                    JSONRPCError jsonrpcError = (JSONRPCError)throwable;
                    GrpcHandler.this.handleError(responseObserver, jsonrpcError);
                } else {
                    GrpcHandler.this.handleInternalError(responseObserver, throwable);
                }
                responseObserver.onCompleted();
            }

            @Override
            public void onComplete() {
                responseObserver.onCompleted();
            }
        }), this.getExecutor());
    }

    public void getAgentCard(GetAgentCardRequest request, StreamObserver<io.a2a.grpc.AgentCard> responseObserver) {
        try {
            responseObserver.onNext((Object)ProtoUtils.ToProto.agentCard((AgentCard)this.getAgentCardInternal()));
            responseObserver.onCompleted();
        }
        catch (Throwable t) {
            this.handleInternalError(responseObserver, t);
        }
    }

    public void deleteTaskPushNotificationConfig(DeleteTaskPushNotificationConfigRequest request, StreamObserver<Empty> responseObserver) {
        if (!this.getAgentCardInternal().capabilities().pushNotifications()) {
            this.handleError(responseObserver, (JSONRPCError)new PushNotificationNotSupportedError());
            return;
        }
        try {
            ServerCallContext context = this.createCallContext(responseObserver);
            DeleteTaskPushNotificationConfigParams params = ProtoUtils.FromProto.deleteTaskPushNotificationConfigParams((DeleteTaskPushNotificationConfigRequestOrBuilder)request);
            this.getRequestHandler().onDeleteTaskPushNotificationConfig(params, context);
            responseObserver.onNext((Object)Empty.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (JSONRPCError e) {
            this.handleError(responseObserver, e);
        }
        catch (SecurityException e) {
            this.handleSecurityException(responseObserver, e);
        }
        catch (Throwable t) {
            this.handleInternalError(responseObserver, t);
        }
    }

    private <V> ServerCallContext createCallContext(StreamObserver<V> responseObserver) {
        CallContextFactory factory = this.getCallContextFactory();
        if (factory == null) {
            UnauthenticatedUser user = UnauthenticatedUser.INSTANCE;
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("grpc_response_observer", responseObserver);
            try {
                Context currentContext = Context.current();
                if (currentContext != null) {
                    String peerInfo;
                    String methodName;
                    state.put("grpc_context", currentContext);
                    Metadata grpcMetadata = (Metadata)GrpcContextKeys.METADATA_KEY.get(currentContext);
                    if (grpcMetadata != null) {
                        state.put("grpc_metadata", grpcMetadata);
                    }
                    if ((methodName = (String)GrpcContextKeys.METHOD_NAME_KEY.get(currentContext)) != null) {
                        state.put("grpc_method_name", methodName);
                    }
                    if ((peerInfo = (String)GrpcContextKeys.PEER_INFO_KEY.get(currentContext)) != null) {
                        state.put("grpc_peer_info", peerInfo);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.fine(() -> "Error getting data from current context" + String.valueOf(e));
            }
            Set requestedExtensions = new HashSet();
            String extensionsHeader = this.getExtensionsFromContext();
            if (extensionsHeader != null) {
                requestedExtensions = A2AExtensions.getRequestedExtensions(List.of(extensionsHeader));
            }
            return new ServerCallContext((User)user, state, requestedExtensions);
        }
        return factory.create(responseObserver);
    }

    private <V> void handleError(StreamObserver<V> responseObserver, JSONRPCError error) {
        String description;
        Status status;
        if (error instanceof InvalidRequestError) {
            status = Status.INVALID_ARGUMENT;
            description = "InvalidRequestError: " + error.getMessage();
        } else if (error instanceof MethodNotFoundError) {
            status = Status.NOT_FOUND;
            description = "MethodNotFoundError: " + error.getMessage();
        } else if (error instanceof InvalidParamsError) {
            status = Status.INVALID_ARGUMENT;
            description = "InvalidParamsError: " + error.getMessage();
        } else if (error instanceof InternalError) {
            status = Status.INTERNAL;
            description = "InternalError: " + error.getMessage();
        } else if (error instanceof TaskNotFoundError) {
            status = Status.NOT_FOUND;
            description = "TaskNotFoundError: " + error.getMessage();
        } else if (error instanceof TaskNotCancelableError) {
            status = Status.UNIMPLEMENTED;
            description = "TaskNotCancelableError: " + error.getMessage();
        } else if (error instanceof PushNotificationNotSupportedError) {
            status = Status.UNIMPLEMENTED;
            description = "PushNotificationNotSupportedError: " + error.getMessage();
        } else if (error instanceof UnsupportedOperationError) {
            status = Status.UNIMPLEMENTED;
            description = "UnsupportedOperationError: " + error.getMessage();
        } else if (error instanceof JSONParseError) {
            status = Status.INTERNAL;
            description = "JSONParseError: " + error.getMessage();
        } else if (error instanceof ContentTypeNotSupportedError) {
            status = Status.UNIMPLEMENTED;
            description = "ContentTypeNotSupportedError: " + error.getMessage();
        } else if (error instanceof InvalidAgentResponseError) {
            status = Status.INTERNAL;
            description = "InvalidAgentResponseError: " + error.getMessage();
        } else {
            status = Status.UNKNOWN;
            description = "Unknown error type: " + error.getMessage();
        }
        responseObserver.onError((Throwable)status.withDescription(description).asRuntimeException());
    }

    private <V> void handleSecurityException(StreamObserver<V> responseObserver, SecurityException e) {
        Object description;
        Status status;
        String exceptionClassName = e.getClass().getName();
        if (exceptionClassName.contains("Unauthorized") || exceptionClassName.contains("Unauthenticated") || exceptionClassName.contains("Authentication")) {
            status = Status.UNAUTHENTICATED;
            description = "Authentication failed: Client credentials are missing or invalid";
        } else if (exceptionClassName.contains("Forbidden") || exceptionClassName.contains("AccessDenied") || exceptionClassName.contains("Authorization")) {
            status = Status.PERMISSION_DENIED;
            description = "Authorization failed: Client does not have permission for the operation";
        } else {
            status = Status.PERMISSION_DENIED;
            description = "Authorization failed: " + (e.getMessage() != null ? e.getMessage() : "Access denied");
        }
        responseObserver.onError((Throwable)status.withDescription((String)description).asRuntimeException());
    }

    private <V> void handleInternalError(StreamObserver<V> responseObserver, Throwable t) {
        this.handleError(responseObserver, (JSONRPCError)new InternalError(t.getMessage()));
    }

    private AgentCard getAgentCardInternal() {
        AgentCard agentCard = this.getAgentCard();
        if (this.initialised.compareAndSet(false, true)) {
            this.validateTransportConfigurationWithCorrectClassLoader(agentCard);
        }
        return agentCard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateTransportConfigurationWithCorrectClassLoader(AgentCard agentCard) {
        ClassLoader originalTccl = Thread.currentThread().getContextClassLoader();
        ClassLoader deploymentCl = this.getDeploymentClassLoader();
        boolean switchCl = deploymentCl != null && deploymentCl != originalTccl;
        try {
            if (switchCl) {
                Thread.currentThread().setContextClassLoader(deploymentCl);
            }
            AgentCardValidator.validateTransportConfiguration((AgentCard)agentCard);
        }
        finally {
            if (switchCl) {
                Thread.currentThread().setContextClassLoader(originalTccl);
            }
        }
    }

    protected ClassLoader getDeploymentClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    public static void setStreamingSubscribedRunnable(Runnable runnable) {
        streamingSubscribedRunnable = runnable;
    }

    protected abstract RequestHandler getRequestHandler();

    protected abstract AgentCard getAgentCard();

    protected abstract CallContextFactory getCallContextFactory();

    protected abstract Executor getExecutor();

    private String getExtensionsFromContext() {
        try {
            return (String)GrpcContextKeys.EXTENSIONS_HEADER_KEY.get();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static <T> T getFromContext(Context.Key<T> key) {
        try {
            return (T)key.get();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static Metadata getCurrentMetadata() {
        return GrpcHandler.getFromContext(GrpcContextKeys.METADATA_KEY);
    }

    protected static String getCurrentMethodName() {
        return GrpcHandler.getFromContext(GrpcContextKeys.METHOD_NAME_KEY);
    }

    protected static String getCurrentPeerInfo() {
        return GrpcHandler.getFromContext(GrpcContextKeys.PEER_INFO_KEY);
    }

    static {
        LOGGER = Logger.getLogger(GrpcHandler.class.getName());
    }
}

