/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.util;

import io.a2a.spec.InvalidParamsError;
import java.time.Instant;
import org.jspecify.annotations.Nullable;

public record PageToken(Instant timestamp, String id) {
    public static @Nullable PageToken fromString(@Nullable String tokenStr) {
        if (tokenStr == null || tokenStr.isEmpty()) {
            return null;
        }
        String[] tokenParts = tokenStr.split(":", 2);
        if (tokenParts.length != 2) {
            throw new InvalidParamsError(null, "Invalid pageToken format: expected 'timestamp:id'", null);
        }
        try {
            long timestampMillis = Long.parseLong(tokenParts[0]);
            String id = tokenParts[1];
            if (id.isEmpty()) {
                throw new InvalidParamsError(null, "Invalid pageToken format: id part cannot be empty", null);
            }
            return new PageToken(Instant.ofEpochMilli(timestampMillis), id);
        }
        catch (NumberFormatException e) {
            throw new InvalidParamsError(null, "Invalid pageToken format: timestamp must be numeric milliseconds", null);
        }
    }

    @Override
    public String toString() {
        return this.timestamp.toEpochMilli() + ":" + this.id;
    }
}

