/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import com.google.gson.annotations.SerializedName;
import io.a2a.spec.EventKind;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.TaskState;
import io.a2a.spec.TaskStatus;
import io.a2a.spec.UpdateEvent;
import io.a2a.util.Assert;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public record TaskStatusUpdateEvent(String taskId, TaskStatus status, String contextId, @SerializedName(value="final") boolean isFinal, @Nullable Map<String, Object> metadata) implements EventKind,
StreamingEventKind,
UpdateEvent
{
    public static final String STREAMING_EVENT_ID = "statusUpdate";

    public TaskStatusUpdateEvent(String taskId, TaskStatus status, String contextId, boolean isFinal, @Nullable Map<String, Object> metadata) {
        Assert.checkNotNullParam((String)"taskId", (Object)taskId);
        Assert.checkNotNullParam((String)"status", (Object)status);
        Assert.checkNotNullParam((String)"contextId", (Object)contextId);
        if (isFinal != status.state().isFinal()) {
            throw new IllegalArgumentException("isFinal must be the same as the Status state");
        }
    }

    @Override
    public String kind() {
        return STREAMING_EVENT_ID;
    }

    public boolean isFinalOrInterrupted() {
        return this.status.state() == TaskState.TASK_STATE_COMPLETED || this.status.state() == TaskState.TASK_STATE_FAILED || this.status.state() == TaskState.TASK_STATE_CANCELED || this.status.state() == TaskState.TASK_STATE_REJECTED || this.status.state() == TaskState.TASK_STATE_INPUT_REQUIRED;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TaskStatusUpdateEvent event) {
        return new Builder(event);
    }

    public static class Builder {
        private @Nullable String taskId;
        private @Nullable TaskStatus status;
        private @Nullable String contextId;
        private @Nullable Map<String, Object> metadata;

        private Builder() {
        }

        private Builder(TaskStatusUpdateEvent existingTaskStatusUpdateEvent) {
            this.taskId = existingTaskStatusUpdateEvent.taskId;
            this.status = existingTaskStatusUpdateEvent.status;
            this.contextId = existingTaskStatusUpdateEvent.contextId;
            this.metadata = existingTaskStatusUpdateEvent.metadata;
        }

        public Builder taskId(String id) {
            this.taskId = id;
            return this;
        }

        public Builder status(TaskStatus status) {
            this.status = status;
            return this;
        }

        public Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public TaskStatusUpdateEvent build() {
            return new TaskStatusUpdateEvent((String)Assert.checkNotNullParam((String)"taskId", (Object)this.taskId), (TaskStatus)Assert.checkNotNullParam((String)"status", (Object)this.status), (String)Assert.checkNotNullParam((String)"contextId", (Object)this.contextId), ((TaskStatus)Assert.checkNotNullParam((String)"status", (Object)this.status)).state().isFinal(), this.metadata);
        }
    }
}

