/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import io.a2a.spec.OAuthFlows;
import io.a2a.spec.SecurityScheme;
import io.a2a.util.Assert;
import org.jspecify.annotations.Nullable;

public record OAuth2SecurityScheme(OAuthFlows flows, @Nullable String description, @Nullable String oauth2MetadataUrl) implements SecurityScheme
{
    public static final String TYPE = "oauth2SecurityScheme";

    public OAuth2SecurityScheme(OAuthFlows flows, @Nullable String description, @Nullable String oauth2MetadataUrl) {
        Assert.checkNotNullParam((String)"flows", (Object)flows);
    }

    @Override
    public String type() {
        return TYPE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private @Nullable OAuthFlows flows;
        private @Nullable String description;
        private @Nullable String oauth2MetadataUrl;

        private Builder() {
        }

        public Builder flows(OAuthFlows flows) {
            this.flows = flows;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder oauth2MetadataUrl(String oauth2MetadataUrl) {
            this.oauth2MetadataUrl = oauth2MetadataUrl;
            return this;
        }

        public OAuth2SecurityScheme build() {
            return new OAuth2SecurityScheme((OAuthFlows)Assert.checkNotNullParam((String)"flows", (Object)this.flows), this.description, this.oauth2MetadataUrl);
        }
    }
}

