/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import io.a2a.spec.Message;
import io.a2a.spec.MessageSendConfiguration;
import io.a2a.util.Assert;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public record MessageSendParams(Message message, @Nullable MessageSendConfiguration configuration, @Nullable Map<String, Object> metadata, String tenant) {
    public MessageSendParams(Message message, @Nullable MessageSendConfiguration configuration, @Nullable Map<String, Object> metadata, String tenant) {
        Assert.checkNotNullParam((String)"message", (Object)message);
        Assert.checkNotNullParam((String)"tenant", (Object)tenant);
    }

    public MessageSendParams(Message message, @Nullable MessageSendConfiguration configuration, @Nullable Map<String, Object> metadata) {
        this(message, configuration, metadata, "");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable Message message;
        @Nullable MessageSendConfiguration configuration;
        @Nullable Map<String, Object> metadata;
        @Nullable String tenant;

        private Builder() {
        }

        public Builder message(Message message) {
            this.message = message;
            return this;
        }

        public Builder configuration(@Nullable MessageSendConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder metadata(@Nullable Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public MessageSendParams build() {
            return new MessageSendParams((Message)Assert.checkNotNullParam((String)"message", (Object)this.message), this.configuration, this.metadata, this.tenant == null ? "" : this.tenant);
        }
    }
}

