/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import io.a2a.spec.EventKind;
import io.a2a.spec.Part;
import io.a2a.spec.StreamingEventKind;
import io.a2a.util.Assert;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jspecify.annotations.Nullable;

public record Message(Role role, List<Part<?>> parts, String messageId, @Nullable String contextId, @Nullable String taskId, @Nullable List<String> referenceTaskIds, @Nullable Map<String, Object> metadata, @Nullable List<String> extensions) implements EventKind,
StreamingEventKind
{
    public static final String STREAMING_EVENT_ID = "message";

    public Message(Role role, List<Part<?>> parts, String messageId, @Nullable String contextId, @Nullable String taskId, @Nullable List<String> referenceTaskIds, @Nullable Map<String, Object> metadata, @Nullable List<String> extensions) {
        Assert.checkNotNullParam((String)"role", (Object)((Object)role));
        Assert.checkNotNullParam((String)"parts", parts);
        Assert.checkNotNullParam((String)"messageId", (Object)messageId);
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("Parts cannot be empty");
        }
        parts = List.copyOf(parts);
        referenceTaskIds = referenceTaskIds != null ? List.copyOf(referenceTaskIds) : null;
        metadata = metadata != null ? Map.copyOf(metadata) : null;
        extensions = extensions != null ? List.copyOf(extensions) : null;
    }

    @Override
    public String kind() {
        return STREAMING_EVENT_ID;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Message message) {
        return new Builder(message);
    }

    public static enum Role {
        ROLE_USER,
        ROLE_AGENT,
        ROLE_UNSPECIFIED;

    }

    public static class Builder {
        private @Nullable Role role;
        private @Nullable List<Part<?>> parts;
        private @Nullable String messageId;
        private @Nullable String contextId;
        private @Nullable String taskId;
        private @Nullable List<String> referenceTaskIds;
        private @Nullable Map<String, Object> metadata;
        private @Nullable List<String> extensions;

        private Builder() {
        }

        private Builder(Message message) {
            this.role = message.role();
            this.parts = message.parts();
            this.messageId = message.messageId();
            this.contextId = message.contextId();
            this.taskId = message.taskId();
            this.referenceTaskIds = message.referenceTaskIds();
            this.metadata = message.metadata();
            this.extensions = message.extensions();
        }

        public Builder role(Role role) {
            this.role = role;
            return this;
        }

        public Builder parts(List<Part<?>> parts) {
            this.parts = parts;
            return this;
        }

        public Builder parts(Part<?> ... parts) {
            this.parts = List.of(parts);
            return this;
        }

        public Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder referenceTaskIds(List<String> referenceTaskIds) {
            this.referenceTaskIds = referenceTaskIds;
            return this;
        }

        public Builder metadata(@Nullable Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder extensions(List<String> extensions) {
            this.extensions = extensions == null ? null : List.copyOf(extensions);
            return this;
        }

        public Message build() {
            return new Message((Role)((Object)Assert.checkNotNullParam((String)"role", (Object)((Object)this.role))), (List)Assert.checkNotNullParam((String)"parts", this.parts), this.messageId == null ? UUID.randomUUID().toString() : this.messageId, this.contextId, this.taskId, this.referenceTaskIds, this.metadata, this.extensions);
        }
    }
}

