/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import io.a2a.spec.Artifact;
import io.a2a.spec.EventKind;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.UpdateEvent;
import io.a2a.util.Assert;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public record TaskArtifactUpdateEvent(String taskId, Artifact artifact, String contextId, @Nullable Boolean append, @Nullable Boolean lastChunk, @Nullable Map<String, Object> metadata) implements EventKind,
StreamingEventKind,
UpdateEvent
{
    public static final String STREAMING_EVENT_ID = "artifactUpdate";

    public TaskArtifactUpdateEvent(String taskId, Artifact artifact, String contextId, @Nullable Boolean append, @Nullable Boolean lastChunk, @Nullable Map<String, Object> metadata) {
        Assert.checkNotNullParam((String)"taskId", (Object)taskId);
        Assert.checkNotNullParam((String)"artifact", (Object)artifact);
        Assert.checkNotNullParam((String)"contextId", (Object)contextId);
    }

    @Override
    public String kind() {
        return STREAMING_EVENT_ID;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TaskArtifactUpdateEvent event) {
        return new Builder(event);
    }

    public static class Builder {
        private @Nullable String taskId;
        private @Nullable Artifact artifact;
        private @Nullable String contextId;
        private @Nullable Boolean append;
        private @Nullable Boolean lastChunk;
        private @Nullable Map<String, Object> metadata;

        private Builder() {
        }

        private Builder(TaskArtifactUpdateEvent existingTaskArtifactUpdateEvent) {
            this.taskId = existingTaskArtifactUpdateEvent.taskId;
            this.artifact = existingTaskArtifactUpdateEvent.artifact;
            this.contextId = existingTaskArtifactUpdateEvent.contextId;
            this.append = existingTaskArtifactUpdateEvent.append;
            this.lastChunk = existingTaskArtifactUpdateEvent.lastChunk;
            this.metadata = existingTaskArtifactUpdateEvent.metadata;
        }

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder artifact(Artifact artifact) {
            this.artifact = artifact;
            return this;
        }

        public Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder append(@Nullable Boolean append) {
            this.append = append;
            return this;
        }

        public Builder lastChunk(@Nullable Boolean lastChunk) {
            this.lastChunk = lastChunk;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public TaskArtifactUpdateEvent build() {
            return new TaskArtifactUpdateEvent((String)Assert.checkNotNullParam((String)"taskId", (Object)this.taskId), (Artifact)Assert.checkNotNullParam((String)"artifact", (Object)this.artifact), (String)Assert.checkNotNullParam((String)"contextId", (Object)this.contextId), this.append, this.lastChunk, this.metadata);
        }
    }
}

