/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.util;

import io.a2a.spec.A2AClientException;
import io.a2a.spec.AgentCard;
import io.a2a.spec.AgentInterface;
import io.a2a.spec.Artifact;
import io.a2a.spec.Task;
import io.a2a.spec.TaskArtifactUpdateEvent;
import io.a2a.util.Assert;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;

public class Utils {
    private static final Logger log = Logger.getLogger(Utils.class.getName());

    public static <T> T defaultIfNull(@Nullable T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static <T extends Throwable> void rethrow(Throwable t) throws T {
        throw t;
    }

    public static Task appendArtifactToTask(Task task, TaskArtifactUpdateEvent event, String taskId) {
        ArrayList<Artifact> artifacts = task.artifacts() == null ? new ArrayList<Artifact>() : new ArrayList<Artifact>(task.artifacts());
        Artifact newArtifact = event.artifact();
        String artifactId = newArtifact.artifactId();
        boolean appendParts = event.append() != null && event.append() != false;
        Artifact existingArtifact = null;
        int existingArtifactIndex = -1;
        for (int i = 0; i < artifacts.size(); ++i) {
            Artifact curr = (Artifact)artifacts.get(i);
            if (curr.artifactId() == null || !curr.artifactId().equals(artifactId)) continue;
            existingArtifact = curr;
            existingArtifactIndex = i;
            break;
        }
        if (!appendParts) {
            if (existingArtifactIndex >= 0) {
                log.fine(String.format("Replacing artifact at id %s for task %s", artifactId, taskId));
                artifacts.set(existingArtifactIndex, newArtifact);
            } else {
                log.fine(String.format("Adding artifact at id %s for task %s", artifactId, taskId));
                artifacts.add(newArtifact);
            }
        } else if (existingArtifact != null) {
            log.fine(String.format("Appending parts to artifact id %s for task %s", artifactId, taskId));
            ArrayList parts = new ArrayList(existingArtifact.parts());
            parts.addAll(newArtifact.parts());
            Artifact updated = Artifact.builder(existingArtifact).parts(parts).build();
            artifacts.set(existingArtifactIndex, updated);
        } else {
            log.warning(String.format("Received append=true for nonexistent artifact index for artifact %s in task %s. Ignoring chunk.", artifactId, taskId));
        }
        return Task.builder(task).artifacts(artifacts).build();
    }

    public static AgentInterface getFavoriteInterface(AgentCard agentCard) throws A2AClientException {
        if (agentCard.supportedInterfaces() == null || agentCard.supportedInterfaces().isEmpty()) {
            throw new A2AClientException("No server interface available in the AgentCard");
        }
        return agentCard.supportedInterfaces().get(0);
    }

    private static void validateTenant(String tenant) {
        if (tenant.isEmpty()) {
            return;
        }
        if (tenant.length() > 256) {
            throw new IllegalArgumentException("Tenant path exceeds maximum length of 256 characters");
        }
        if (tenant.contains("..")) {
            throw new IllegalArgumentException("Tenant path contains invalid '..' sequence (path traversal attempt)");
        }
        if (tenant.contains("//")) {
            throw new IllegalArgumentException("Tenant path contains invalid '//' sequence");
        }
        if (!tenant.matches("^[/a-zA-Z0-9_.\\-]+$")) {
            throw new IllegalArgumentException("Tenant path contains invalid characters. Only /a-zA-Z0-9_-. are allowed");
        }
    }

    private static String extractTenant(String agentTenant, @Nullable String tenant) {
        Assert.checkNotNullParam((String)"agentTenant", (Object)agentTenant);
        Object tenantPath = tenant;
        if (tenantPath == null || ((String)tenantPath).isBlank()) {
            return agentTenant;
        }
        if (!((String)tenantPath).startsWith("/")) {
            tenantPath = "/" + (String)tenantPath;
        }
        if (((String)tenantPath).endsWith("/") && ((String)tenantPath).length() > 1) {
            tenantPath = ((String)tenantPath).substring(0, ((String)tenantPath).length() - 1);
        }
        Utils.validateTenant((String)tenantPath);
        return tenantPath;
    }

    public static String buildBaseUrl(AgentInterface agentInterface, @Nullable String tenant) {
        Assert.checkNotNullParam((String)"agentInterface", (Object)agentInterface);
        String agentUrl = agentInterface.url();
        agentUrl = agentUrl.endsWith("/") ? agentUrl.substring(0, agentUrl.length() - 1) : agentUrl;
        StringBuilder urlBuilder = new StringBuilder(agentUrl);
        urlBuilder.append(Utils.extractTenant(agentInterface.tenant(), tenant));
        return urlBuilder.toString();
    }
}

