/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import io.a2a.spec.SecurityScheme;
import io.a2a.util.Assert;

public record APIKeySecurityScheme(Location location, String name, String description) implements SecurityScheme
{
    public static final String TYPE = "apiKeySecurityScheme";

    public APIKeySecurityScheme {
        Assert.checkNotNullParam((String)"location", (Object)((Object)location));
        Assert.checkNotNullParam((String)"name", (Object)name);
    }

    @Override
    public String type() {
        return TYPE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Location {
        COOKIE("cookie"),
        HEADER("header"),
        QUERY("query");

        private final String location;

        private Location(String location) {
            this.location = location;
        }

        public String asString() {
            return this.location;
        }

        public static Location fromString(String location) {
            switch (location) {
                case "cookie": {
                    return COOKIE;
                }
                case "header": {
                    return HEADER;
                }
                case "query": {
                    return QUERY;
                }
            }
            throw new IllegalArgumentException("Invalid API key location: " + location);
        }
    }

    public static class Builder {
        private Location location;
        private String name;
        private String description;

        private Builder() {
        }

        public Builder location(Location location) {
            this.location = location;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public APIKeySecurityScheme build() {
            return new APIKeySecurityScheme(this.location, this.name, this.description);
        }
    }
}

