/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.a2a.spec.Part;
import io.a2a.util.Assert;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonIgnoreProperties(ignoreUnknown=true)
public record Artifact(String artifactId, String name, String description, List<Part<?>> parts, Map<String, Object> metadata, List<String> extensions) {
    public Artifact {
        Assert.checkNotNullParam((String)"artifactId", (Object)artifactId);
        Assert.checkNotNullParam((String)"parts", parts);
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("Parts cannot be empty");
        }
    }

    public static class Builder {
        private String artifactId;
        private String name;
        private String description;
        private List<Part<?>> parts;
        private Map<String, Object> metadata;
        private List<String> extensions;

        public Builder() {
        }

        public Builder(Artifact existingArtifact) {
            this.artifactId = existingArtifact.artifactId;
            this.name = existingArtifact.name;
            this.description = existingArtifact.description;
            this.parts = existingArtifact.parts;
            this.metadata = existingArtifact.metadata;
            this.extensions = existingArtifact.extensions;
        }

        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder parts(List<Part<?>> parts) {
            this.parts = parts;
            return this;
        }

        public Builder parts(Part<?> ... parts) {
            this.parts = List.of(parts);
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder extensions(List<String> extensions) {
            this.extensions = extensions == null ? null : List.copyOf(extensions);
            return this;
        }

        public Artifact build() {
            return new Artifact(this.artifactId, this.name, this.description, this.parts, this.metadata, this.extensions);
        }
    }
}

