/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.a2a.spec.JSONRPCError;
import io.a2a.spec.JSONRPCMessage;
import io.a2a.util.Assert;
import io.a2a.util.Utils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class JSONRPCResponse<T>
implements JSONRPCMessage {
    protected String jsonrpc;
    protected Object id;
    protected T result;
    protected JSONRPCError error;

    public JSONRPCResponse() {
    }

    public JSONRPCResponse(String jsonrpc, Object id, T result, JSONRPCError error, Class<T> resultType) {
        if (jsonrpc != null && !jsonrpc.equals("2.0")) {
            throw new IllegalArgumentException("Invalid JSON-RPC protocol version");
        }
        if (error != null && result != null) {
            throw new IllegalArgumentException("Invalid JSON-RPC error response");
        }
        if (error == null && result == null && !Void.class.equals(resultType)) {
            throw new IllegalArgumentException("Invalid JSON-RPC success response");
        }
        Assert.isNullOrStringOrInteger((Object)id);
        this.jsonrpc = Utils.defaultIfNull(jsonrpc, "2.0");
        this.id = id;
        this.result = result;
        this.error = error;
    }

    @Override
    public String getJsonrpc() {
        return this.jsonrpc;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    public T getResult() {
        return this.result;
    }

    public JSONRPCError getError() {
        return this.error;
    }
}

