/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import io.a2a.spec.JSONRPCRequestDeserializerBase;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.MethodNotFoundJsonMappingException;
import io.a2a.spec.SendStreamingMessageRequest;
import io.a2a.spec.StreamingJSONRPCRequest;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskResubscriptionRequest;
import java.io.IOException;

public class StreamingJSONRPCRequestDeserializer<T>
extends JSONRPCRequestDeserializerBase<StreamingJSONRPCRequest<?>> {
    public StreamingJSONRPCRequestDeserializer() {
        this(null);
    }

    public StreamingJSONRPCRequestDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public StreamingJSONRPCRequest<?> deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonNode treeNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        String jsonrpc = this.getAndValidateJsonrpc(treeNode, jsonParser);
        String method = this.getAndValidateMethod(treeNode, jsonParser);
        Object id = this.getAndValidateId(treeNode, jsonParser);
        JsonNode paramsNode = treeNode.get("params");
        switch (method) {
            case "tasks/resubscribe": {
                return new TaskResubscriptionRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, TaskIdParams.class));
            }
            case "message/stream": {
                return new SendStreamingMessageRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, MessageSendParams.class));
            }
        }
        throw new MethodNotFoundJsonMappingException("Invalid method", this.getIdIfPossible(treeNode, jsonParser));
    }
}

