/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import io.a2a.grpc.StreamResponse;
import io.a2a.grpc.mapper.A2AMappers;
import io.a2a.grpc.mapper.A2AProtoMapperConfig;
import io.a2a.grpc.mapper.MessageMapper;
import io.a2a.grpc.mapper.TaskArtifactUpdateEventMapper;
import io.a2a.grpc.mapper.TaskMapper;
import io.a2a.grpc.mapper.TaskStatusUpdateEventMapper;
import io.a2a.spec.Message;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.Task;
import io.a2a.spec.TaskArtifactUpdateEvent;
import io.a2a.spec.TaskStatusUpdateEvent;
import org.mapstruct.Mapper;

@Mapper(config=A2AProtoMapperConfig.class, uses={TaskMapper.class, MessageMapper.class, TaskStatusUpdateEventMapper.class, TaskArtifactUpdateEventMapper.class})
public interface StreamResponseMapper {
    public static final StreamResponseMapper INSTANCE = A2AMappers.getMapper(StreamResponseMapper.class);

    default public StreamResponse toProto(StreamingEventKind domain) {
        if (domain == null) {
            return null;
        }
        return switch (domain.kind()) {
            case "task" -> StreamResponse.newBuilder().setTask(TaskMapper.INSTANCE.toProto((Task)domain)).build();
            case "message" -> StreamResponse.newBuilder().setMessage(MessageMapper.INSTANCE.toProto((Message)domain)).build();
            case "statusUpdate" -> StreamResponse.newBuilder().setStatusUpdate(TaskStatusUpdateEventMapper.INSTANCE.toProto((TaskStatusUpdateEvent)domain)).build();
            case "artifactUpdate" -> StreamResponse.newBuilder().setArtifactUpdate(TaskArtifactUpdateEventMapper.INSTANCE.toProto((TaskArtifactUpdateEvent)domain)).build();
            default -> throw new IllegalArgumentException("Unknown StreamingEventKind type: " + domain.getClass().getName());
        };
    }

    default public StreamingEventKind fromProto(StreamResponse proto) {
        if (proto == null) {
            return null;
        }
        return switch (proto.getPayloadCase()) {
            default -> throw new IncompatibleClassChangeError();
            case StreamResponse.PayloadCase.TASK -> TaskMapper.INSTANCE.fromProto(proto.getTask());
            case StreamResponse.PayloadCase.MESSAGE -> MessageMapper.INSTANCE.fromProto(proto.getMessage());
            case StreamResponse.PayloadCase.STATUS_UPDATE -> TaskStatusUpdateEventMapper.INSTANCE.fromProto(proto.getStatusUpdate());
            case StreamResponse.PayloadCase.ARTIFACT_UPDATE -> TaskArtifactUpdateEventMapper.INSTANCE.fromProto(proto.getArtifactUpdate());
            case StreamResponse.PayloadCase.PAYLOAD_NOT_SET -> throw new IllegalArgumentException("StreamResponse payload oneof field not set");
        };
    }
}

