/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import com.google.protobuf.ProtocolStringList;
import io.a2a.grpc.AgentCard;
import io.a2a.grpc.AgentCardSignature;
import io.a2a.grpc.AgentInterface;
import io.a2a.grpc.AgentSkill;
import io.a2a.grpc.SecurityScheme;
import io.a2a.grpc.mapper.AgentCapabilitiesMapper;
import io.a2a.grpc.mapper.AgentCardMapper;
import io.a2a.grpc.mapper.AgentCardSignatureMapper;
import io.a2a.grpc.mapper.AgentInterfaceMapper;
import io.a2a.grpc.mapper.AgentProviderMapper;
import io.a2a.grpc.mapper.AgentSkillMapper;
import io.a2a.grpc.mapper.SecurityRequirementMapper;
import io.a2a.grpc.mapper.SecuritySchemeMapper;
import io.a2a.spec.AgentCard;
import io.a2a.spec.SecurityRequirement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AgentCardMapperImpl
implements AgentCardMapper {
    private final AgentProviderMapper agentProviderMapper = AgentProviderMapper.INSTANCE;
    private final AgentCapabilitiesMapper agentCapabilitiesMapper = AgentCapabilitiesMapper.INSTANCE;
    private final AgentSkillMapper agentSkillMapper = AgentSkillMapper.INSTANCE;
    private final SecuritySchemeMapper securitySchemeMapper = SecuritySchemeMapper.INSTANCE;
    private final SecurityRequirementMapper securityRequirementMapper = SecurityRequirementMapper.INSTANCE;
    private final AgentInterfaceMapper agentInterfaceMapper = AgentInterfaceMapper.INSTANCE;
    private final AgentCardSignatureMapper agentCardSignatureMapper = AgentCardSignatureMapper.INSTANCE;

    @Override
    public AgentCard toProto(io.a2a.spec.AgentCard domain) {
        Map<String, SecurityScheme> map;
        if (domain == null) {
            return null;
        }
        AgentCard.Builder agentCard = AgentCard.newBuilder();
        if (domain.provider() != null) {
            agentCard.setProvider(this.agentProviderMapper.toProto(domain.provider()));
        }
        if (domain.documentationUrl() != null) {
            agentCard.setDocumentationUrl(domain.documentationUrl());
        }
        if (domain.iconUrl() != null) {
            agentCard.setIconUrl(domain.iconUrl());
        }
        agentCard.setName(domain.name());
        agentCard.setDescription(domain.description());
        agentCard.setVersion(domain.version());
        agentCard.setCapabilities(this.agentCapabilitiesMapper.toProto(domain.capabilities()));
        if (domain.supportedInterfaces() != null) {
            for (io.a2a.spec.AgentInterface supportedInterface : domain.supportedInterfaces()) {
                agentCard.addSupportedInterfaces(this.agentInterfaceMapper.toProto(supportedInterface));
            }
        }
        if (agentCard.getMutableSecuritySchemes() != null && (map = this.stringSecuritySchemeMapToStringSecuritySchemeMap(domain.securitySchemes())) != null) {
            agentCard.getMutableSecuritySchemes().putAll(map);
        }
        if (domain.securityRequirements() != null) {
            for (SecurityRequirement securityRequirement : domain.securityRequirements()) {
                agentCard.addSecurityRequirements(this.securityRequirementMapper.mapSecurityRequirement(securityRequirement));
            }
        }
        if (domain.defaultInputModes() != null) {
            for (String defaultInputMode : domain.defaultInputModes()) {
                agentCard.addDefaultInputModes(defaultInputMode);
            }
        }
        if (domain.defaultOutputModes() != null) {
            for (String defaultOutputMode : domain.defaultOutputModes()) {
                agentCard.addDefaultOutputModes(defaultOutputMode);
            }
        }
        if (domain.skills() != null) {
            for (io.a2a.spec.AgentSkill skill : domain.skills()) {
                agentCard.addSkills(this.agentSkillMapper.toProto(skill));
            }
        }
        if (domain.signatures() != null) {
            for (io.a2a.spec.AgentCardSignature signature : domain.signatures()) {
                agentCard.addSignatures(this.agentCardSignatureMapper.toProto(signature));
            }
        }
        return agentCard.build();
    }

    @Override
    public io.a2a.spec.AgentCard fromProto(AgentCard proto) {
        ProtocolStringList protocolStringList1;
        ProtocolStringList protocolStringList;
        if (proto == null) {
            return null;
        }
        AgentCard.Builder agentCard = io.a2a.spec.AgentCard.builder();
        if (proto.hasProvider()) {
            agentCard.provider(this.agentProviderMapper.fromProto(proto.getProvider()));
        }
        if (!proto.getDocumentationUrl().isEmpty()) {
            agentCard.documentationUrl(proto.getDocumentationUrl());
        }
        if (!proto.getIconUrl().isEmpty()) {
            agentCard.iconUrl(proto.getIconUrl());
        }
        agentCard.name(proto.getName());
        agentCard.description(proto.getDescription());
        agentCard.version(proto.getVersion());
        if (proto.hasCapabilities()) {
            agentCard.capabilities(this.agentCapabilitiesMapper.fromProto(proto.getCapabilities()));
        }
        if ((protocolStringList = proto.getDefaultInputModesList()) != null) {
            agentCard.defaultInputModes(new ArrayList(protocolStringList));
        }
        if ((protocolStringList1 = proto.getDefaultOutputModesList()) != null) {
            agentCard.defaultOutputModes(new ArrayList(protocolStringList1));
        }
        agentCard.skills(this.agentSkillListToAgentSkillList(proto.getSkillsList()));
        agentCard.securitySchemes(this.stringSecuritySchemeMapToStringSecuritySchemeMap1(proto.getSecuritySchemes()));
        agentCard.securityRequirements(this.securityRequirementMapper.fromProto(proto.getSecurityRequirementsList()));
        agentCard.supportedInterfaces(this.agentInterfaceListToAgentInterfaceList(proto.getSupportedInterfacesList()));
        agentCard.signatures(this.agentCardSignatureListToAgentCardSignatureList(proto.getSignaturesList()));
        return agentCard.build();
    }

    protected Map<String, SecurityScheme> stringSecuritySchemeMapToStringSecuritySchemeMap(Map<String, io.a2a.spec.SecurityScheme> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<String, SecurityScheme> map1 = new LinkedHashMap<String, SecurityScheme>(Math.max((int)((float)map.size() / 0.75f) + 1, 16));
        for (Map.Entry<String, io.a2a.spec.SecurityScheme> entry : map.entrySet()) {
            String key = entry.getKey();
            SecurityScheme value = this.securitySchemeMapper.toProto(entry.getValue());
            map1.put(key, value);
        }
        return map1;
    }

    protected List<io.a2a.spec.AgentSkill> agentSkillListToAgentSkillList(List<AgentSkill> list) {
        if (list == null) {
            return null;
        }
        ArrayList<io.a2a.spec.AgentSkill> list1 = new ArrayList<io.a2a.spec.AgentSkill>(list.size());
        for (AgentSkill agentSkill : list) {
            list1.add(this.agentSkillMapper.fromProto(agentSkill));
        }
        return list1;
    }

    protected Map<String, io.a2a.spec.SecurityScheme> stringSecuritySchemeMapToStringSecuritySchemeMap1(Map<String, SecurityScheme> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<String, io.a2a.spec.SecurityScheme> map1 = new LinkedHashMap<String, io.a2a.spec.SecurityScheme>(Math.max((int)((float)map.size() / 0.75f) + 1, 16));
        for (Map.Entry<String, SecurityScheme> entry : map.entrySet()) {
            String key = entry.getKey();
            io.a2a.spec.SecurityScheme value = this.securitySchemeMapper.fromProto(entry.getValue());
            map1.put(key, value);
        }
        return map1;
    }

    protected List<io.a2a.spec.AgentInterface> agentInterfaceListToAgentInterfaceList(List<AgentInterface> list) {
        if (list == null) {
            return null;
        }
        ArrayList<io.a2a.spec.AgentInterface> list1 = new ArrayList<io.a2a.spec.AgentInterface>(list.size());
        for (AgentInterface agentInterface : list) {
            list1.add(this.agentInterfaceMapper.fromProto(agentInterface));
        }
        return list1;
    }

    protected List<io.a2a.spec.AgentCardSignature> agentCardSignatureListToAgentCardSignatureList(List<AgentCardSignature> list) {
        if (list == null) {
            return null;
        }
        ArrayList<io.a2a.spec.AgentCardSignature> list1 = new ArrayList<io.a2a.spec.AgentCardSignature>(list.size());
        for (AgentCardSignature agentCardSignature : list) {
            list1.add(this.agentCardSignatureMapper.fromProto(agentCardSignature));
        }
        return list1;
    }
}

