/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonWriter;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.a2a.grpc.AgentCard;
import io.a2a.grpc.CancelTaskRequest;
import io.a2a.grpc.DeleteTaskPushNotificationConfigRequest;
import io.a2a.grpc.GetTaskPushNotificationConfigRequest;
import io.a2a.grpc.GetTaskRequest;
import io.a2a.grpc.ListTaskPushNotificationConfigRequest;
import io.a2a.grpc.ListTaskPushNotificationConfigResponse;
import io.a2a.grpc.ListTasksRequest;
import io.a2a.grpc.ListTasksResponse;
import io.a2a.grpc.SendMessageRequest;
import io.a2a.grpc.SendMessageResponse;
import io.a2a.grpc.SetTaskPushNotificationConfigRequest;
import io.a2a.grpc.StreamResponse;
import io.a2a.grpc.SubscribeToTaskRequest;
import io.a2a.grpc.Task;
import io.a2a.grpc.TaskPushNotificationConfig;
import io.a2a.grpc.utils.ProtoUtils;
import io.a2a.jsonrpc.common.json.IdJsonMappingException;
import io.a2a.jsonrpc.common.json.InvalidParamsJsonMappingException;
import io.a2a.jsonrpc.common.json.JsonMappingException;
import io.a2a.jsonrpc.common.json.JsonProcessingException;
import io.a2a.jsonrpc.common.json.MethodNotFoundJsonMappingException;
import io.a2a.jsonrpc.common.wrappers.A2ARequest;
import io.a2a.jsonrpc.common.wrappers.A2AResponse;
import io.a2a.jsonrpc.common.wrappers.CancelTaskResponse;
import io.a2a.jsonrpc.common.wrappers.DeleteTaskPushNotificationConfigResponse;
import io.a2a.jsonrpc.common.wrappers.GetAuthenticatedExtendedCardRequest;
import io.a2a.jsonrpc.common.wrappers.GetAuthenticatedExtendedCardResponse;
import io.a2a.jsonrpc.common.wrappers.GetTaskPushNotificationConfigResponse;
import io.a2a.jsonrpc.common.wrappers.GetTaskResponse;
import io.a2a.jsonrpc.common.wrappers.SendStreamingMessageRequest;
import io.a2a.jsonrpc.common.wrappers.SetTaskPushNotificationConfigResponse;
import io.a2a.spec.A2AError;
import io.a2a.spec.ContentTypeNotSupportedError;
import io.a2a.spec.EventKind;
import io.a2a.spec.ExtendedCardNotConfiguredError;
import io.a2a.spec.ExtensionSupportRequiredError;
import io.a2a.spec.InternalError;
import io.a2a.spec.InvalidAgentResponseError;
import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.InvalidRequestError;
import io.a2a.spec.JSONParseError;
import io.a2a.spec.MethodNotFoundError;
import io.a2a.spec.PushNotificationNotSupportedError;
import io.a2a.spec.TaskNotCancelableError;
import io.a2a.spec.TaskNotFoundError;
import io.a2a.spec.UnsupportedOperationError;
import io.a2a.spec.VersionNotSupportedError;
import io.a2a.util.Utils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

public class JSONRPCUtils {
    private static final Logger log = Logger.getLogger(JSONRPCUtils.class.getName());
    private static final Gson GSON = new GsonBuilder().setStrictness(Strictness.STRICT).create();
    private static final Pattern EXTRACT_WRONG_VALUE = Pattern.compile("Expect (.*) but got: \".*\"");
    private static final Pattern EXTRACT_WRONG_TYPE = Pattern.compile("Expected (.*) but found \".*\"");
    static final String ERROR_MESSAGE = "Invalid request content: %s. Please verify the request matches the expected schema for this method.";

    public static A2ARequest<?> parseRequestBody(String body) throws JsonMappingException, JsonProcessingException {
        JsonElement jelement = JsonParser.parseString((String)body);
        JsonObject jsonRpc = jelement.getAsJsonObject();
        if (!jsonRpc.has("method")) {
            throw new IdJsonMappingException("JSON-RPC request missing required 'method' field. Request must include: jsonrpc, id, method, and params.", JSONRPCUtils.getIdIfPossible(jsonRpc));
        }
        String version = JSONRPCUtils.getAndValidateJsonrpc(jsonRpc);
        Object id = JSONRPCUtils.getAndValidateId(jsonRpc);
        String method = jsonRpc.get("method").getAsString();
        JsonElement paramsNode = jsonRpc.get("params");
        try {
            return JSONRPCUtils.parseMethodRequest(version, id, method, paramsNode);
        }
        catch (InvalidParamsError e) {
            throw new InvalidParamsJsonMappingException((String)Utils.defaultIfNull((Object)e.getMessage(), (Object)"Invalid parameters"), id);
        }
    }

    private static A2ARequest<?> parseMethodRequest(String version, Object id, String method, JsonElement paramsNode) throws InvalidParamsError, MethodNotFoundJsonMappingException, JsonProcessingException {
        switch (method) {
            case "GetTask": {
                GetTaskRequest.Builder builder = GetTaskRequest.newBuilder();
                JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
                return new io.a2a.jsonrpc.common.wrappers.GetTaskRequest(version, id, ProtoUtils.FromProto.taskQueryParams(builder));
            }
            case "CancelTask": {
                CancelTaskRequest.Builder builder = CancelTaskRequest.newBuilder();
                JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
                return new io.a2a.jsonrpc.common.wrappers.CancelTaskRequest(version, id, ProtoUtils.FromProto.taskIdParams(builder));
            }
            case "ListTasks": {
                ListTasksRequest.Builder builder = ListTasksRequest.newBuilder();
                JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
                return new io.a2a.jsonrpc.common.wrappers.ListTasksRequest(version, id, ProtoUtils.FromProto.listTasksParams(builder));
            }
            case "SetTaskPushNotificationConfig": {
                SetTaskPushNotificationConfigRequest.Builder builder = SetTaskPushNotificationConfigRequest.newBuilder();
                JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
                return new io.a2a.jsonrpc.common.wrappers.SetTaskPushNotificationConfigRequest(version, id, ProtoUtils.FromProto.setTaskPushNotificationConfig(builder));
            }
            case "GetTaskPushNotificationConfig": {
                GetTaskPushNotificationConfigRequest.Builder builder = GetTaskPushNotificationConfigRequest.newBuilder();
                JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
                return new io.a2a.jsonrpc.common.wrappers.GetTaskPushNotificationConfigRequest(version, id, ProtoUtils.FromProto.getTaskPushNotificationConfigParams(builder));
            }
            case "SendMessage": {
                SendMessageRequest.Builder builder = SendMessageRequest.newBuilder();
                JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
                return new io.a2a.jsonrpc.common.wrappers.SendMessageRequest(version, id, ProtoUtils.FromProto.messageSendParams(builder));
            }
            case "ListTaskPushNotificationConfig": {
                ListTaskPushNotificationConfigRequest.Builder builder = ListTaskPushNotificationConfigRequest.newBuilder();
                JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
                return new io.a2a.jsonrpc.common.wrappers.ListTaskPushNotificationConfigRequest(version, id, ProtoUtils.FromProto.listTaskPushNotificationConfigParams(builder));
            }
            case "DeleteTaskPushNotificationConfig": {
                DeleteTaskPushNotificationConfigRequest.Builder builder = DeleteTaskPushNotificationConfigRequest.newBuilder();
                JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
                return new io.a2a.jsonrpc.common.wrappers.DeleteTaskPushNotificationConfigRequest(version, id, ProtoUtils.FromProto.deleteTaskPushNotificationConfigParams(builder));
            }
            case "GetExtendedAgentCard": {
                return new GetAuthenticatedExtendedCardRequest(version, id);
            }
            case "SendStreamingMessage": {
                SendMessageRequest.Builder builder = SendMessageRequest.newBuilder();
                JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
                return new SendStreamingMessageRequest(version, id, ProtoUtils.FromProto.messageSendParams(builder));
            }
            case "SubscribeToTask": {
                SubscribeToTaskRequest.Builder builder = SubscribeToTaskRequest.newBuilder();
                JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
                return new io.a2a.jsonrpc.common.wrappers.SubscribeToTaskRequest(version, id, ProtoUtils.FromProto.taskIdParams(builder));
            }
        }
        throw new MethodNotFoundJsonMappingException("Unsupported JSON-RPC method: '" + method + "'", id);
    }

    public static StreamResponse parseResponseEvent(String body) throws JsonMappingException, JsonProcessingException {
        JsonElement jelement = JsonParser.parseString((String)body);
        JsonObject jsonRpc = jelement.getAsJsonObject();
        String version = JSONRPCUtils.getAndValidateJsonrpc(jsonRpc);
        Object id = JSONRPCUtils.getAndValidateId(jsonRpc);
        JsonElement paramsNode = jsonRpc.get("result");
        if (jsonRpc.has("error")) {
            throw JSONRPCUtils.processError(jsonRpc.getAsJsonObject("error"));
        }
        StreamResponse.Builder builder = StreamResponse.newBuilder();
        JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
        return builder.build();
    }

    public static A2AResponse<?> parseResponseBody(String body, String method) throws JsonMappingException, JsonProcessingException {
        JsonElement jelement = JsonParser.parseString((String)body);
        JsonObject jsonRpc = jelement.getAsJsonObject();
        String version = JSONRPCUtils.getAndValidateJsonrpc(jsonRpc);
        Object id = JSONRPCUtils.getAndValidateId(jsonRpc);
        JsonElement paramsNode = jsonRpc.get("result");
        if (jsonRpc.has("error")) {
            return JSONRPCUtils.parseError(jsonRpc.getAsJsonObject("error"), id, method);
        }
        switch (method) {
            case "GetTask": {
                Task.Builder builder = Task.newBuilder();
                JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
                return new GetTaskResponse(id, ProtoUtils.FromProto.task(builder));
            }
            case "CancelTask": {
                Task.Builder builder = Task.newBuilder();
                JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
                return new CancelTaskResponse(id, ProtoUtils.FromProto.task(builder));
            }
            case "ListTasks": {
                ListTasksResponse.Builder builder = ListTasksResponse.newBuilder();
                JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
                return new io.a2a.jsonrpc.common.wrappers.ListTasksResponse(id, ProtoUtils.FromProto.listTasksResult(builder));
            }
            case "SetTaskPushNotificationConfig": {
                TaskPushNotificationConfig.Builder builder = TaskPushNotificationConfig.newBuilder();
                JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
                return new SetTaskPushNotificationConfigResponse(id, ProtoUtils.FromProto.taskPushNotificationConfig(builder));
            }
            case "GetTaskPushNotificationConfig": {
                TaskPushNotificationConfig.Builder builder = TaskPushNotificationConfig.newBuilder();
                JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
                return new GetTaskPushNotificationConfigResponse(id, ProtoUtils.FromProto.taskPushNotificationConfig(builder));
            }
            case "SendMessage": {
                SendMessageResponse.Builder builder = SendMessageResponse.newBuilder();
                JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
                if (builder.hasMsg()) {
                    return new io.a2a.jsonrpc.common.wrappers.SendMessageResponse(id, (EventKind)ProtoUtils.FromProto.message(builder.getMsg()));
                }
                return new io.a2a.jsonrpc.common.wrappers.SendMessageResponse(id, (EventKind)ProtoUtils.FromProto.task(builder.getTask()));
            }
            case "ListTaskPushNotificationConfig": {
                ListTaskPushNotificationConfigResponse.Builder builder = ListTaskPushNotificationConfigResponse.newBuilder();
                JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
                return new io.a2a.jsonrpc.common.wrappers.ListTaskPushNotificationConfigResponse(id, ProtoUtils.FromProto.listTaskPushNotificationConfigResult(builder));
            }
            case "DeleteTaskPushNotificationConfig": {
                return new DeleteTaskPushNotificationConfigResponse(id);
            }
            case "GetExtendedAgentCard": {
                AgentCard.Builder builder = AgentCard.newBuilder();
                JSONRPCUtils.parseRequestBody(paramsNode, (Message.Builder)builder, id);
                return new GetAuthenticatedExtendedCardResponse(id, ProtoUtils.FromProto.agentCard(builder));
            }
        }
        throw new MethodNotFoundJsonMappingException("Unsupported JSON-RPC method: '" + method + "' in response parsing.", JSONRPCUtils.getIdIfPossible(jsonRpc));
    }

    public static A2AResponse<?> parseError(JsonObject error, Object id, String method) throws JsonMappingException {
        A2AError rpcError = JSONRPCUtils.processError(error);
        switch (method) {
            case "GetTask": {
                return new GetTaskResponse(id, rpcError);
            }
            case "CancelTask": {
                return new CancelTaskResponse(id, rpcError);
            }
            case "ListTasks": {
                return new io.a2a.jsonrpc.common.wrappers.ListTasksResponse(id, rpcError);
            }
            case "SetTaskPushNotificationConfig": {
                return new SetTaskPushNotificationConfigResponse(id, rpcError);
            }
            case "GetTaskPushNotificationConfig": {
                return new GetTaskPushNotificationConfigResponse(id, rpcError);
            }
            case "SendMessage": {
                return new io.a2a.jsonrpc.common.wrappers.SendMessageResponse(id, rpcError);
            }
            case "ListTaskPushNotificationConfig": {
                return new io.a2a.jsonrpc.common.wrappers.ListTaskPushNotificationConfigResponse(id, rpcError);
            }
            case "DeleteTaskPushNotificationConfig": {
                return new DeleteTaskPushNotificationConfigResponse(id, rpcError);
            }
        }
        throw new MethodNotFoundJsonMappingException("Unsupported JSON-RPC method: '" + method + "'", id);
    }

    private static A2AError processError(JsonObject error) {
        String data;
        String message = error.has("message") ? error.get("message").getAsString() : null;
        Integer code = error.has("code") ? Integer.valueOf(error.get("code").getAsInt()) : null;
        String string = data = error.has("data") ? error.get("data").toString() : null;
        if (code != null) {
            switch (code) {
                case -32700: {
                    return new JSONParseError(code, message, (Object)data);
                }
                case -32600: {
                    return new InvalidRequestError(code, message, (Object)data);
                }
                case -32601: {
                    return new MethodNotFoundError(code, message, (Object)data);
                }
                case -32602: {
                    return new InvalidParamsError(code, message, (Object)data);
                }
                case -32603: {
                    return new InternalError(code, message, (Object)data);
                }
                case -32003: {
                    return new PushNotificationNotSupportedError(code, message, (Object)data);
                }
                case -32004: {
                    return new UnsupportedOperationError(code, message, (Object)data);
                }
                case -32005: {
                    return new ContentTypeNotSupportedError(code, message, (Object)data);
                }
                case -32006: {
                    return new InvalidAgentResponseError(code, message, (Object)data);
                }
                case -32007: {
                    return new ExtendedCardNotConfiguredError(code, message, (Object)data);
                }
                case -32008: {
                    return new ExtensionSupportRequiredError(code, message, (Object)data);
                }
                case -32009: {
                    return new VersionNotSupportedError(code, message, (Object)data);
                }
                case -32002: {
                    return new TaskNotCancelableError(code, message, (Object)data);
                }
                case -32001: {
                    return new TaskNotFoundError(code, message, (Object)data);
                }
            }
            return new A2AError(code, message, (Object)data);
        }
        return new A2AError(code, message, (Object)data);
    }

    protected static void parseRequestBody(JsonElement jsonRpc, Message.Builder builder, Object id) throws JsonProcessingException {
        JSONRPCUtils.parseJsonString(jsonRpc.toString(), builder, id);
    }

    public static void parseJsonString(String body, Message.Builder builder, Object id) throws JsonProcessingException {
        try {
            JsonFormat.parser().merge(body, builder);
        }
        catch (InvalidProtocolBufferException e) {
            log.log(Level.FINE, "Protocol buffer parsing failed for JSON: {0}", body);
            log.log(Level.FINE, "Proto parsing error details", e);
            throw JSONRPCUtils.convertProtoBufExceptionToJsonProcessingException(e, id);
        }
    }

    private static JsonProcessingException convertProtoBufExceptionToJsonProcessingException(InvalidProtocolBufferException e, Object id) {
        String[] prefixes;
        log.log(Level.FINE, "Converting protobuf parsing exception to JSON-RPC error. Request ID: {0}", id);
        log.log(Level.FINE, "Original proto exception details", e);
        String message = e.getMessage();
        if (message == null) {
            return new JsonProcessingException(ERROR_MESSAGE.formatted("unknown parsing error"));
        }
        for (String prefix : prefixes = new String[]{"Cannot find field: ", "Invalid value for", "Invalid enum value:"}) {
            if (!message.contains(prefix)) continue;
            return new InvalidParamsJsonMappingException(ERROR_MESSAGE.formatted(message.substring(message.indexOf(prefix) + prefix.length())), id);
        }
        Matcher matcher = EXTRACT_WRONG_TYPE.matcher(message);
        if (matcher.matches() && matcher.group(1) != null) {
            return new InvalidParamsJsonMappingException(ERROR_MESSAGE.formatted(matcher.group(1)), Utils.defaultIfNull((Object)id, (Object)""));
        }
        matcher = EXTRACT_WRONG_VALUE.matcher(message);
        if (matcher.matches() && matcher.group(1) != null) {
            return new InvalidParamsJsonMappingException(ERROR_MESSAGE.formatted(matcher.group(1)), Utils.defaultIfNull((Object)id, (Object)""));
        }
        return new JsonMappingException(ERROR_MESSAGE.formatted(message));
    }

    protected static String getAndValidateJsonrpc(JsonObject jsonRpc) throws JsonMappingException {
        if (!jsonRpc.has("jsonrpc")) {
            throw new IdJsonMappingException("Missing required 'jsonrpc' field. All requests must include 'jsonrpc': '2.0'", JSONRPCUtils.getIdIfPossible(jsonRpc));
        }
        String version = jsonRpc.get("jsonrpc").getAsString();
        if (!"2.0".equals(version)) {
            throw new IdJsonMappingException("Unsupported JSON-RPC version: '" + version + "'. Expected version '2.0'", JSONRPCUtils.getIdIfPossible(jsonRpc));
        }
        return version;
    }

    protected static Object getIdIfPossible(JsonObject jsonRpc) {
        try {
            return JSONRPCUtils.getAndValidateId(jsonRpc);
        }
        catch (JsonMappingException e) {
            return "UNDETERMINED ID";
        }
    }

    protected static Object getAndValidateId(JsonObject jsonRpc) throws JsonMappingException {
        Object id = null;
        if (jsonRpc.has("id")) {
            if (jsonRpc.get("id").isJsonPrimitive()) {
                try {
                    id = jsonRpc.get("id").getAsInt();
                }
                catch (IllegalStateException | NumberFormatException | UnsupportedOperationException e) {
                    id = jsonRpc.get("id").getAsString();
                }
            } else {
                throw new JsonMappingException(null, "Invalid 'id' type: " + jsonRpc.get("id").getClass().getSimpleName() + ". ID must be a JSON string or number, not an object or array.");
            }
        }
        if (id == null) {
            throw new JsonMappingException(null, "Request 'id' cannot be null. Use a string or number identifier.");
        }
        return id;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String toJsonRPCRequest(@Nullable String requestId, String method, @Nullable MessageOrBuilder payload) {
        try (StringWriter result = new StringWriter();){
            String string;
            block16: {
                JsonWriter output = GSON.newJsonWriter((Writer)result);
                try {
                    output.beginObject();
                    output.name("jsonrpc").value("2.0");
                    String id = requestId;
                    if (requestId == null) {
                        id = UUID.randomUUID().toString();
                    }
                    output.name("id").value(id);
                    if (method != null) {
                        output.name("method").value(method);
                    }
                    if (payload != null) {
                        String resultValue = JsonFormat.printer().includingDefaultValueFields().omittingInsignificantWhitespace().print(payload);
                        output.name("params").jsonValue(resultValue);
                    }
                    output.endObject();
                    string = result.toString();
                    if (output == null) break block16;
                }
                catch (Throwable throwable) {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                output.close();
            }
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to serialize JSON-RPC request for method '" + method + "'. This indicates an internal error in JSON generation. Request ID: " + requestId, ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String toJsonRPCResultResponse(Object requestId, MessageOrBuilder builder) {
        try (StringWriter result = new StringWriter();){
            String string;
            block17: {
                JsonWriter output = GSON.newJsonWriter((Writer)result);
                try {
                    output.beginObject();
                    output.name("jsonrpc").value("2.0");
                    if (requestId != null) {
                        if (requestId instanceof String) {
                            String string2 = (String)requestId;
                            output.name("id").value(string2);
                        } else if (requestId instanceof Number) {
                            Number number = (Number)requestId;
                            output.name("id").value(number.longValue());
                        }
                    }
                    String resultValue = JsonFormat.printer().includingDefaultValueFields().omittingInsignificantWhitespace().print(builder);
                    output.name("result").jsonValue(resultValue);
                    output.endObject();
                    string = result.toString();
                    if (output == null) break block17;
                }
                catch (Throwable throwable) {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                output.close();
            }
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to serialize JSON-RPC success response. Proto type: " + builder.getClass().getSimpleName() + ", Request ID: " + String.valueOf(requestId), ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String toJsonRPCErrorResponse(Object requestId, A2AError error) {
        try (StringWriter result = new StringWriter();){
            String string;
            block18: {
                JsonWriter output = GSON.newJsonWriter((Writer)result);
                try {
                    output.beginObject();
                    output.name("jsonrpc").value("2.0");
                    if (requestId != null) {
                        if (requestId instanceof String) {
                            String string2 = (String)requestId;
                            output.name("id").value(string2);
                        } else if (requestId instanceof Number) {
                            Number number = (Number)requestId;
                            output.name("id").value(number.longValue());
                        }
                    }
                    output.name("error");
                    output.beginObject();
                    output.name("code").value((Number)error.getCode());
                    output.name("message").value(error.getMessage());
                    if (error.getData() != null) {
                        output.name("data").value(error.getData().toString());
                    }
                    output.endObject();
                    output.endObject();
                    string = result.toString();
                    if (output == null) break block18;
                }
                catch (Throwable throwable) {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                output.close();
            }
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to serialize JSON-RPC error response. Error code: " + error.getCode() + ", Request ID: " + String.valueOf(requestId), ex);
        }
    }
}

