/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import com.google.protobuf.ProtocolStringList;
import io.a2a.grpc.Security;
import io.a2a.grpc.StringList;
import io.a2a.grpc.mapper.A2AMappers;
import io.a2a.grpc.mapper.A2AProtoMapperConfig;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mapstruct.Mapper;

@Mapper(config=A2AProtoMapperConfig.class)
public interface SecurityMapper {
    public static final SecurityMapper INSTANCE = A2AMappers.getMapper(SecurityMapper.class);

    default public Security mapSecurityItem(Map<String, List<String>> schemeMap) {
        if (schemeMap == null) {
            return null;
        }
        Security.Builder securityBuilder = Security.newBuilder();
        for (Map.Entry<String, List<String>> entry : schemeMap.entrySet()) {
            StringList.Builder stringListBuilder = StringList.newBuilder();
            if (entry.getValue() != null) {
                stringListBuilder.addAllList((Iterable<String>)entry.getValue());
            }
            securityBuilder.putSchemes(entry.getKey(), stringListBuilder.build());
        }
        return securityBuilder.build();
    }

    default public List<Security> toProto(List<Map<String, List<String>>> domainSecurity) {
        if (domainSecurity == null) {
            return null;
        }
        ArrayList<Security> protoList = new ArrayList<Security>(domainSecurity.size());
        for (Map<String, List<String>> schemeMap : domainSecurity) {
            protoList.add(this.mapSecurityItem(schemeMap));
        }
        return protoList;
    }

    default public List<Map<String, List<String>>> fromProto(List<Security> protoSecurity) {
        if (protoSecurity == null) {
            return null;
        }
        ArrayList<Map<String, List<String>>> domainList = new ArrayList<Map<String, List<String>>>(protoSecurity.size());
        for (Security security : protoSecurity) {
            LinkedHashMap schemeMap = new LinkedHashMap();
            for (Map.Entry<String, StringList> entry : security.getSchemesMap().entrySet()) {
                ProtocolStringList listList = entry.getValue().getListList();
                ArrayList values = new ArrayList(listList);
                schemeMap.put(entry.getKey(), values);
            }
            domainList.add(schemeMap);
        }
        return domainList;
    }
}

