/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import io.a2a.grpc.Part;
import io.a2a.grpc.mapper.A2AMappers;
import io.a2a.grpc.mapper.A2AProtoMapperConfig;
import io.a2a.grpc.mapper.DataPartMapper;
import io.a2a.grpc.mapper.FilePartMapper;
import io.a2a.spec.DataPart;
import io.a2a.spec.FilePart;
import io.a2a.spec.InvalidRequestError;
import io.a2a.spec.TextPart;
import org.mapstruct.Mapper;

@Mapper(config=A2AProtoMapperConfig.class, uses={FilePartMapper.class, DataPartMapper.class})
public interface PartMapper {
    public static final PartMapper INSTANCE = A2AMappers.getMapper(PartMapper.class);

    default public Part toProto(io.a2a.spec.Part<?> domain) {
        if (domain == null) {
            return null;
        }
        Part.Builder builder = Part.newBuilder();
        if (domain instanceof TextPart) {
            TextPart textPart = (TextPart)domain;
            builder.setText(textPart.text());
        } else if (domain instanceof FilePart) {
            FilePart filePart = (FilePart)domain;
            builder.setFile(FilePartMapper.INSTANCE.toProto(filePart));
        } else if (domain instanceof DataPart) {
            DataPart dataPart = (DataPart)domain;
            builder.setData(DataPartMapper.INSTANCE.toProto(dataPart));
        }
        return builder.build();
    }

    default public io.a2a.spec.Part<?> fromProto(Part proto) {
        if (proto == null) {
            return null;
        }
        if (proto.hasText()) {
            return new TextPart(proto.getText());
        }
        if (proto.hasFile()) {
            return FilePartMapper.INSTANCE.fromProto(proto.getFile());
        }
        if (proto.hasData()) {
            return DataPartMapper.INSTANCE.fromProto(proto.getData());
        }
        throw new InvalidRequestError();
    }
}

