/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import com.google.protobuf.ByteString;
import io.a2a.grpc.FilePart;
import io.a2a.grpc.mapper.A2AMappers;
import io.a2a.grpc.mapper.A2AProtoMapperConfig;
import io.a2a.spec.FileContent;
import io.a2a.spec.FileWithBytes;
import io.a2a.spec.FileWithUri;
import io.a2a.spec.InvalidRequestError;
import java.util.Base64;
import org.mapstruct.Mapper;

@Mapper(config=A2AProtoMapperConfig.class)
public interface FilePartMapper {
    public static final FilePartMapper INSTANCE = A2AMappers.getMapper(FilePartMapper.class);

    default public FilePart toProto(io.a2a.spec.FilePart domain) {
        if (domain == null) {
            return null;
        }
        FilePart.Builder builder = FilePart.newBuilder();
        FileContent fileContent = domain.file();
        if (fileContent instanceof FileWithBytes) {
            FileWithBytes fileWithBytes = (FileWithBytes)fileContent;
            builder.setFileWithBytes(ByteString.copyFrom((byte[])Base64.getDecoder().decode(fileWithBytes.bytes())));
            if (fileWithBytes.mimeType() != null) {
                builder.setMediaType(fileWithBytes.mimeType());
            }
            if (fileWithBytes.name() != null) {
                builder.setName(fileWithBytes.name());
            }
        } else if (fileContent instanceof FileWithUri) {
            FileWithUri fileWithUri = (FileWithUri)fileContent;
            builder.setFileWithUri(fileWithUri.uri());
            if (fileWithUri.mimeType() != null) {
                builder.setMediaType(fileWithUri.mimeType());
            }
            if (fileWithUri.name() != null) {
                builder.setName(fileWithUri.name());
            }
        }
        return builder.build();
    }

    default public io.a2a.spec.FilePart fromProto(FilePart proto) {
        String name;
        if (proto == null) {
            return null;
        }
        String mimeType = proto.getMediaType().isEmpty() ? null : proto.getMediaType();
        String string = name = proto.getName().isEmpty() ? null : proto.getName();
        if (proto.hasFileWithBytes()) {
            String bytes = Base64.getEncoder().encodeToString(proto.getFileWithBytes().toByteArray());
            return new io.a2a.spec.FilePart((FileContent)new FileWithBytes(mimeType, name, bytes));
        }
        if (proto.hasFileWithUri()) {
            String uri = proto.getFileWithUri();
            return new io.a2a.spec.FilePart((FileContent)new FileWithUri(mimeType, name, uri));
        }
        throw new InvalidRequestError();
    }
}

