/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import com.google.protobuf.ListValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.Value;
import io.a2a.grpc.TaskState;
import io.a2a.grpc.mapper.A2AMappers;
import io.a2a.grpc.mapper.A2AProtoMapperConfig;
import io.a2a.grpc.mapper.TaskStateMapper;
import io.a2a.spec.InvalidParamsError;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Named;

@Mapper(config=A2AProtoMapperConfig.class, uses={TaskStateMapper.class})
public interface A2ACommonFieldMapper {
    public static final A2ACommonFieldMapper INSTANCE = A2AMappers.getMapper(A2ACommonFieldMapper.class);

    @Named(value="emptyToNull")
    default public String emptyToNull(String value) {
        return value == null || value.isEmpty() ? null : value;
    }

    @Named(value="requireNonEmpty")
    default public String requireNonEmpty(String value) {
        if (value == null || value.isEmpty()) {
            throw new InvalidParamsError("Required field cannot be null or empty");
        }
        return value;
    }

    @Named(value="nullToEmpty")
    default public String nullToEmpty(String value) {
        return value == null ? "" : value;
    }

    @Named(value="offsetDateTimeToProtoTimestamp")
    default public Timestamp offsetDateTimeToProtoTimestamp(OffsetDateTime dateTime) {
        if (dateTime == null) {
            return Timestamp.getDefaultInstance();
        }
        Instant instant = dateTime.toInstant();
        return Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
    }

    @Named(value="protoTimestampToOffsetDateTime")
    default public OffsetDateTime protoTimestampToOffsetDateTime(Timestamp timestamp) {
        if (timestamp == null || timestamp.equals((Object)Timestamp.getDefaultInstance())) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos()), ZoneOffset.UTC);
    }

    @Named(value="emptyListToNull")
    default public <T> List<T> emptyListToNull(List<T> list) {
        return list == null || list.isEmpty() ? null : list;
    }

    @Named(value="mapToStruct")
    default public Struct mapToStruct(Map<String, Object> map) {
        if (map == null) {
            return Struct.getDefaultInstance();
        }
        Struct.Builder structBuilder = Struct.newBuilder();
        map.forEach((k, v) -> structBuilder.putFields(k, this.objectToValue(v)));
        return structBuilder.build();
    }

    @Named(value="structToMap")
    default public Map<String, Object> structToMap(Struct struct) {
        if (struct == null || struct.getFieldsCount() == 0) {
            return null;
        }
        return struct.getFieldsMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.valueToObject((Value)e.getValue())));
    }

    private Value objectToValue(Object value) {
        Value.Builder valueBuilder = Value.newBuilder();
        if (value instanceof String) {
            valueBuilder.setStringValue((String)value);
        } else if (value instanceof Number) {
            valueBuilder.setNumberValue(((Number)value).doubleValue());
        } else if (value instanceof Boolean) {
            valueBuilder.setBoolValue(((Boolean)value).booleanValue());
        } else if (value instanceof Map) {
            valueBuilder.setStructValue(this.mapToStruct((Map)value));
        } else if (value instanceof List) {
            valueBuilder.setListValue(this.listToListValue((List)value));
        }
        return valueBuilder.build();
    }

    private Object valueToObject(Value value) {
        switch (value.getKindCase()) {
            case STRUCT_VALUE: {
                return this.structToMap(value.getStructValue());
            }
            case LIST_VALUE: {
                return value.getListValue().getValuesList().stream().map(this::valueToObject).collect(Collectors.toList());
            }
            case BOOL_VALUE: {
                return value.getBoolValue();
            }
            case NUMBER_VALUE: {
                return value.getNumberValue();
            }
            case STRING_VALUE: {
                return value.getStringValue();
            }
        }
        return null;
    }

    private ListValue listToListValue(List<Object> list) {
        ListValue.Builder listValueBuilder = ListValue.newBuilder();
        if (list != null) {
            list.forEach(o -> listValueBuilder.addValues(this.objectToValue(o)));
        }
        return listValueBuilder.build();
    }

    @Named(value="metadataToProto")
    default public Struct metadataToProto(Map<String, Object> metadata) {
        return this.mapToStruct(metadata);
    }

    @Named(value="metadataFromProto")
    default public Map<String, Object> metadataFromProto(Struct struct) {
        if (struct == null || struct.getFieldsCount() == 0) {
            return Collections.emptyMap();
        }
        return this.structToMap(struct);
    }

    @Named(value="zeroToNull")
    default public Integer zeroToNull(int value) {
        return value != 0 ? Integer.valueOf(value) : null;
    }

    @Named(value="intToIntegerOrNull")
    default public Integer intToIntegerOrNull(int value) {
        return value;
    }

    @Named(value="zeroLongToNull")
    default public Long zeroLongToNull(long value) {
        return value > 0L ? Long.valueOf(value) : null;
    }

    @Named(value="falseToNull")
    default public Boolean falseToNull(boolean value) {
        return value ? Boolean.valueOf(true) : null;
    }

    @Named(value="instantToMillis")
    default public long instantToMillis(Instant instant) {
        return instant != null ? instant.toEpochMilli() : 0L;
    }

    @Named(value="millisToInstant")
    default public Instant millisToInstant(long millis) {
        if (millis < 0L) {
            throw new InvalidParamsError(null, "Timestamp must be a non-negative number of milliseconds since epoch, but got: " + millis, null);
        }
        return millis > 0L ? Instant.ofEpochMilli(millis) : null;
    }

    @Named(value="taskStateOrNull")
    default public io.a2a.spec.TaskState taskStateOrNull(TaskState state) {
        if (state == null || state == TaskState.TASK_STATE_UNSPECIFIED) {
            return null;
        }
        if (state == TaskState.UNRECOGNIZED) {
            String validStates = Arrays.stream(io.a2a.spec.TaskState.values()).filter(s -> s != io.a2a.spec.TaskState.UNKNOWN).map(Enum::name).collect(Collectors.joining(", "));
            throw new InvalidParamsError(null, "Invalid task state value. Must be one of: " + validStates, null);
        }
        io.a2a.spec.TaskState result = TaskStateMapper.INSTANCE.fromProto(state);
        return result;
    }
}

