/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.utils;

import com.google.protobuf.ByteString;
import com.google.protobuf.ListValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.Value;
import io.a2a.grpc.APIKeySecurityScheme;
import io.a2a.grpc.AgentCapabilities;
import io.a2a.grpc.AgentCard;
import io.a2a.grpc.AgentCardSignature;
import io.a2a.grpc.AgentExtension;
import io.a2a.grpc.AgentInterface;
import io.a2a.grpc.AgentProvider;
import io.a2a.grpc.AgentSkill;
import io.a2a.grpc.Artifact;
import io.a2a.grpc.AuthenticationInfo;
import io.a2a.grpc.AuthorizationCodeOAuthFlow;
import io.a2a.grpc.CancelTaskRequest;
import io.a2a.grpc.ClientCredentialsOAuthFlow;
import io.a2a.grpc.CreateTaskPushNotificationConfigRequestOrBuilder;
import io.a2a.grpc.DataPart;
import io.a2a.grpc.DeleteTaskPushNotificationConfigRequest;
import io.a2a.grpc.FilePart;
import io.a2a.grpc.GetTaskPushNotificationConfigRequest;
import io.a2a.grpc.GetTaskRequest;
import io.a2a.grpc.HTTPAuthSecurityScheme;
import io.a2a.grpc.ImplicitOAuthFlow;
import io.a2a.grpc.ListTaskPushNotificationConfigRequest;
import io.a2a.grpc.Message;
import io.a2a.grpc.MutualTlsSecurityScheme;
import io.a2a.grpc.OAuth2SecurityScheme;
import io.a2a.grpc.OAuthFlows;
import io.a2a.grpc.OpenIdConnectSecurityScheme;
import io.a2a.grpc.Part;
import io.a2a.grpc.PasswordOAuthFlow;
import io.a2a.grpc.PushNotificationConfig;
import io.a2a.grpc.Role;
import io.a2a.grpc.Security;
import io.a2a.grpc.SecurityScheme;
import io.a2a.grpc.SendMessageConfiguration;
import io.a2a.grpc.SendMessageRequest;
import io.a2a.grpc.SendMessageResponse;
import io.a2a.grpc.StreamResponse;
import io.a2a.grpc.StringList;
import io.a2a.grpc.Task;
import io.a2a.grpc.TaskArtifactUpdateEvent;
import io.a2a.grpc.TaskPushNotificationConfig;
import io.a2a.grpc.TaskPushNotificationConfigOrBuilder;
import io.a2a.grpc.TaskState;
import io.a2a.grpc.TaskStatus;
import io.a2a.grpc.TaskStatusUpdateEvent;
import io.a2a.grpc.TaskSubscriptionRequest;
import io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import io.a2a.spec.EventKind;
import io.a2a.spec.FileContent;
import io.a2a.spec.FileWithBytes;
import io.a2a.spec.FileWithUri;
import io.a2a.spec.GetTaskPushNotificationConfigParams;
import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.InvalidRequestError;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.Message;
import io.a2a.spec.MessageSendConfiguration;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.MutualTLSSecurityScheme;
import io.a2a.spec.PushNotificationAuthenticationInfo;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.TaskArtifactUpdateEvent;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskQueryParams;
import io.a2a.spec.TaskStatusUpdateEvent;
import io.a2a.spec.TextPart;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ProtoUtils {

    public static class FromProto {
        public static TaskQueryParams taskQueryParams(GetTaskRequest request) {
            String name = request.getName();
            String id = name.substring(name.lastIndexOf(47) + 1);
            return new TaskQueryParams(id, Integer.valueOf(request.getHistoryLength()));
        }

        public static TaskIdParams taskIdParams(CancelTaskRequest request) {
            String name = request.getName();
            String id = name.substring(name.lastIndexOf(47) + 1);
            return new TaskIdParams(id);
        }

        public static MessageSendParams messageSendParams(SendMessageRequest request) {
            MessageSendParams.Builder builder = new MessageSendParams.Builder();
            builder.message(FromProto.message(request.getRequest()));
            if (request.hasConfiguration()) {
                builder.configuration(FromProto.messageSendConfiguration(request.getConfiguration()));
            }
            if (request.hasMetadata()) {
                builder.metadata(FromProto.struct(request.getMetadata()));
            }
            return builder.build();
        }

        public static io.a2a.spec.TaskPushNotificationConfig taskPushNotificationConfig(CreateTaskPushNotificationConfigRequestOrBuilder request) {
            return FromProto.taskPushNotificationConfig(request.getConfig(), true);
        }

        public static io.a2a.spec.TaskPushNotificationConfig taskPushNotificationConfig(TaskPushNotificationConfigOrBuilder config) {
            return FromProto.taskPushNotificationConfig(config, false);
        }

        private static io.a2a.spec.TaskPushNotificationConfig taskPushNotificationConfig(TaskPushNotificationConfigOrBuilder config, boolean create) {
            String name = config.getName();
            String[] parts = name.split("/");
            String configId = "";
            if (create) {
                if (parts.length < 3) {
                    throw new IllegalArgumentException("Invalid name format for TaskPushNotificationConfig: " + name);
                }
                if (parts.length == 4) {
                    configId = parts[3];
                }
            } else {
                if (parts.length < 4) {
                    throw new IllegalArgumentException("Invalid name format for TaskPushNotificationConfig: " + name);
                }
                configId = parts[3];
            }
            String taskId = parts[1];
            io.a2a.spec.PushNotificationConfig pnc = FromProto.pushNotification(config.getPushNotificationConfig(), configId);
            return new io.a2a.spec.TaskPushNotificationConfig(taskId, pnc);
        }

        public static GetTaskPushNotificationConfigParams getTaskPushNotificationConfigParams(GetTaskPushNotificationConfigRequest request) {
            String configId;
            String name = request.getName();
            String[] parts = name.split("/");
            String taskId = parts[1];
            if (parts.length == 2) {
                configId = taskId;
            } else {
                if (parts.length < 4) {
                    throw new IllegalArgumentException("Invalid name format for GetTaskPushNotificationConfigRequest: " + name);
                }
                configId = parts[3];
            }
            return new GetTaskPushNotificationConfigParams(taskId, configId);
        }

        public static TaskIdParams taskIdParams(TaskSubscriptionRequest request) {
            String name = request.getName();
            String id = name.substring(name.lastIndexOf(47) + 1);
            return new TaskIdParams(id);
        }

        public static ListTaskPushNotificationConfigParams listTaskPushNotificationConfigParams(ListTaskPushNotificationConfigRequest request) {
            String parent = request.getParent();
            String id = parent.substring(parent.lastIndexOf(47) + 1);
            return new ListTaskPushNotificationConfigParams(id);
        }

        public static DeleteTaskPushNotificationConfigParams deleteTaskPushNotificationConfigParams(DeleteTaskPushNotificationConfigRequest request) {
            String name = request.getName();
            String[] parts = name.split("/");
            if (parts.length < 4) {
                throw new IllegalArgumentException("Invalid name format for DeleteTaskPushNotificationConfigRequest: " + name);
            }
            String taskId = parts[1];
            String configId = parts[3];
            return new DeleteTaskPushNotificationConfigParams(taskId, configId);
        }

        private static io.a2a.spec.AgentCapabilities agentCapabilities(AgentCapabilities agentCapabilities) {
            return new io.a2a.spec.AgentCapabilities(agentCapabilities.getStreaming(), agentCapabilities.getPushNotifications(), false, agentCapabilities.getExtensionsList().stream().map(item -> FromProto.agentExtension(item)).collect(Collectors.toList()));
        }

        private static io.a2a.spec.AgentExtension agentExtension(AgentExtension agentExtension) {
            return new io.a2a.spec.AgentExtension(agentExtension.getDescription(), FromProto.struct(agentExtension.getParams()), agentExtension.getRequired(), agentExtension.getUri());
        }

        private static MessageSendConfiguration messageSendConfiguration(SendMessageConfiguration sendMessageConfiguration) {
            return new MessageSendConfiguration(new ArrayList(sendMessageConfiguration.getAcceptedOutputModesList()), Integer.valueOf(sendMessageConfiguration.getHistoryLength()), FromProto.pushNotification(sendMessageConfiguration.getPushNotification()), sendMessageConfiguration.getBlocking());
        }

        private static io.a2a.spec.PushNotificationConfig pushNotification(PushNotificationConfig pushNotification, String configId) {
            if (pushNotification == null || pushNotification.getDefaultInstanceForType().equals(pushNotification)) {
                return null;
            }
            return new io.a2a.spec.PushNotificationConfig(pushNotification.getUrl(), pushNotification.getToken().isEmpty() ? null : pushNotification.getToken(), pushNotification.hasAuthentication() ? FromProto.authenticationInfo(pushNotification.getAuthentication()) : null, pushNotification.getId().isEmpty() ? configId : pushNotification.getId());
        }

        private static io.a2a.spec.PushNotificationConfig pushNotification(PushNotificationConfig pushNotification) {
            return FromProto.pushNotification(pushNotification, pushNotification.getId());
        }

        private static PushNotificationAuthenticationInfo authenticationInfo(AuthenticationInfo authenticationInfo) {
            return new PushNotificationAuthenticationInfo(new ArrayList(authenticationInfo.getSchemesList()), authenticationInfo.getCredentials());
        }

        public static io.a2a.spec.Task task(Task task) {
            return new io.a2a.spec.Task(task.getId(), task.getContextId(), FromProto.taskStatus(task.getStatus()), task.getArtifactsList().stream().map(item -> FromProto.artifact(item)).collect(Collectors.toList()), task.getHistoryList().stream().map(item -> FromProto.message(item)).collect(Collectors.toList()), FromProto.struct(task.getMetadata()));
        }

        public static io.a2a.spec.Message message(Message message) {
            if (message.getMessageId().isEmpty()) {
                throw new InvalidParamsError();
            }
            return new io.a2a.spec.Message(FromProto.role(message.getRole()), message.getContentList().stream().map(item -> FromProto.part(item)).collect(Collectors.toList()), message.getMessageId().isEmpty() ? null : message.getMessageId(), message.getContextId().isEmpty() ? null : message.getContextId(), message.getTaskId().isEmpty() ? null : message.getTaskId(), null, FromProto.struct(message.getMetadata()));
        }

        public static io.a2a.spec.TaskStatusUpdateEvent taskStatusUpdateEvent(TaskStatusUpdateEvent taskStatusUpdateEvent) {
            return new TaskStatusUpdateEvent.Builder().taskId(taskStatusUpdateEvent.getTaskId()).status(FromProto.taskStatus(taskStatusUpdateEvent.getStatus())).contextId(taskStatusUpdateEvent.getContextId()).isFinal(taskStatusUpdateEvent.getFinal()).metadata(FromProto.struct(taskStatusUpdateEvent.getMetadata())).build();
        }

        public static io.a2a.spec.TaskArtifactUpdateEvent taskArtifactUpdateEvent(TaskArtifactUpdateEvent taskArtifactUpdateEvent) {
            return new TaskArtifactUpdateEvent.Builder().taskId(taskArtifactUpdateEvent.getTaskId()).append(Boolean.valueOf(taskArtifactUpdateEvent.getAppend())).lastChunk(Boolean.valueOf(taskArtifactUpdateEvent.getLastChunk())).artifact(FromProto.artifact(taskArtifactUpdateEvent.getArtifact())).contextId(taskArtifactUpdateEvent.getContextId()).metadata(FromProto.struct(taskArtifactUpdateEvent.getMetadata())).build();
        }

        private static io.a2a.spec.Artifact artifact(Artifact artifact) {
            return new io.a2a.spec.Artifact(artifact.getArtifactId(), artifact.getName(), artifact.getDescription(), artifact.getPartsList().stream().map(item -> FromProto.part(item)).collect(Collectors.toList()), FromProto.struct(artifact.getMetadata()));
        }

        private static io.a2a.spec.Part<?> part(Part part) {
            if (part.hasText()) {
                return FromProto.textPart(part.getText());
            }
            if (part.hasFile()) {
                return FromProto.filePart(part.getFile());
            }
            if (part.hasData()) {
                return FromProto.dataPart(part.getData());
            }
            throw new InvalidRequestError();
        }

        private static TextPart textPart(String text) {
            return new TextPart(text);
        }

        private static io.a2a.spec.FilePart filePart(FilePart filePart) {
            if (filePart.hasFileWithBytes()) {
                return new io.a2a.spec.FilePart((FileContent)new FileWithBytes(filePart.getMimeType(), null, filePart.getFileWithBytes().toStringUtf8()));
            }
            if (filePart.hasFileWithUri()) {
                return new io.a2a.spec.FilePart((FileContent)new FileWithUri(filePart.getMimeType(), null, filePart.getFileWithUri()));
            }
            throw new InvalidRequestError();
        }

        private static io.a2a.spec.DataPart dataPart(DataPart dataPart) {
            return new io.a2a.spec.DataPart(FromProto.struct(dataPart.getData()));
        }

        private static io.a2a.spec.TaskStatus taskStatus(TaskStatus taskStatus) {
            io.a2a.spec.TaskState state = FromProto.taskState(taskStatus.getState());
            if (state == null) {
                return null;
            }
            return new io.a2a.spec.TaskStatus(state, taskStatus.hasUpdate() ? FromProto.message(taskStatus.getUpdate()) : null, OffsetDateTime.ofInstant(Instant.ofEpochSecond(taskStatus.getTimestamp().getSeconds(), taskStatus.getTimestamp().getNanos()), ZoneOffset.UTC));
        }

        private static Message.Role role(Role role) {
            if (role == null) {
                return null;
            }
            return switch (role) {
                case Role.ROLE_USER -> Message.Role.USER;
                case Role.ROLE_AGENT -> Message.Role.AGENT;
                default -> throw new InvalidRequestError();
            };
        }

        private static io.a2a.spec.TaskState taskState(TaskState taskState) {
            if (taskState == null) {
                return null;
            }
            return switch (taskState) {
                default -> throw new IncompatibleClassChangeError();
                case TaskState.TASK_STATE_SUBMITTED -> io.a2a.spec.TaskState.SUBMITTED;
                case TaskState.TASK_STATE_WORKING -> io.a2a.spec.TaskState.WORKING;
                case TaskState.TASK_STATE_INPUT_REQUIRED -> io.a2a.spec.TaskState.INPUT_REQUIRED;
                case TaskState.TASK_STATE_AUTH_REQUIRED -> io.a2a.spec.TaskState.AUTH_REQUIRED;
                case TaskState.TASK_STATE_COMPLETED -> io.a2a.spec.TaskState.COMPLETED;
                case TaskState.TASK_STATE_CANCELLED -> io.a2a.spec.TaskState.CANCELED;
                case TaskState.TASK_STATE_FAILED -> io.a2a.spec.TaskState.FAILED;
                case TaskState.TASK_STATE_REJECTED -> io.a2a.spec.TaskState.REJECTED;
                case TaskState.TASK_STATE_UNSPECIFIED -> null;
                case TaskState.UNRECOGNIZED -> null;
            };
        }

        private static Map<String, Object> struct(Struct struct) {
            if (struct == null || struct.getFieldsCount() == 0) {
                return null;
            }
            return struct.getFieldsMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> FromProto.value((Value)e.getValue())));
        }

        private static Object value(Value value) {
            switch (value.getKindCase()) {
                case STRUCT_VALUE: {
                    return FromProto.struct(value.getStructValue());
                }
                case LIST_VALUE: {
                    return value.getListValue().getValuesList().stream().map(FromProto::value).collect(Collectors.toList());
                }
                case BOOL_VALUE: {
                    return value.getBoolValue();
                }
                case NUMBER_VALUE: {
                    return value.getNumberValue();
                }
                case STRING_VALUE: {
                    return value.getStringValue();
                }
            }
            throw new InvalidRequestError();
        }
    }

    public static class ToProto {
        public static AgentCard agentCard(io.a2a.spec.AgentCard agentCard) {
            AgentCard.Builder builder = AgentCard.newBuilder();
            if (agentCard.protocolVersion() != null) {
                builder.setProtocolVersion(agentCard.protocolVersion());
            }
            if (agentCard.name() != null) {
                builder.setName(agentCard.name());
            }
            if (agentCard.description() != null) {
                builder.setDescription(agentCard.description());
            }
            if (agentCard.url() != null) {
                builder.setUrl(agentCard.url());
            }
            if (agentCard.preferredTransport() != null) {
                builder.setPreferredTransport(agentCard.preferredTransport());
            }
            if (agentCard.additionalInterfaces() != null) {
                builder.addAllAdditionalInterfaces(agentCard.additionalInterfaces().stream().map(item -> ToProto.agentInterface(item)).collect(Collectors.toList()));
            }
            if (agentCard.provider() != null) {
                builder.setProvider(ToProto.agentProvider(agentCard.provider()));
            }
            if (agentCard.version() != null) {
                builder.setVersion(agentCard.version());
            }
            if (agentCard.documentationUrl() != null) {
                builder.setDocumentationUrl(agentCard.documentationUrl());
            }
            if (agentCard.capabilities() != null) {
                builder.setCapabilities(ToProto.agentCapabilities(agentCard.capabilities()));
            }
            if (agentCard.securitySchemes() != null) {
                builder.putAllSecuritySchemes(agentCard.securitySchemes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ToProto.securityScheme((io.a2a.spec.SecurityScheme)e.getValue()))));
            }
            if (agentCard.security() != null) {
                builder.addAllSecurity(agentCard.security().stream().map(s -> {
                    Security.Builder securityBuilder = Security.newBuilder();
                    s.forEach((key, value) -> {
                        StringList.Builder stringListBuilder = StringList.newBuilder();
                        stringListBuilder.addAllList((Iterable<String>)value);
                        securityBuilder.putSchemes((String)key, stringListBuilder.build());
                    });
                    return securityBuilder.build();
                }).collect(Collectors.toList()));
            }
            if (agentCard.defaultInputModes() != null) {
                builder.addAllDefaultInputModes(agentCard.defaultInputModes());
            }
            if (agentCard.defaultOutputModes() != null) {
                builder.addAllDefaultOutputModes(agentCard.defaultOutputModes());
            }
            if (agentCard.skills() != null) {
                builder.addAllSkills(agentCard.skills().stream().map(ToProto::agentSkill).collect(Collectors.toList()));
            }
            builder.setSupportsAuthenticatedExtendedCard(agentCard.supportsAuthenticatedExtendedCard());
            if (agentCard.signatures() != null) {
                builder.addAllSignatures(agentCard.signatures().stream().map(ToProto::agentCardSignature).collect(Collectors.toList()));
            }
            return builder.build();
        }

        public static Task task(io.a2a.spec.Task task) {
            Task.Builder builder = Task.newBuilder();
            builder.setId(task.getId());
            builder.setContextId(task.getContextId());
            builder.setStatus(ToProto.taskStatus(task.getStatus()));
            if (task.getArtifacts() != null) {
                builder.addAllArtifacts(task.getArtifacts().stream().map(ToProto::artifact).collect(Collectors.toList()));
            }
            if (task.getHistory() != null) {
                builder.addAllHistory(task.getHistory().stream().map(ToProto::message).collect(Collectors.toList()));
            }
            builder.setMetadata(ToProto.struct(task.getMetadata()));
            return builder.build();
        }

        public static Message message(io.a2a.spec.Message message) {
            Message.Builder builder = Message.newBuilder();
            builder.setMessageId(message.getMessageId());
            if (message.getContextId() != null) {
                builder.setContextId(message.getContextId());
            }
            if (message.getTaskId() != null) {
                builder.setTaskId(message.getTaskId());
            }
            builder.setRole(ToProto.role(message.getRole()));
            if (message.getParts() != null) {
                builder.addAllContent(message.getParts().stream().map(ToProto::part).collect(Collectors.toList()));
            }
            builder.setMetadata(ToProto.struct(message.getMetadata()));
            return builder.build();
        }

        public static TaskPushNotificationConfig taskPushNotificationConfig(io.a2a.spec.TaskPushNotificationConfig config) {
            TaskPushNotificationConfig.Builder builder = TaskPushNotificationConfig.newBuilder();
            String configId = config.pushNotificationConfig().id();
            builder.setName("tasks/" + config.taskId() + "/pushNotificationConfigs/" + (configId != null ? configId : config.taskId()));
            builder.setPushNotificationConfig(ToProto.pushNotificationConfig(config.pushNotificationConfig()));
            return builder.build();
        }

        private static PushNotificationConfig pushNotificationConfig(io.a2a.spec.PushNotificationConfig config) {
            PushNotificationConfig.Builder builder = PushNotificationConfig.newBuilder();
            if (config.url() != null) {
                builder.setUrl(config.url());
            }
            if (config.token() != null) {
                builder.setToken(config.token());
            }
            if (config.authentication() != null) {
                builder.setAuthentication(ToProto.authenticationInfo(config.authentication()));
            }
            if (config.id() != null) {
                builder.setId(config.id());
            }
            return builder.build();
        }

        public static TaskArtifactUpdateEvent taskArtifactUpdateEvent(io.a2a.spec.TaskArtifactUpdateEvent event) {
            TaskArtifactUpdateEvent.Builder builder = TaskArtifactUpdateEvent.newBuilder();
            builder.setTaskId(event.getTaskId());
            builder.setContextId(event.getContextId());
            builder.setArtifact(ToProto.artifact(event.getArtifact()));
            if (event.isAppend() != null) {
                builder.setAppend(event.isAppend());
            }
            if (event.isLastChunk() != null) {
                builder.setLastChunk(event.isLastChunk());
            }
            if (event.getMetadata() != null) {
                builder.setMetadata(ToProto.struct(event.getMetadata()));
            }
            return builder.build();
        }

        public static TaskStatusUpdateEvent taskStatusUpdateEvent(io.a2a.spec.TaskStatusUpdateEvent event) {
            TaskStatusUpdateEvent.Builder builder = TaskStatusUpdateEvent.newBuilder();
            builder.setTaskId(event.getTaskId());
            builder.setContextId(event.getContextId());
            builder.setStatus(ToProto.taskStatus(event.getStatus()));
            builder.setFinal(event.isFinal());
            if (event.getMetadata() != null) {
                builder.setMetadata(ToProto.struct(event.getMetadata()));
            }
            return builder.build();
        }

        private static Artifact artifact(io.a2a.spec.Artifact artifact) {
            Artifact.Builder builder = Artifact.newBuilder();
            if (artifact.artifactId() != null) {
                builder.setArtifactId(artifact.artifactId());
            }
            if (artifact.name() != null) {
                builder.setName(artifact.name());
            }
            if (artifact.description() != null) {
                builder.setDescription(artifact.description());
            }
            if (artifact.parts() != null) {
                builder.addAllParts(artifact.parts().stream().map(ToProto::part).collect(Collectors.toList()));
            }
            if (artifact.metadata() != null) {
                builder.setMetadata(ToProto.struct(artifact.metadata()));
            }
            return builder.build();
        }

        private static Part part(io.a2a.spec.Part<?> part) {
            Part.Builder builder = Part.newBuilder();
            if (part instanceof TextPart) {
                builder.setText(((TextPart)part).getText());
            } else if (part instanceof io.a2a.spec.FilePart) {
                builder.setFile(ToProto.filePart((io.a2a.spec.FilePart)part));
            } else if (part instanceof io.a2a.spec.DataPart) {
                builder.setData(ToProto.dataPart((io.a2a.spec.DataPart)part));
            }
            return builder.build();
        }

        private static FilePart filePart(io.a2a.spec.FilePart filePart) {
            FilePart.Builder builder = FilePart.newBuilder();
            FileContent fileContent = filePart.getFile();
            if (fileContent instanceof FileWithBytes) {
                builder.setFileWithBytes(ByteString.copyFrom((String)((FileWithBytes)fileContent).bytes(), (Charset)StandardCharsets.UTF_8));
            } else if (fileContent instanceof FileWithUri) {
                builder.setFileWithUri(((FileWithUri)fileContent).uri());
            }
            return builder.build();
        }

        private static DataPart dataPart(io.a2a.spec.DataPart dataPart) {
            DataPart.Builder builder = DataPart.newBuilder();
            if (dataPart.getData() != null) {
                builder.setData(ToProto.struct(dataPart.getData()));
            }
            return builder.build();
        }

        private static Role role(Message.Role role) {
            if (role == null) {
                return Role.ROLE_UNSPECIFIED;
            }
            return switch (role) {
                default -> throw new IncompatibleClassChangeError();
                case Message.Role.USER -> Role.ROLE_USER;
                case Message.Role.AGENT -> Role.ROLE_AGENT;
            };
        }

        private static TaskStatus taskStatus(io.a2a.spec.TaskStatus taskStatus) {
            TaskStatus.Builder builder = TaskStatus.newBuilder();
            if (taskStatus.state() != null) {
                builder.setState(ToProto.taskState(taskStatus.state()));
            }
            if (taskStatus.message() != null) {
                builder.setUpdate(ToProto.message(taskStatus.message()));
            }
            if (taskStatus.timestamp() != null) {
                Instant instant = taskStatus.timestamp().toInstant();
                builder.setTimestamp(Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build());
            }
            return builder.build();
        }

        private static TaskState taskState(io.a2a.spec.TaskState taskState) {
            if (taskState == null) {
                return TaskState.TASK_STATE_UNSPECIFIED;
            }
            return switch (taskState) {
                case io.a2a.spec.TaskState.SUBMITTED -> TaskState.TASK_STATE_SUBMITTED;
                case io.a2a.spec.TaskState.WORKING -> TaskState.TASK_STATE_WORKING;
                case io.a2a.spec.TaskState.INPUT_REQUIRED -> TaskState.TASK_STATE_INPUT_REQUIRED;
                case io.a2a.spec.TaskState.AUTH_REQUIRED -> TaskState.TASK_STATE_AUTH_REQUIRED;
                case io.a2a.spec.TaskState.COMPLETED -> TaskState.TASK_STATE_COMPLETED;
                case io.a2a.spec.TaskState.CANCELED -> TaskState.TASK_STATE_CANCELLED;
                case io.a2a.spec.TaskState.FAILED -> TaskState.TASK_STATE_FAILED;
                case io.a2a.spec.TaskState.REJECTED -> TaskState.TASK_STATE_REJECTED;
                default -> TaskState.TASK_STATE_UNSPECIFIED;
            };
        }

        private static AuthenticationInfo authenticationInfo(PushNotificationAuthenticationInfo pushNotificationAuthenticationInfo) {
            AuthenticationInfo.Builder builder = AuthenticationInfo.newBuilder();
            if (pushNotificationAuthenticationInfo.schemes() != null) {
                builder.addAllSchemes(pushNotificationAuthenticationInfo.schemes());
            }
            if (pushNotificationAuthenticationInfo.credentials() != null) {
                builder.setCredentials(pushNotificationAuthenticationInfo.credentials());
            }
            return builder.build();
        }

        public static SendMessageConfiguration messageSendConfiguration(MessageSendConfiguration messageSendConfiguration) {
            SendMessageConfiguration.Builder builder = SendMessageConfiguration.newBuilder();
            builder.addAllAcceptedOutputModes(messageSendConfiguration.acceptedOutputModes());
            if (messageSendConfiguration.historyLength() != null) {
                builder.setHistoryLength(messageSendConfiguration.historyLength());
            }
            if (messageSendConfiguration.pushNotification() != null) {
                builder.setPushNotification(ToProto.pushNotificationConfig(messageSendConfiguration.pushNotification()));
            }
            builder.setBlocking(messageSendConfiguration.blocking());
            return builder.build();
        }

        private static AgentProvider agentProvider(io.a2a.spec.AgentProvider agentProvider) {
            AgentProvider.Builder builder = AgentProvider.newBuilder();
            builder.setOrganization(agentProvider.organization());
            builder.setUrl(agentProvider.url());
            return builder.build();
        }

        private static AgentCapabilities agentCapabilities(io.a2a.spec.AgentCapabilities agentCapabilities) {
            AgentCapabilities.Builder builder = AgentCapabilities.newBuilder();
            builder.setStreaming(agentCapabilities.streaming());
            builder.setPushNotifications(agentCapabilities.pushNotifications());
            if (agentCapabilities.extensions() != null) {
                builder.addAllExtensions(agentCapabilities.extensions().stream().map(ToProto::agentExtension).collect(Collectors.toList()));
            }
            return builder.build();
        }

        private static AgentExtension agentExtension(io.a2a.spec.AgentExtension agentExtension) {
            AgentExtension.Builder builder = AgentExtension.newBuilder();
            if (agentExtension.description() != null) {
                builder.setDescription(agentExtension.description());
            }
            if (agentExtension.params() != null) {
                builder.setParams(ToProto.struct(agentExtension.params()));
            }
            builder.setRequired(agentExtension.required());
            if (agentExtension.uri() != null) {
                builder.setUri(agentExtension.uri());
            }
            return builder.build();
        }

        private static AgentSkill agentSkill(io.a2a.spec.AgentSkill agentSkill) {
            AgentSkill.Builder builder = AgentSkill.newBuilder();
            if (agentSkill.id() != null) {
                builder.setId(agentSkill.id());
            }
            if (agentSkill.name() != null) {
                builder.setName(agentSkill.name());
            }
            if (agentSkill.description() != null) {
                builder.setDescription(agentSkill.description());
            }
            if (agentSkill.tags() != null) {
                builder.addAllTags(agentSkill.tags());
            }
            if (agentSkill.examples() != null) {
                builder.addAllExamples(agentSkill.examples());
            }
            if (agentSkill.inputModes() != null) {
                builder.addAllInputModes(agentSkill.inputModes());
            }
            if (agentSkill.outputModes() != null) {
                builder.addAllOutputModes(agentSkill.outputModes());
            }
            if (agentSkill.security() != null) {
                builder.addAllSecurity(agentSkill.security().stream().map(s -> {
                    Security.Builder securityBuilder = Security.newBuilder();
                    s.forEach((key, value) -> {
                        StringList.Builder stringListBuilder = StringList.newBuilder();
                        stringListBuilder.addAllList((Iterable<String>)value);
                        securityBuilder.putSchemes((String)key, stringListBuilder.build());
                    });
                    return securityBuilder.build();
                }).collect(Collectors.toList()));
            }
            return builder.build();
        }

        private static AgentCardSignature agentCardSignature(io.a2a.spec.AgentCardSignature agentCardSignature) {
            AgentCardSignature.Builder builder = AgentCardSignature.newBuilder();
            builder.setProtected(agentCardSignature.protectedHeader());
            builder.setSignature(agentCardSignature.signature());
            if (agentCardSignature.header() != null) {
                builder.setHeader(ToProto.struct(agentCardSignature.header()));
            }
            return builder.build();
        }

        private static SecurityScheme securityScheme(io.a2a.spec.SecurityScheme securityScheme) {
            SecurityScheme.Builder builder = SecurityScheme.newBuilder();
            if (securityScheme instanceof io.a2a.spec.APIKeySecurityScheme) {
                builder.setApiKeySecurityScheme(ToProto.apiKeySecurityScheme((io.a2a.spec.APIKeySecurityScheme)securityScheme));
            } else if (securityScheme instanceof io.a2a.spec.HTTPAuthSecurityScheme) {
                builder.setHttpAuthSecurityScheme(ToProto.httpAuthSecurityScheme((io.a2a.spec.HTTPAuthSecurityScheme)securityScheme));
            } else if (securityScheme instanceof io.a2a.spec.OAuth2SecurityScheme) {
                builder.setOauth2SecurityScheme(ToProto.oauthSecurityScheme((io.a2a.spec.OAuth2SecurityScheme)securityScheme));
            } else if (securityScheme instanceof io.a2a.spec.OpenIdConnectSecurityScheme) {
                builder.setOpenIdConnectSecurityScheme(ToProto.openIdConnectSecurityScheme((io.a2a.spec.OpenIdConnectSecurityScheme)securityScheme));
            } else if (securityScheme instanceof MutualTLSSecurityScheme) {
                builder.setMtlsSecurityScheme(ToProto.mutualTlsSecurityScheme((MutualTLSSecurityScheme)securityScheme));
            }
            return builder.build();
        }

        private static APIKeySecurityScheme apiKeySecurityScheme(io.a2a.spec.APIKeySecurityScheme apiKeySecurityScheme) {
            APIKeySecurityScheme.Builder builder = APIKeySecurityScheme.newBuilder();
            if (apiKeySecurityScheme.getDescription() != null) {
                builder.setDescription(apiKeySecurityScheme.getDescription());
            }
            if (apiKeySecurityScheme.getIn() != null) {
                builder.setLocation(apiKeySecurityScheme.getIn());
            }
            if (apiKeySecurityScheme.getName() != null) {
                builder.setName(apiKeySecurityScheme.getName());
            }
            return builder.build();
        }

        private static HTTPAuthSecurityScheme httpAuthSecurityScheme(io.a2a.spec.HTTPAuthSecurityScheme httpAuthSecurityScheme) {
            HTTPAuthSecurityScheme.Builder builder = HTTPAuthSecurityScheme.newBuilder();
            if (httpAuthSecurityScheme.getBearerFormat() != null) {
                builder.setBearerFormat(httpAuthSecurityScheme.getBearerFormat());
            }
            if (httpAuthSecurityScheme.getDescription() != null) {
                builder.setDescription(httpAuthSecurityScheme.getDescription());
            }
            if (httpAuthSecurityScheme.getScheme() != null) {
                builder.setScheme(httpAuthSecurityScheme.getScheme());
            }
            return builder.build();
        }

        private static OAuth2SecurityScheme oauthSecurityScheme(io.a2a.spec.OAuth2SecurityScheme oauth2SecurityScheme) {
            OAuth2SecurityScheme.Builder builder = OAuth2SecurityScheme.newBuilder();
            if (oauth2SecurityScheme.getDescription() != null) {
                builder.setDescription(oauth2SecurityScheme.getDescription());
            }
            if (oauth2SecurityScheme.getFlows() != null) {
                builder.setFlows(ToProto.oauthFlows(oauth2SecurityScheme.getFlows()));
            }
            if (oauth2SecurityScheme.getOauth2MetadataUrl() != null) {
                builder.setOauth2MetadataUrl(oauth2SecurityScheme.getOauth2MetadataUrl());
            }
            return builder.build();
        }

        private static OAuthFlows oauthFlows(io.a2a.spec.OAuthFlows oAuthFlows) {
            OAuthFlows.Builder builder = OAuthFlows.newBuilder();
            if (oAuthFlows.authorizationCode() != null) {
                builder.setAuthorizationCode(ToProto.authorizationCodeOAuthFlow(oAuthFlows.authorizationCode()));
            }
            if (oAuthFlows.clientCredentials() != null) {
                builder.setClientCredentials(ToProto.clientCredentialsOAuthFlow(oAuthFlows.clientCredentials()));
            }
            if (oAuthFlows.implicit() != null) {
                builder.setImplicit(ToProto.implicitOAuthFlow(oAuthFlows.implicit()));
            }
            if (oAuthFlows.password() != null) {
                builder.setPassword(ToProto.passwordOAuthFlow(oAuthFlows.password()));
            }
            return builder.build();
        }

        private static AuthorizationCodeOAuthFlow authorizationCodeOAuthFlow(io.a2a.spec.AuthorizationCodeOAuthFlow authorizationCodeOAuthFlow) {
            AuthorizationCodeOAuthFlow.Builder builder = AuthorizationCodeOAuthFlow.newBuilder();
            if (authorizationCodeOAuthFlow.authorizationUrl() != null) {
                builder.setAuthorizationUrl(authorizationCodeOAuthFlow.authorizationUrl());
            }
            if (authorizationCodeOAuthFlow.refreshUrl() != null) {
                builder.setRefreshUrl(authorizationCodeOAuthFlow.refreshUrl());
            }
            if (authorizationCodeOAuthFlow.scopes() != null) {
                builder.putAllScopes(authorizationCodeOAuthFlow.scopes());
            }
            if (authorizationCodeOAuthFlow.tokenUrl() != null) {
                builder.setTokenUrl(authorizationCodeOAuthFlow.tokenUrl());
            }
            return builder.build();
        }

        private static ClientCredentialsOAuthFlow clientCredentialsOAuthFlow(io.a2a.spec.ClientCredentialsOAuthFlow clientCredentialsOAuthFlow) {
            ClientCredentialsOAuthFlow.Builder builder = ClientCredentialsOAuthFlow.newBuilder();
            if (clientCredentialsOAuthFlow.refreshUrl() != null) {
                builder.setRefreshUrl(clientCredentialsOAuthFlow.refreshUrl());
            }
            if (clientCredentialsOAuthFlow.scopes() != null) {
                builder.putAllScopes(clientCredentialsOAuthFlow.scopes());
            }
            if (clientCredentialsOAuthFlow.tokenUrl() != null) {
                builder.setTokenUrl(clientCredentialsOAuthFlow.tokenUrl());
            }
            return builder.build();
        }

        private static ImplicitOAuthFlow implicitOAuthFlow(io.a2a.spec.ImplicitOAuthFlow implicitOAuthFlow) {
            ImplicitOAuthFlow.Builder builder = ImplicitOAuthFlow.newBuilder();
            if (implicitOAuthFlow.authorizationUrl() != null) {
                builder.setAuthorizationUrl(implicitOAuthFlow.authorizationUrl());
            }
            if (implicitOAuthFlow.refreshUrl() != null) {
                builder.setRefreshUrl(implicitOAuthFlow.refreshUrl());
            }
            if (implicitOAuthFlow.scopes() != null) {
                builder.putAllScopes(implicitOAuthFlow.scopes());
            }
            return builder.build();
        }

        private static PasswordOAuthFlow passwordOAuthFlow(io.a2a.spec.PasswordOAuthFlow passwordOAuthFlow) {
            PasswordOAuthFlow.Builder builder = PasswordOAuthFlow.newBuilder();
            if (passwordOAuthFlow.refreshUrl() != null) {
                builder.setRefreshUrl(passwordOAuthFlow.refreshUrl());
            }
            if (passwordOAuthFlow.scopes() != null) {
                builder.putAllScopes(passwordOAuthFlow.scopes());
            }
            if (passwordOAuthFlow.tokenUrl() != null) {
                builder.setTokenUrl(passwordOAuthFlow.tokenUrl());
            }
            return builder.build();
        }

        private static OpenIdConnectSecurityScheme openIdConnectSecurityScheme(io.a2a.spec.OpenIdConnectSecurityScheme openIdConnectSecurityScheme) {
            OpenIdConnectSecurityScheme.Builder builder = OpenIdConnectSecurityScheme.newBuilder();
            if (openIdConnectSecurityScheme.getDescription() != null) {
                builder.setDescription(openIdConnectSecurityScheme.getDescription());
            }
            if (openIdConnectSecurityScheme.getOpenIdConnectUrl() != null) {
                builder.setOpenIdConnectUrl(openIdConnectSecurityScheme.getOpenIdConnectUrl());
            }
            return builder.build();
        }

        private static MutualTlsSecurityScheme mutualTlsSecurityScheme(MutualTLSSecurityScheme mutualTlsSecurityScheme) {
            MutualTlsSecurityScheme.Builder builder = MutualTlsSecurityScheme.newBuilder();
            if (mutualTlsSecurityScheme.getDescription() != null) {
                builder.setDescription(mutualTlsSecurityScheme.getDescription());
            }
            return builder.build();
        }

        private static AgentInterface agentInterface(io.a2a.spec.AgentInterface agentInterface) {
            AgentInterface.Builder builder = AgentInterface.newBuilder();
            if (agentInterface.transport() != null) {
                builder.setTransport(agentInterface.transport());
            }
            if (agentInterface.url() != null) {
                builder.setUrl(agentInterface.url());
            }
            return builder.build();
        }

        public static Struct struct(Map<String, Object> map) {
            Struct.Builder structBuilder = Struct.newBuilder();
            if (map != null) {
                map.forEach((k, v) -> structBuilder.putFields(k, ToProto.value(v)));
            }
            return structBuilder.build();
        }

        private static Value value(Object value) {
            Value.Builder valueBuilder = Value.newBuilder();
            if (value instanceof String) {
                valueBuilder.setStringValue((String)value);
            } else if (value instanceof Number) {
                valueBuilder.setNumberValue(((Number)value).doubleValue());
            } else if (value instanceof Boolean) {
                valueBuilder.setBoolValue(((Boolean)value).booleanValue());
            } else if (value instanceof Map) {
                valueBuilder.setStructValue(ToProto.struct((Map)value));
            } else if (value instanceof List) {
                valueBuilder.setListValue(ToProto.listValue((List)value));
            }
            return valueBuilder.build();
        }

        private static ListValue listValue(List<Object> list) {
            ListValue.Builder listValueBuilder = ListValue.newBuilder();
            if (list != null) {
                list.forEach(o -> listValueBuilder.addValues(ToProto.value(o)));
            }
            return listValueBuilder.build();
        }

        public static StreamResponse streamResponse(StreamingEventKind streamingEventKind) {
            if (streamingEventKind instanceof io.a2a.spec.TaskStatusUpdateEvent) {
                return StreamResponse.newBuilder().setStatusUpdate(ToProto.taskStatusUpdateEvent((io.a2a.spec.TaskStatusUpdateEvent)streamingEventKind)).build();
            }
            if (streamingEventKind instanceof io.a2a.spec.TaskArtifactUpdateEvent) {
                return StreamResponse.newBuilder().setArtifactUpdate(ToProto.taskArtifactUpdateEvent((io.a2a.spec.TaskArtifactUpdateEvent)streamingEventKind)).build();
            }
            if (streamingEventKind instanceof io.a2a.spec.Message) {
                return StreamResponse.newBuilder().setMsg(ToProto.message((io.a2a.spec.Message)streamingEventKind)).build();
            }
            if (streamingEventKind instanceof io.a2a.spec.Task) {
                return StreamResponse.newBuilder().setTask(ToProto.task((io.a2a.spec.Task)streamingEventKind)).build();
            }
            throw new IllegalArgumentException("Unsupported event type: " + String.valueOf(streamingEventKind));
        }

        public static SendMessageResponse taskOrMessage(EventKind eventKind) {
            if (eventKind instanceof io.a2a.spec.Task) {
                return SendMessageResponse.newBuilder().setTask(ToProto.task((io.a2a.spec.Task)eventKind)).build();
            }
            if (eventKind instanceof io.a2a.spec.Message) {
                return SendMessageResponse.newBuilder().setMsg(ToProto.message((io.a2a.spec.Message)eventKind)).build();
            }
            throw new IllegalArgumentException("Unsupported event type: " + String.valueOf(eventKind));
        }
    }
}

