/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.util.async;

import io.a2a.util.Assert;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import mutiny.zero.BackpressureStrategy;
import mutiny.zero.Tube;
import mutiny.zero.TubeConfiguration;
import mutiny.zero.ZeroPublisher;
import mutiny.zero.operators.Transform;
import org.jspecify.annotations.Nullable;

public class AsyncUtils {
    private static final int DEFAULT_TUBE_BUFFER_SIZE = 256;

    public static TubeConfiguration createTubeConfig() {
        return AsyncUtils.createTubeConfig(256);
    }

    public static TubeConfiguration createTubeConfig(int bufferSize) {
        return new TubeConfiguration().withBackpressureStrategy(BackpressureStrategy.BUFFER).withBufferSize(256);
    }

    public static <T> void consumer(TubeConfiguration config, Flow.Publisher<T> source, final Function<T, Boolean> nextFunction, Consumer<Throwable> errorConsumer) {
        BiFunction nextBiFunction = new BiFunction<Consumer<Throwable>, T, Boolean>(){

            @Override
            public Boolean apply(Consumer<Throwable> throwableConsumer, T t) {
                return (Boolean)nextFunction.apply(t);
            }
        };
        ZeroPublisher.create((TubeConfiguration)config, tube -> source.subscribe(new ConsumingSubscriber(nextBiFunction, errorConsumer))).subscribe(new Flow.Subscriber<Object>(){
            private  @Nullable Flow.Subscription subscription;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                subscription.request(1L);
            }

            @Override
            public void onNext(Object item) {
                if (this.subscription != null) {
                    this.subscription.request(1L);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                if (this.subscription != null) {
                    this.subscription.cancel();
                }
            }

            @Override
            public void onComplete() {
                if (this.subscription != null) {
                    this.subscription.cancel();
                }
            }
        });
    }

    public static <T> Flow.Publisher<T> processor(TubeConfiguration config, Flow.Publisher<T> source, BiFunction<Consumer<Throwable>, T, Boolean> nextFunction) {
        return ZeroPublisher.create((TubeConfiguration)config, tube -> source.subscribe(new ProcessingSubscriber(tube, nextFunction)));
    }

    public static <T, N> Flow.Publisher<N> convertingProcessor(Flow.Publisher<T> source, Function<T, N> converterFunction) {
        return new Transform(source, converterFunction);
    }

    private static class ProcessingSubscriber<T>
    extends AbstractSubscriber<T> {
        public ProcessingSubscriber(Tube<T> tube, BiFunction<Consumer<Throwable>, T, Boolean> nextFunction) {
            super(nextFunction, arg_0 -> tube.send(arg_0), t -> {
                if (t == null) {
                    tube.complete();
                } else {
                    tube.fail(t);
                }
            });
            Assert.checkNotNullParam((String)"tube", tube);
        }
    }

    private static class ConsumingSubscriber<T>
    extends AbstractSubscriber<T> {
        public ConsumingSubscriber(BiFunction<Consumer<Throwable>, T, Boolean> nextFunction, @Nullable Consumer<Throwable> failureOrCompleteConsumer) {
            super(nextFunction, null, failureOrCompleteConsumer);
        }
    }

    private static class ConvertingProcessingSubscriber<T, N>
    implements Flow.Subscriber<T> {
        private  @Nullable Flow.Subscription subscription;
        private final Tube<N> tube;
        private final BiFunction<Consumer<Throwable>, T, N> converterBiFunction;

        public ConvertingProcessingSubscriber(Tube<N> tube, Function<T, N> converterFunction) {
            Assert.checkNotNullParam((String)"tube", tube);
            Assert.checkNotNullParam((String)"converterFunction", converterFunction);
            this.tube = tube;
            this.converterBiFunction = (throwableConsumer, t) -> converterFunction.apply(t);
        }

        public ConvertingProcessingSubscriber(Tube<N> tube, BiFunction<Consumer<Throwable>, T, N> converterBiFunction) {
            Assert.checkNotNullParam((String)"tube", tube);
            Assert.checkNotNullParam((String)"converterBiFunction", converterBiFunction);
            this.tube = tube;
            this.converterBiFunction = converterBiFunction;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            subscription.request(1L);
        }

        @Override
        public void onNext(T item) {
            AtomicBoolean errorRaised = new AtomicBoolean(false);
            Consumer<Throwable> errorConsumer = t -> {
                errorRaised.set(true);
                this.onError((Throwable)t);
            };
            Object converted = null;
            try {
                converted = this.converterBiFunction.apply(errorConsumer, (Consumer<Throwable>)item);
            }
            catch (Throwable t2) {
                errorConsumer.accept(t2);
                return;
            }
            if (!errorRaised.get()) {
                this.tube.send(converted);
                if (this.subscription != null) {
                    this.subscription.request(1L);
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.subscription != null) {
                this.subscription.cancel();
            }
            this.tube.fail(throwable);
        }

        @Override
        public void onComplete() {
            if (this.subscription != null) {
                this.subscription.cancel();
            }
            this.tube.complete();
        }
    }

    private static abstract class AbstractSubscriber<T>
    implements Flow.Subscriber<T> {
        private  @Nullable Flow.Subscription subscription;
        private final BiFunction<Consumer<Throwable>, T, Boolean> nextFunction;
        private final @Nullable Consumer<T> publishNextConsumer;
        private final @Nullable Consumer<Throwable> failureOrCompleteConsumer;

        protected AbstractSubscriber(BiFunction<Consumer<Throwable>, T, Boolean> nextFunction, @Nullable Consumer<T> publishNextConsumer, @Nullable Consumer<Throwable> failureOrCompleteConsumer) {
            Assert.checkNotNullParam((String)"nextFunction", nextFunction);
            this.nextFunction = nextFunction;
            this.publishNextConsumer = publishNextConsumer;
            this.failureOrCompleteConsumer = failureOrCompleteConsumer;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            subscription.request(1L);
        }

        @Override
        public void onNext(T item) {
            AtomicReference errorRaised = new AtomicReference();
            Consumer<Throwable> errorConsumer = t -> {
                errorRaised.set(t);
                this.onError((Throwable)t);
            };
            boolean continueProcessing = false;
            if (errorRaised.get() == null) {
                try {
                    continueProcessing = this.nextFunction.apply(errorConsumer, (Consumer<Throwable>)item);
                }
                catch (Throwable t2) {
                    errorConsumer.accept(t2);
                }
            }
            if (!continueProcessing || errorRaised.get() != null) {
                if (this.subscription != null) {
                    this.subscription.cancel();
                }
            } else {
                if (this.publishNextConsumer != null) {
                    this.publishNextConsumer.accept(item);
                }
                if (this.subscription != null) {
                    this.subscription.request(1L);
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.subscription != null) {
                this.subscription.cancel();
            }
            if (this.failureOrCompleteConsumer != null) {
                this.failureOrCompleteConsumer.accept(throwable);
            }
        }

        @Override
        public void onComplete() {
            if (this.subscription != null) {
                this.subscription.cancel();
            }
            if (this.failureOrCompleteConsumer != null) {
                this.failureOrCompleteConsumer.accept(null);
            }
        }
    }
}

