/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.tasks;

import io.a2a.client.http.A2AHttpClient;
import io.a2a.client.http.A2AHttpClientFactory;
import io.a2a.jsonrpc.common.json.JsonUtil;
import io.a2a.server.tasks.PushNotificationConfigStore;
import io.a2a.server.tasks.PushNotificationSender;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigResult;
import io.a2a.spec.Message;
import io.a2a.spec.PushNotificationConfig;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.Task;
import io.a2a.spec.TaskArtifactUpdateEvent;
import io.a2a.spec.TaskStatusUpdateEvent;
import jakarta.annotation.Nullable;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class BasePushNotificationSender
implements PushNotificationSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePushNotificationSender.class);
    public static final int DEFAULT_PAGE_SIZE = 100;
    private A2AHttpClient httpClient;
    private PushNotificationConfigStore configStore;

    protected BasePushNotificationSender() {
        this.httpClient = null;
        this.configStore = null;
    }

    @Inject
    public BasePushNotificationSender(PushNotificationConfigStore configStore) {
        this.httpClient = A2AHttpClientFactory.create();
        this.configStore = configStore;
    }

    public BasePushNotificationSender(PushNotificationConfigStore configStore, A2AHttpClient httpClient) {
        this.configStore = configStore;
        this.httpClient = httpClient;
    }

    @Override
    public void sendNotification(StreamingEventKind event) {
        ListTaskPushNotificationConfigResult pageResult;
        String taskId = this.extractTaskId(event);
        if (taskId == null) {
            LOGGER.warn("Cannot send push notification: event does not contain taskId");
            return;
        }
        ArrayList configs = new ArrayList();
        String nextPageToken = null;
        do {
            if ((pageResult = this.configStore.getInfo(new ListTaskPushNotificationConfigParams(taskId, 100, nextPageToken == null ? "" : nextPageToken, ""))).configs().isEmpty()) continue;
            configs.addAll(pageResult.configs());
        } while ((nextPageToken = pageResult.nextPageToken()) != null);
        List<CompletableFuture> dispatchResults = configs.stream().map(pushConfig -> this.dispatch(event, pushConfig.config())).toList();
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(dispatchResults.toArray(new CompletableFuture[0]));
        CompletionStage dispatchResult = allFutures.thenApply(v -> dispatchResults.stream().allMatch(CompletableFuture::join));
        try {
            boolean allSent = (Boolean)((CompletableFuture)dispatchResult).get();
            if (!allSent) {
                LOGGER.warn("Some push notifications failed to send for taskId: " + taskId);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.warn("Some push notifications failed to send for taskId " + taskId + ": {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Nullable
    protected String extractTaskId(StreamingEventKind event) {
        if (event instanceof Task) {
            Task task = (Task)event;
            return task.id();
        }
        if (event instanceof Message) {
            Message message = (Message)event;
            return message.taskId();
        }
        if (event instanceof TaskStatusUpdateEvent) {
            TaskStatusUpdateEvent statusUpdate = (TaskStatusUpdateEvent)event;
            return statusUpdate.taskId();
        }
        if (event instanceof TaskArtifactUpdateEvent) {
            TaskArtifactUpdateEvent artifactUpdate = (TaskArtifactUpdateEvent)event;
            return artifactUpdate.taskId();
        }
        throw new IllegalStateException("Unknown StreamingEventKind: " + String.valueOf(event));
    }

    private CompletableFuture<Boolean> dispatch(StreamingEventKind event, PushNotificationConfig pushInfo) {
        return CompletableFuture.supplyAsync(() -> this.dispatchNotification(event, pushInfo));
    }

    private boolean dispatchNotification(StreamingEventKind event, PushNotificationConfig pushInfo) {
        String body;
        String url = pushInfo.url();
        String token = pushInfo.token();
        A2AHttpClient.PostBuilder postBuilder = this.httpClient.createPost();
        if (token != null && !token.isBlank()) {
            postBuilder.addHeader("X-A2A-Notification-Token", token);
        }
        try {
            body = JsonUtil.toJson((Object)event);
        }
        catch (Throwable throwable) {
            LOGGER.error("Error serializing StreamingEventKind to JSON: {}", (Object)throwable.getMessage(), (Object)throwable);
            return false;
        }
        try {
            ((A2AHttpClient.PostBuilder)((A2AHttpClient.PostBuilder)postBuilder.url(url)).addHeader("Content-Type", "application/json")).body(body).post();
        }
        catch (IOException | InterruptedException e) {
            LOGGER.debug("Error pushing data to " + url + ": {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return true;
    }
}

