/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.rest.quarkus;

import io.a2a.server.ServerCallContext;
import io.a2a.server.auth.UnauthenticatedUser;
import io.a2a.server.auth.User;
import io.a2a.server.extensions.A2AExtensions;
import io.a2a.server.rest.quarkus.CallContextFactory;
import io.a2a.server.util.async.Internal;
import io.a2a.spec.InternalError;
import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.JSONRPCError;
import io.a2a.spec.MethodNotFoundError;
import io.a2a.transport.rest.handler.RestHandler;
import io.quarkus.security.Authenticated;
import io.quarkus.vertx.web.Body;
import io.quarkus.vertx.web.ReactiveRoutes;
import io.quarkus.vertx.web.Route;
import io.smallrye.mutiny.Multi;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.security.PermitAll;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

@Singleton
@Authenticated
public class A2AServerRoutes {
    @Inject
    RestHandler jsonRestHandler;
    private static volatile @Nullable Runnable streamingMultiSseSupportSubscribedRunnable;
    @Inject
    @Internal
    Executor executor;
    @Inject
    Instance<CallContextFactory> callContextFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Route(regex="^/v1/message:send$", order=1, methods={Route.HttpMethod.POST}, consumes={"application/json"}, type=Route.HandlerType.BLOCKING)
    public void sendMessage(@Body String body, RoutingContext rc) {
        ServerCallContext context = this.createCallContext(rc, "message/send");
        RestHandler.HTTPRestResponse response = null;
        try {
            response = this.jsonRestHandler.sendMessage(body, context);
        }
        catch (Throwable t) {
            response = this.jsonRestHandler.createErrorResponse((JSONRPCError)new InternalError(t.getMessage()));
        }
        finally {
            this.sendResponse(rc, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Route(regex="^/v1/message:stream$", order=1, methods={Route.HttpMethod.POST}, consumes={"application/json"}, type=Route.HandlerType.BLOCKING)
    public void sendMessageStreaming(@Body String body, RoutingContext rc) {
        ServerCallContext context = this.createCallContext(rc, "message/stream");
        RestHandler.HTTPRestStreamingResponse streamingResponse = null;
        RestHandler.HTTPRestResponse error = null;
        try {
            RestHandler.HTTPRestResponse response = this.jsonRestHandler.sendStreamingMessage(body, context);
            if (response instanceof RestHandler.HTTPRestStreamingResponse) {
                RestHandler.HTTPRestStreamingResponse hTTPRestStreamingResponse;
                streamingResponse = hTTPRestStreamingResponse = (RestHandler.HTTPRestStreamingResponse)response;
            } else {
                error = response;
            }
            if (error != null) {
                this.sendResponse(rc, error);
                return;
            }
            if (streamingResponse == null) return;
        }
        catch (Throwable throwable) {
            if (error != null) {
                this.sendResponse(rc, error);
                throw throwable;
            } else {
                if (streamingResponse == null) throw throwable;
                Multi events = Multi.createFrom().publisher(streamingResponse.getPublisher());
                this.executor.execute(() -> MultiSseSupport.subscribeObject((Multi<Object>)events.map(i -> i), rc));
            }
            throw throwable;
        }
        Multi events = Multi.createFrom().publisher(streamingResponse.getPublisher());
        this.executor.execute(() -> MultiSseSupport.subscribeObject((Multi<Object>)events.map(i -> i), rc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Route(path="/v1/tasks/:id", order=1, methods={Route.HttpMethod.GET}, type=Route.HandlerType.BLOCKING)
    public void getTask(RoutingContext rc) {
        RestHandler.HTTPRestResponse response;
        block8: {
            String taskId = rc.pathParam("id");
            ServerCallContext context = this.createCallContext(rc, "tasks/get");
            response = null;
            try {
                if (taskId == null || taskId.isEmpty()) {
                    response = this.jsonRestHandler.createErrorResponse((JSONRPCError)new InvalidParamsError("bad task id"));
                    break block8;
                }
                int historyLength = 0;
                if (rc.request().params().contains("history_length")) {
                    historyLength = Integer.parseInt(rc.request().params().get("history_length"));
                }
                response = this.jsonRestHandler.getTask(taskId, historyLength, context);
            }
            catch (NumberFormatException e) {
                response = this.jsonRestHandler.createErrorResponse((JSONRPCError)new InvalidParamsError("bad history_length"));
                this.sendResponse(rc, response);
            }
            catch (Throwable t) {
                response = this.jsonRestHandler.createErrorResponse((JSONRPCError)new InternalError(t.getMessage()));
                this.sendResponse(rc, response);
                {
                    catch (Throwable throwable) {
                        this.sendResponse(rc, response);
                        throw throwable;
                    }
                }
            }
        }
        this.sendResponse(rc, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Route(regex="^/v1/tasks/([^/]+):cancel$", order=1, methods={Route.HttpMethod.POST}, type=Route.HandlerType.BLOCKING)
    public void cancelTask(RoutingContext rc) {
        String taskId = rc.pathParam("param0");
        ServerCallContext context = this.createCallContext(rc, "tasks/cancel");
        RestHandler.HTTPRestResponse response = null;
        try {
            response = taskId == null || taskId.isEmpty() ? this.jsonRestHandler.createErrorResponse((JSONRPCError)new InvalidParamsError("bad task id")) : this.jsonRestHandler.cancelTask(taskId, context);
            this.sendResponse(rc, response);
        }
        catch (Throwable t) {
            try {
                if (t instanceof JSONRPCError) {
                    JSONRPCError error = (JSONRPCError)t;
                    response = this.jsonRestHandler.createErrorResponse(error);
                } else {
                    response = this.jsonRestHandler.createErrorResponse((JSONRPCError)new InternalError(t.getMessage()));
                }
                this.sendResponse(rc, response);
            }
            catch (Throwable throwable) {
                this.sendResponse(rc, response);
                throw throwable;
            }
        }
    }

    private void sendResponse(RoutingContext rc, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable RestHandler.HTTPRestResponse response) {
        if (response != null) {
            rc.response().setStatusCode(response.getStatusCode()).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)response.getContentType()).end(response.getBody());
        } else {
            rc.response().end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Route(regex="^/v1/tasks/([^/]+):subscribe$", order=1, methods={Route.HttpMethod.POST}, type=Route.HandlerType.BLOCKING)
    public void resubscribeTask(RoutingContext rc) {
        String taskId = rc.pathParam("param0");
        ServerCallContext context = this.createCallContext(rc, "tasks/resubscribe");
        RestHandler.HTTPRestStreamingResponse streamingResponse = null;
        RestHandler.HTTPRestResponse error = null;
        try {
            if (taskId == null || taskId.isEmpty()) {
                error = this.jsonRestHandler.createErrorResponse((JSONRPCError)new InvalidParamsError("bad task id"));
            } else {
                RestHandler.HTTPRestResponse response = this.jsonRestHandler.resubscribeTask(taskId, context);
                if (response instanceof RestHandler.HTTPRestStreamingResponse) {
                    RestHandler.HTTPRestStreamingResponse hTTPRestStreamingResponse;
                    streamingResponse = hTTPRestStreamingResponse = (RestHandler.HTTPRestStreamingResponse)response;
                } else {
                    error = response;
                }
            }
            if (error != null) {
                this.sendResponse(rc, error);
                return;
            }
            if (streamingResponse == null) return;
        }
        catch (Throwable throwable) {
            if (error != null) {
                this.sendResponse(rc, error);
                throw throwable;
            } else {
                if (streamingResponse == null) throw throwable;
                Multi events = Multi.createFrom().publisher(streamingResponse.getPublisher());
                this.executor.execute(() -> MultiSseSupport.subscribeObject((Multi<Object>)events.map(i -> i), rc));
            }
            throw throwable;
        }
        Multi events = Multi.createFrom().publisher(streamingResponse.getPublisher());
        this.executor.execute(() -> MultiSseSupport.subscribeObject((Multi<Object>)events.map(i -> i), rc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Route(path="/v1/tasks/:id/pushNotificationConfigs", order=1, methods={Route.HttpMethod.POST}, consumes={"application/json"}, type=Route.HandlerType.BLOCKING)
    public void setTaskPushNotificationConfiguration(@Body String body, RoutingContext rc) {
        String taskId = rc.pathParam("id");
        ServerCallContext context = this.createCallContext(rc, "tasks/pushNotificationConfig/set");
        RestHandler.HTTPRestResponse response = null;
        try {
            response = taskId == null || taskId.isEmpty() ? this.jsonRestHandler.createErrorResponse((JSONRPCError)new InvalidParamsError("bad task id")) : this.jsonRestHandler.setTaskPushNotificationConfiguration(taskId, body, context);
            this.sendResponse(rc, response);
        }
        catch (Throwable t) {
            try {
                response = this.jsonRestHandler.createErrorResponse((JSONRPCError)new InternalError(t.getMessage()));
                this.sendResponse(rc, response);
            }
            catch (Throwable throwable) {
                this.sendResponse(rc, response);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Route(path="/v1/tasks/:id/pushNotificationConfigs/:configId", order=1, methods={Route.HttpMethod.GET}, type=Route.HandlerType.BLOCKING)
    public void getTaskPushNotificationConfiguration(RoutingContext rc) {
        String taskId = rc.pathParam("id");
        String configId = rc.pathParam("configId");
        ServerCallContext context = this.createCallContext(rc, "tasks/pushNotificationConfig/get");
        RestHandler.HTTPRestResponse response = null;
        try {
            response = taskId == null || taskId.isEmpty() ? this.jsonRestHandler.createErrorResponse((JSONRPCError)new InvalidParamsError("bad task id")) : this.jsonRestHandler.getTaskPushNotificationConfiguration(taskId, configId, context);
            this.sendResponse(rc, response);
        }
        catch (Throwable t) {
            try {
                response = this.jsonRestHandler.createErrorResponse((JSONRPCError)new InternalError(t.getMessage()));
                this.sendResponse(rc, response);
            }
            catch (Throwable throwable) {
                this.sendResponse(rc, response);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Route(path="/v1/tasks/:id/pushNotificationConfigs", order=1, methods={Route.HttpMethod.GET}, type=Route.HandlerType.BLOCKING)
    public void listTaskPushNotificationConfigurations(RoutingContext rc) {
        String taskId = rc.pathParam("id");
        ServerCallContext context = this.createCallContext(rc, "tasks/pushNotificationConfig/list");
        RestHandler.HTTPRestResponse response = null;
        try {
            response = taskId == null || taskId.isEmpty() ? this.jsonRestHandler.createErrorResponse((JSONRPCError)new InvalidParamsError("bad task id")) : this.jsonRestHandler.listTaskPushNotificationConfigurations(taskId, context);
            this.sendResponse(rc, response);
        }
        catch (Throwable t) {
            try {
                response = this.jsonRestHandler.createErrorResponse((JSONRPCError)new InternalError(t.getMessage()));
                this.sendResponse(rc, response);
            }
            catch (Throwable throwable) {
                this.sendResponse(rc, response);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Route(path="/v1/tasks/:id/pushNotificationConfigs/:configId", order=1, methods={Route.HttpMethod.DELETE}, type=Route.HandlerType.BLOCKING)
    public void deleteTaskPushNotificationConfiguration(RoutingContext rc) {
        String taskId = rc.pathParam("id");
        String configId = rc.pathParam("configId");
        ServerCallContext context = this.createCallContext(rc, "tasks/pushNotificationConfig/delete");
        RestHandler.HTTPRestResponse response = null;
        try {
            response = taskId == null || taskId.isEmpty() ? this.jsonRestHandler.createErrorResponse((JSONRPCError)new InvalidParamsError("bad task id")) : (configId == null || configId.isEmpty() ? this.jsonRestHandler.createErrorResponse((JSONRPCError)new InvalidParamsError("bad config id")) : this.jsonRestHandler.deleteTaskPushNotificationConfiguration(taskId, configId, context));
            this.sendResponse(rc, response);
        }
        catch (Throwable t) {
            try {
                response = this.jsonRestHandler.createErrorResponse((JSONRPCError)new InternalError(t.getMessage()));
                this.sendResponse(rc, response);
            }
            catch (Throwable throwable) {
                this.sendResponse(rc, response);
                throw throwable;
            }
        }
    }

    @Route(path="/.well-known/agent-card.json", order=1, methods={Route.HttpMethod.GET}, produces={"application/json"})
    @PermitAll
    public void getAgentCard(RoutingContext rc) {
        RestHandler.HTTPRestResponse response = this.jsonRestHandler.getAgentCard();
        this.sendResponse(rc, response);
    }

    @Route(path="/v1/card", order=1, methods={Route.HttpMethod.GET}, produces={"application/json"})
    public void getAuthenticatedExtendedCard(RoutingContext rc) {
        RestHandler.HTTPRestResponse response = this.jsonRestHandler.getAuthenticatedExtendedCard();
        this.sendResponse(rc, response);
    }

    @Route(path="^/v1/.*", order=100, methods={Route.HttpMethod.DELETE, Route.HttpMethod.GET, Route.HttpMethod.HEAD, Route.HttpMethod.OPTIONS, Route.HttpMethod.POST, Route.HttpMethod.PUT}, produces={"application/json"})
    public void methodNotFoundMessage(RoutingContext rc) {
        RestHandler.HTTPRestResponse response = this.jsonRestHandler.createErrorResponse((JSONRPCError)new MethodNotFoundError());
        this.sendResponse(rc, response);
    }

    static void setStreamingMultiSseSupportSubscribedRunnable(Runnable runnable) {
        streamingMultiSseSupportSubscribedRunnable = runnable;
    }

    private ServerCallContext createCallContext(final RoutingContext rc, String jsonRpcMethodName) {
        if (this.callContextFactory.isUnsatisfied()) {
            Object user = rc.user() == null ? UnauthenticatedUser.INSTANCE : new User(){

                public boolean isAuthenticated() {
                    if (rc.userContext() != null) {
                        return rc.userContext().authenticated();
                    }
                    return false;
                }

                public @Nullable String getUsername() {
                    if (rc.user() != null) {
                        return rc.user().subject();
                    }
                    return null;
                }
            };
            HashMap<String, Object> state = new HashMap<String, Object>();
            HashMap headers = new HashMap();
            Set headerNames = rc.request().headers().names();
            headerNames.forEach(name -> headers.put(name, rc.request().getHeader(name)));
            state.put("headers", headers);
            state.put("method", jsonRpcMethodName);
            List extensionHeaderValues = rc.request().headers().getAll("X-A2A-Extensions");
            Set requestedExtensions = A2AExtensions.getRequestedExtensions((List)extensionHeaderValues);
            return new ServerCallContext((User)user, state, requestedExtensions);
        }
        CallContextFactory builder = (CallContextFactory)this.callContextFactory.get();
        return builder.build(rc);
    }

    private static class MultiSseSupport {
        private MultiSseSupport() {
        }

        private static void initialize(HttpServerResponse response) {
            if (response.bytesWritten() == 0L) {
                MultiMap headers = response.headers();
                if (headers.get(HttpHeaders.CONTENT_TYPE) == null) {
                    headers.set(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/event-stream");
                }
                response.setChunked(true);
            }
        }

        private static void onWriteDone( @Nullable Flow.Subscription subscription, AsyncResult<Void> ar, RoutingContext rc) {
            if (ar.failed()) {
                rc.fail(ar.cause());
            } else if (subscription != null) {
                subscription.request(1L);
            }
        }

        private static void write(Multi<Buffer> multi, final RoutingContext rc) {
            final HttpServerResponse response = rc.response();
            multi.subscribe().withSubscriber((Flow.Subscriber)new Flow.Subscriber<Buffer>(){
                 @Nullable Flow.Subscription upstream;

                @Override
                public void onSubscribe(Flow.Subscription subscription) {
                    this.upstream = subscription;
                    this.upstream.request(1L);
                    Runnable runnable = streamingMultiSseSupportSubscribedRunnable;
                    if (runnable != null) {
                        runnable.run();
                    }
                }

                @Override
                public void onNext(Buffer item) {
                    MultiSseSupport.initialize(response);
                    response.write((Object)item, (Handler)new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> ar) {
                            MultiSseSupport.onWriteDone(upstream, ar, rc);
                        }
                    });
                }

                @Override
                public void onError(Throwable throwable) {
                    rc.fail(throwable);
                }

                @Override
                public void onComplete() {
                    MultiSseSupport.endOfStream(response);
                }
            });
        }

        private static void subscribeObject(Multi<Object> multi, RoutingContext rc) {
            final AtomicLong count = new AtomicLong();
            MultiSseSupport.write((Multi<Buffer>)multi.map((Function)new Function<Object, Buffer>(){

                @Override
                public Buffer apply(Object o) {
                    if (o instanceof ReactiveRoutes.ServerSentEvent) {
                        ReactiveRoutes.ServerSentEvent ev = (ReactiveRoutes.ServerSentEvent)o;
                        long id = ev.id() != -1L ? ev.id() : count.getAndIncrement();
                        String e = ev.event() == null ? "" : "event: " + ev.event() + "\n";
                        return Buffer.buffer((String)(e + "data: " + String.valueOf(ev.data()) + "\nid: " + id + "\n\n"));
                    }
                    return Buffer.buffer((String)("data: " + String.valueOf(o) + "\nid: " + count.getAndIncrement() + "\n\n"));
                }
            }), rc);
        }

        private static void endOfStream(HttpServerResponse response) {
            MultiMap headers;
            if (response.bytesWritten() == 0L && (headers = response.headers()).get(HttpHeaders.CONTENT_TYPE) == null) {
                headers.set(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/event-stream");
            }
            response.end();
        }
    }
}

