/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.jsonrpc.common.wrappers;

import io.a2a.jsonrpc.common.wrappers.A2AMessage;
import io.a2a.util.Assert;
import io.a2a.util.Utils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class A2ARequest<T>
implements A2AMessage {
    protected String jsonrpc;
    protected Object id;
    protected String method;
    protected T params;

    @Override
    public String getJsonrpc() {
        return this.jsonrpc;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    public String getMethod() {
        return this.method;
    }

    public T getParams() {
        return this.params;
    }

    protected void validateAndSetJsonParameters(String jsonrpc, String method, Object id, T params, boolean paramsIsRequired) {
        this.jsonrpc = (String)Utils.defaultIfNull((Object)jsonrpc, (Object)"2.0");
        if (!"2.0".equals(this.jsonrpc)) {
            throw new IllegalArgumentException("Invalid JSON-RPC protocol version");
        }
        Assert.checkNotNullParam((String)"method", (Object)method);
        this.method = method;
        Assert.isNullOrStringOrInteger((Object)id);
        this.id = id;
        if (paramsIsRequired) {
            Assert.checkNotNullParam((String)"params", params);
        }
        this.params = params;
    }
}

