/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client.http;

import io.a2a.client.http.A2AHttpClient;
import io.a2a.client.http.A2AHttpClientProvider;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class VertxA2AHttpClientProvider
implements A2AHttpClientProvider {
    private static final boolean VERTX_AVAILABLE = VertxA2AHttpClientProvider.isVertxAvailable();
    private static final Logger log = Logger.getLogger(VertxA2AHttpClientProvider.class.getName());

    private static boolean isVertxAvailable() {
        try {
            Class.forName("io.vertx.core.Vertx");
            Class.forName("io.vertx.ext.web.client.WebClient");
            return true;
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(VertxA2AHttpClientProvider.class.getName()).log(Level.FINE, "Vert.x classes are not available on the classpath. Falling back to other providers.", ex);
            return false;
        }
    }

    public A2AHttpClient create() {
        if (!VERTX_AVAILABLE) {
            throw new IllegalStateException("Vert.x classes are not available on the classpath. Add io.vertx:vertx-web-client dependency or use the JDK HTTP client implementation.");
        }
        try {
            Class<?> clientClass = Class.forName("io.a2a.client.http.VertxA2AHttpClient");
            return (A2AHttpClient)clientClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create VertxA2AHttpClient instance", e);
        }
    }

    public int priority() {
        return VERTX_AVAILABLE ? 100 : -1;
    }

    public String name() {
        return "vertx";
    }
}

