/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.examples.helloworld;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.a2a.A2A;
import io.a2a.client.Client;
import io.a2a.client.ClientEvent;
import io.a2a.client.MessageEvent;
import io.a2a.client.http.A2ACardResolver;
import io.a2a.client.transport.jsonrpc.JSONRPCTransport;
import io.a2a.client.transport.jsonrpc.JSONRPCTransportConfig;
import io.a2a.client.transport.spi.ClientTransportConfig;
import io.a2a.spec.AgentCard;
import io.a2a.spec.Message;
import io.a2a.spec.Part;
import io.a2a.spec.TextPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class HelloWorldClient {
    private static final String SERVER_URL = "http://localhost:9999";
    private static final String MESSAGE_TEXT = "how much is 10 USD in INR?";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) {
        try {
            AgentCard finalAgentCard = null;
            AgentCard publicAgentCard = new A2ACardResolver(SERVER_URL).getAgentCard();
            System.out.println("Successfully fetched public agent card:");
            System.out.println(OBJECT_MAPPER.writeValueAsString((Object)publicAgentCard));
            System.out.println("Using public agent card for client initialization (default).");
            finalAgentCard = publicAgentCard;
            if (publicAgentCard.supportsAuthenticatedExtendedCard()) {
                System.out.println("Public card supports authenticated extended card. Attempting to fetch from: http://localhost:9999/agent/authenticatedExtendedCard");
                HashMap<String, String> authHeaders = new HashMap<String, String>();
                authHeaders.put("Authorization", "Bearer dummy-token-for-extended-card");
                AgentCard extendedAgentCard = A2A.getAgentCard((String)SERVER_URL, (String)"/agent/authenticatedExtendedCard", authHeaders);
                System.out.println("Successfully fetched authenticated extended agent card:");
                System.out.println(OBJECT_MAPPER.writeValueAsString((Object)extendedAgentCard));
                System.out.println("Using AUTHENTICATED EXTENDED agent card for client initialization.");
                finalAgentCard = extendedAgentCard;
            } else {
                System.out.println("Public card does not indicate support for an extended card. Using public card.");
            }
            CompletableFuture messageResponse = new CompletableFuture();
            ArrayList<BiConsumer<ClientEvent, AgentCard>> consumers = new ArrayList<BiConsumer<ClientEvent, AgentCard>>();
            consumers.add((event, agentCard) -> {
                if (event instanceof MessageEvent) {
                    MessageEvent messageEvent = (MessageEvent)event;
                    Message responseMessage = messageEvent.getMessage();
                    StringBuilder textBuilder = new StringBuilder();
                    if (responseMessage.getParts() != null) {
                        for (Part part : responseMessage.getParts()) {
                            if (!(part instanceof TextPart)) continue;
                            TextPart textPart = (TextPart)part;
                            textBuilder.append(textPart.getText());
                        }
                    }
                    messageResponse.complete(textBuilder.toString());
                } else {
                    System.out.println("Received client event: " + event.getClass().getSimpleName());
                }
            });
            Consumer<Throwable> streamingErrorHandler = error -> {
                System.err.println("Streaming error occurred: " + error.getMessage());
                error.printStackTrace();
                messageResponse.completeExceptionally((Throwable)error);
            };
            Client client = Client.builder((AgentCard)finalAgentCard).addConsumers(consumers).streamingErrorHandler(streamingErrorHandler).withTransport(JSONRPCTransport.class, (ClientTransportConfig)new JSONRPCTransportConfig()).build();
            Message message = A2A.toUserMessage((String)MESSAGE_TEXT);
            System.out.println("Sending message: how much is 10 USD in INR?");
            client.sendMessage(message);
            System.out.println("Message sent successfully. Responses will be handled by the configured consumers.");
            try {
                String responseText = (String)messageResponse.get();
                System.out.println("Response: " + responseText);
            }
            catch (Exception e) {
                System.err.println("Failed to get response: " + e.getMessage());
            }
        }
        catch (Exception e) {
            System.err.println("An error occurred: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

