/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.extras.taskstore.database.jpa;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.a2a.extras.common.events.TaskFinalizedEvent;
import io.a2a.extras.taskstore.database.jpa.JpaTask;
import io.a2a.server.tasks.TaskStateProvider;
import io.a2a.server.tasks.TaskStore;
import io.a2a.spec.Task;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Alternative;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.transaction.Transactional;
import java.time.Duration;
import java.time.Instant;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Alternative
@Priority(value=50)
public class JpaDatabaseTaskStore
implements TaskStore,
TaskStateProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaDatabaseTaskStore.class);
    @PersistenceContext(unitName="a2a-java")
    EntityManager em;
    @Inject
    Event<TaskFinalizedEvent> taskFinalizedEvent;
    @ConfigProperty(name="a2a.replication.grace-period-seconds", defaultValue="15")
    long gracePeriodSeconds;

    @Transactional
    public void save(Task task) {
        LOGGER.debug("Saving task with ID: {}", (Object)task.getId());
        try {
            JpaTask jpaTask = JpaTask.createFromTask(task);
            this.em.merge((Object)jpaTask);
            LOGGER.debug("Persisted/updated task with ID: {}", (Object)task.getId());
            if (task.getStatus() != null && task.getStatus().state() != null && task.getStatus().state().isFinal()) {
                LOGGER.debug("Task {} is in final state, firing TaskFinalizedEvent", (Object)task.getId());
                this.taskFinalizedEvent.fire((Object)new TaskFinalizedEvent(task.getId()));
            }
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to serialize task with ID: {}", (Object)task.getId(), (Object)e);
            throw new RuntimeException("Failed to serialize task with ID: " + task.getId(), e);
        }
    }

    @Transactional
    public Task get(String taskId) {
        LOGGER.debug("Retrieving task with ID: {}", (Object)taskId);
        JpaTask jpaTask = (JpaTask)this.em.find(JpaTask.class, (Object)taskId);
        if (jpaTask == null) {
            LOGGER.debug("Task not found with ID: {}", (Object)taskId);
            return null;
        }
        try {
            Task task = jpaTask.getTask();
            LOGGER.debug("Successfully retrieved task with ID: {}", (Object)taskId);
            return task;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to deserialize task with ID: {}", (Object)taskId, (Object)e);
            throw new RuntimeException("Failed to deserialize task with ID: " + taskId, e);
        }
    }

    @Transactional
    public void delete(String taskId) {
        LOGGER.debug("Deleting task with ID: {}", (Object)taskId);
        JpaTask jpaTask = (JpaTask)this.em.find(JpaTask.class, (Object)taskId);
        if (jpaTask != null) {
            this.em.remove((Object)jpaTask);
            LOGGER.debug("Successfully deleted task with ID: {}", (Object)taskId);
        } else {
            LOGGER.debug("Task not found for deletion with ID: {}", (Object)taskId);
        }
    }

    @Transactional
    public boolean isTaskActive(String taskId) {
        LOGGER.debug("Checking if task is active: {}", (Object)taskId);
        JpaTask jpaTask = (JpaTask)this.em.find(JpaTask.class, (Object)taskId);
        if (jpaTask == null) {
            LOGGER.debug("Task not found, considering inactive: {}", (Object)taskId);
            return false;
        }
        try {
            Task task = jpaTask.getTask();
            if (task.getStatus() == null || task.getStatus().state() == null || !task.getStatus().state().isFinal()) {
                LOGGER.debug("Task is not in final state, considering active: {}", (Object)taskId);
                return true;
            }
            Instant finalizedAt = jpaTask.getFinalizedAt();
            if (finalizedAt == null) {
                LOGGER.warn("Task {} is in final state but has no finalizedAt timestamp, considering inactive", (Object)taskId);
                return false;
            }
            Instant gracePeriodEnd = finalizedAt.plus(Duration.ofSeconds(this.gracePeriodSeconds));
            Instant now = Instant.now();
            boolean withinGracePeriod = now.isBefore(gracePeriodEnd);
            LOGGER.debug("Task {} is final. FinalizedAt: {}, GracePeriodEnd: {}, Now: {}, Active: {}", new Object[]{taskId, finalizedAt, gracePeriodEnd, now, withinGracePeriod});
            return withinGracePeriod;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to deserialize task with ID: {}, considering inactive", (Object)taskId, (Object)e);
            return false;
        }
    }

    @Transactional
    public boolean isTaskFinalized(String taskId) {
        LOGGER.debug("Checking if task is finalized: {}", (Object)taskId);
        JpaTask jpaTask = (JpaTask)this.em.find(JpaTask.class, (Object)taskId);
        if (jpaTask == null) {
            LOGGER.debug("Task not found, considering not finalized: {}", (Object)taskId);
            return false;
        }
        try {
            Task task = jpaTask.getTask();
            boolean isFinalized = task.getStatus() != null && task.getStatus().state() != null && task.getStatus().state().isFinal();
            LOGGER.debug("Task {} finalization check: {}", (Object)taskId, (Object)isFinalized);
            return isFinalized;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to deserialize task with ID: {}, considering not finalized", (Object)taskId, (Object)e);
            return false;
        }
    }
}

