/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.extras.taskstore.database.jpa;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.a2a.extras.taskstore.database.jpa.JpaTask;
import io.a2a.server.tasks.TaskStore;
import io.a2a.spec.Task;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Alternative;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Alternative
@Priority(value=50)
public class JpaDatabaseTaskStore
implements TaskStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaDatabaseTaskStore.class);
    @PersistenceContext(unitName="a2a-java")
    EntityManager em;

    @Transactional
    public void save(Task task) {
        LOGGER.debug("Saving task with ID: {}", (Object)task.getId());
        try {
            JpaTask jpaTask = JpaTask.createFromTask(task);
            this.em.merge((Object)jpaTask);
            LOGGER.debug("Persisted/updated task with ID: {}", (Object)task.getId());
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to serialize task with ID: {}", (Object)task.getId(), (Object)e);
            throw new RuntimeException("Failed to serialize task with ID: " + task.getId(), e);
        }
    }

    @Transactional
    public Task get(String taskId) {
        LOGGER.debug("Retrieving task with ID: {}", (Object)taskId);
        JpaTask jpaTask = (JpaTask)this.em.find(JpaTask.class, (Object)taskId);
        if (jpaTask == null) {
            LOGGER.debug("Task not found with ID: {}", (Object)taskId);
            return null;
        }
        try {
            Task task = jpaTask.getTask();
            LOGGER.debug("Successfully retrieved task with ID: {}", (Object)taskId);
            return task;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to deserialize task with ID: {}", (Object)taskId, (Object)e);
            throw new RuntimeException("Failed to deserialize task with ID: " + taskId, e);
        }
    }

    @Transactional
    public void delete(String taskId) {
        LOGGER.debug("Deleting task with ID: {}", (Object)taskId);
        JpaTask jpaTask = (JpaTask)this.em.find(JpaTask.class, (Object)taskId);
        if (jpaTask != null) {
            this.em.remove((Object)jpaTask);
            LOGGER.debug("Successfully deleted task with ID: {}", (Object)taskId);
        } else {
            LOGGER.debug("Task not found for deletion with ID: {}", (Object)taskId);
        }
    }
}

