/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.extras.pushnotificationconfigstore.database.jpa;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import io.a2a.extras.pushnotificationconfigstore.database.jpa.TaskConfigId;
import io.a2a.spec.PushNotificationConfig;
import io.a2a.util.Utils;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;

@Entity
@Table(name="a2a_push_notification_configs")
public class JpaPushNotificationConfig {
    @EmbeddedId
    private TaskConfigId id;
    @Column(name="task_data", columnDefinition="TEXT", nullable=false)
    private String configJson;
    @Transient
    private PushNotificationConfig config;

    public JpaPushNotificationConfig() {
    }

    public JpaPushNotificationConfig(TaskConfigId id, String configJson) {
        this.id = id;
        this.configJson = configJson;
    }

    public TaskConfigId getId() {
        return this.id;
    }

    public void setId(TaskConfigId id) {
        this.id = id;
    }

    public void setConfigJson(String configJson) {
        this.configJson = configJson;
    }

    public PushNotificationConfig getConfig() throws JsonProcessingException {
        if (this.config == null) {
            this.config = (PushNotificationConfig)Utils.unmarshalFrom((String)this.configJson, (TypeReference)PushNotificationConfig.TYPE_REFERENCE);
        }
        return this.config;
    }

    public void setConfig(PushNotificationConfig config) throws JsonProcessingException {
        if (config.id() == null || !config.id().equals(this.id.getConfigId())) {
            throw new IllegalArgumentException("Mismatched config id. Expected '" + this.id.getConfigId() + "'. Got: '" + config.id() + "'");
        }
        this.configJson = Utils.OBJECT_MAPPER.writeValueAsString((Object)config);
        this.config = config;
    }

    static JpaPushNotificationConfig createFromConfig(String taskId, PushNotificationConfig config) throws JsonProcessingException {
        String json = Utils.OBJECT_MAPPER.writeValueAsString((Object)config);
        JpaPushNotificationConfig jpaPushNotificationConfig = new JpaPushNotificationConfig(new TaskConfigId(taskId, config.id()), json);
        jpaPushNotificationConfig.config = config;
        return jpaPushNotificationConfig;
    }
}

