/*
 * Decompiled with CFR 0.152.
 */
package com.a_lab.textarc;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.core.content.res.ResourcesCompat;
import com.a_lab.textarc.R;

public class TextArc
extends View {
    private int radius = 320;
    private int centerAngle = -90;
    private float textSize;
    private String text;
    private int textColor;
    private Typeface fontFamily;
    private Path pathArc;
    private Paint paintText;
    private float offset;

    public TextArc(Context context) {
        super(context);
        this.textSize = this.getResources().getDisplayMetrics().density * 16.0f;
        this.text = "Hello world";
        this.textColor = -1;
        this.pathArc = new Path();
        this.paintText = new Paint(1);
        this.offset = 0.0f;
    }

    public TextArc(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        int fontRes;
        int colorRes;
        this.textSize = this.getResources().getDisplayMetrics().density * 16.0f;
        this.text = "Hello world";
        this.textColor = -1;
        this.pathArc = new Path();
        this.paintText = new Paint(1);
        this.offset = 0.0f;
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.TextArc);
        this.radius = typedArray.getDimensionPixelSize(R.styleable.TextArc_radius, this.radius);
        this.centerAngle = typedArray.getInteger(R.styleable.TextArc_center_angle, this.centerAngle);
        this.textSize = typedArray.getDimensionPixelSize(R.styleable.TextArc_text_size, (int)this.textSize);
        String text = typedArray.getString(R.styleable.TextArc_text);
        if (text != null) {
            this.text = text;
        }
        if ((colorRes = typedArray.getColor(R.styleable.TextArc_text_color, -1)) != -1) {
            this.textColor = colorRes;
        }
        if ((fontRes = typedArray.getResourceId(R.styleable.TextArc_font_family, -1)) != -1) {
            this.fontFamily = ResourcesCompat.getFont((Context)context, (int)fontRes);
        }
        typedArray.recycle();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.offset = this.textSize * 0.75f;
        ViewGroup.LayoutParams lp = this.getLayoutParams();
        lp.width = this.radius > 0 ? (int)((float)(this.radius * 2) + this.offset * 2.0f) : 0;
        lp.height = this.radius > 0 ? (int)((float)(this.radius * 2) + this.offset * 2.0f) : 0;
        this.requestLayout();
        this.paintText.setColor(this.textColor);
        this.paintText.setTypeface(this.fontFamily);
        this.paintText.setTextSize(this.textSize);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        float textWidth = this.paintText.measureText(this.text);
        int circumference = (int)(Math.PI * 2 * (double)this.radius);
        int textAngle = (int)(textWidth * 360.0f / (float)circumference);
        int startAngle = this.centerAngle - textAngle / 2;
        RectF oval = new RectF(this.offset, this.offset, (float)(this.radius * 2) + this.offset, (float)(this.radius * 2) + this.offset);
        this.pathArc.addArc(oval, (float)startAngle, 350.0f);
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawTextOnPath(this.text, this.pathArc, 0.0f, 0.0f, this.paintText);
    }

    public void setText(String text) {
        this.text = text;
        this.invalidate();
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.invalidate();
    }

    public void setCenterAngle(int centerAngle) {
        this.centerAngle = centerAngle;
        this.invalidate();
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.invalidate();
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
        this.invalidate();
    }

    public void setFontFamily(Typeface fontFamily) {
        this.fontFamily = fontFamily;
        this.invalidate();
    }
}

