/*
 * Decompiled with CFR 0.152.
 */
package org.tron.trident.crypto.tuwenitypes;

import java.math.BigInteger;
import org.tron.trident.crypto.tuwenitypes.Bytes;
import org.tron.trident.crypto.tuwenitypes.Bytes32;
import org.tron.trident.crypto.tuwenitypes.UInt256;

public interface UInt256Value<T extends UInt256Value<T>>
extends Comparable<T> {
    default public boolean isZero() {
        return this.toBytes().isZero();
    }

    public T add(T var1);

    default public T plus(T value) {
        return this.add(value);
    }

    default public T plus(long value) {
        return this.add(value);
    }

    default public T addExact(T value) {
        T result = this.add(value);
        if (this.compareTo(result) > 0) {
            throw new ArithmeticException("UInt256 overflow");
        }
        return result;
    }

    public T add(long var1);

    default public T addExact(long value) {
        T result = this.add(value);
        if (value > 0L && this.compareTo(result) > 0 || value < 0L && this.compareTo(result) < 0) {
            throw new ArithmeticException("UInt256 overflow");
        }
        return result;
    }

    public T addMod(T var1, UInt256 var2);

    public T addMod(long var1, UInt256 var3);

    public T addMod(long var1, long var3);

    public T subtract(T var1);

    default public T subtractExact(T value) {
        T result = this.subtract(value);
        if (this.compareTo(result) < 0) {
            throw new ArithmeticException("UInt256 overflow");
        }
        return result;
    }

    public T subtract(long var1);

    default public T subtractExact(long value) {
        T result = this.subtract(value);
        if (value > 0L && this.compareTo(result) < 0 || value < 0L && this.compareTo(result) > 0) {
            throw new ArithmeticException("UInt256 overflow");
        }
        return result;
    }

    public T multiply(T var1);

    public T multiply(long var1);

    public T multiplyMod(T var1, UInt256 var2);

    public T multiplyMod(long var1, UInt256 var3);

    public T multiplyMod(long var1, long var3);

    public T divide(T var1);

    public T divide(long var1);

    public T divideCeil(T var1);

    public T divideCeil(long var1);

    public T pow(UInt256 var1);

    public T pow(long var1);

    public T mod(UInt256 var1);

    public T mod(long var1);

    public T mod0(UInt256 var1);

    public T mod0(long var1);

    default public boolean fitsInt() {
        Bytes32 bytes = this.toBytes();
        for (int i = 0; i < 28; ++i) {
            if (bytes.get(i) == 0) continue;
            return false;
        }
        return bytes.get(28) >= 0;
    }

    default public int intValue() {
        if (!this.fitsInt()) {
            throw new ArithmeticException("Value does not fit a 4 byte int");
        }
        return this.toBytes().getInt(28);
    }

    default public boolean fitsLong() {
        for (int i = 0; i < 24; ++i) {
            if (this.toBytes().get(i) == 0) continue;
            return false;
        }
        return this.toBytes().get(24) >= 0;
    }

    default public long toLong() {
        if (!this.fitsLong()) {
            throw new ArithmeticException("Value does not fit a 8 byte long");
        }
        return this.toBytes().getLong(24);
    }

    default public BigInteger toBigInteger() {
        return this.toBytes().toUnsignedBigInteger();
    }

    default public String toHexString() {
        return this.toBytes().toHexString();
    }

    default public String toShortHexString() {
        return this.toBytes().toShortHexString();
    }

    public UInt256 toUInt256();

    public Bytes32 toBytes();

    public Bytes toMinimalBytes();

    default public int numberOfLeadingZeros() {
        return this.toBytes().numberOfLeadingZeros();
    }

    default public int bitLength() {
        return this.toBytes().bitLength();
    }
}

