/*
 * Decompiled with CFR 0.152.
 */
package org.tron.trident.crypto.tuwenitypes;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.tron.trident.crypto.tuwenitypes.ArrayWrappingBytes;
import org.tron.trident.crypto.tuwenitypes.ByteBufferWrappingBytes;
import org.tron.trident.crypto.tuwenitypes.Bytes;
import org.tron.trident.crypto.tuwenitypes.MutableBytes;

public class MutableByteBufferWrappingBytes
extends ByteBufferWrappingBytes
implements MutableBytes {
    MutableByteBufferWrappingBytes(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    MutableByteBufferWrappingBytes(ByteBuffer byteBuffer, int offset, int length) {
        super(byteBuffer, offset, length);
    }

    @Override
    public void setInt(int i, int value) {
        this.byteBuffer.putInt(this.offset + i, value);
    }

    @Override
    public void setLong(int i, long value) {
        this.byteBuffer.putLong(this.offset + i, value);
    }

    @Override
    public void set(int i, byte b) {
        this.byteBuffer.put(this.offset + i, b);
    }

    @Override
    public MutableBytes mutableSlice(int i, int length) {
        if (i == 0 && length == this.length) {
            return this;
        }
        if (length == 0) {
            return MutableBytes.EMPTY;
        }
        Preconditions.checkElementIndex((int)i, (int)this.length);
        Preconditions.checkArgument((i + length <= this.length ? 1 : 0) != 0, (String)"Provided length %s is too big: the value has size %s and has only %s bytes from %s", (Object)length, (Object)this.length, (Object)(this.length - i), (Object)i);
        return new MutableByteBufferWrappingBytes(this.byteBuffer, this.offset + i, length);
    }

    @Override
    public Bytes copy() {
        return new ArrayWrappingBytes(this.toArray());
    }
}

