/*
 * Decompiled with CFR 0.152.
 */
package org.tron.trident.core.utils;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class ByteArray {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static String toHexString(byte[] data) {
        return data == null ? "" : Hex.toHexString((byte[])data);
    }

    public static byte[] fromHexString(String data) {
        if (data == null) {
            return EMPTY_BYTE_ARRAY;
        }
        if (data.startsWith("0x")) {
            data = data.substring(2);
        }
        if (data.length() % 2 != 0) {
            data = "0" + data;
        }
        return Hex.decode((String)data);
    }

    public static byte[] fromLong(long val) {
        return Longs.toByteArray((long)val);
    }

    public static byte[] fromInt(int val) {
        return Ints.toByteArray((int)val);
    }

    public static String toJsonHex(byte[] x) {
        return x == null || x.length == 0 ? "0x" : "0x" + Hex.toHexString((byte[])x);
    }

    public static String toJsonHex(Long x) {
        return x == null ? null : "0x" + Long.toHexString(x);
    }

    public static BigInteger hexToBigInteger(String input) {
        if (input.startsWith("0x")) {
            return new BigInteger(input.substring(2), 16);
        }
        return new BigInteger(input, 10);
    }

    public static int jsonHexToInt(String x) throws Exception {
        if (!x.startsWith("0x")) {
            throw new Exception("Incorrect hex syntax");
        }
        x = x.substring(2);
        return Integer.parseInt(x, 16);
    }

    public static byte[] subArray(byte[] input, int start, int end) {
        byte[] result = new byte[end - start];
        System.arraycopy(input, start, result, 0, end - start);
        return result;
    }

    public static boolean isEmpty(byte[] input) {
        return input == null || input.length == 0;
    }

    public static boolean matrixContains(List<byte[]> source, byte[] obj) {
        for (byte[] sobj : source) {
            if (!Arrays.equals(sobj, obj)) continue;
            return true;
        }
        return false;
    }

    public static String fromHex(String x) {
        if (x.startsWith("0x")) {
            x = x.substring(2);
        }
        if (x.length() % 2 != 0) {
            x = "0" + x;
        }
        return x;
    }

    public static boolean isHexString(String str) {
        boolean bRet = false;
        try {
            ByteArray.fromHexString(str);
            bRet = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bRet;
    }
}

