/*
 * Decompiled with CFR 0.152.
 */
package org.tron.trident.core.contract;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import org.tron.trident.core.contract.Contract;
import org.tron.trident.proto.Common;

public class ContractFunction {
    private String name;
    private Common.SmartContract.ABI.Entry abi;
    private Contract cntr;
    private ByteString ownerAddr;
    private List<String> inputParams = new ArrayList<String>();
    private List<String> inputTypes = new ArrayList<String>();
    private String output = "";
    private String outputType;
    private long callValue = 0L;
    private long callTokenValue = 0L;
    private int callTokenId = 0;
    private String stateMutability;

    public ContractFunction(Builder builder) {
        this.name = builder.name;
        this.abi = builder.abi;
        this.cntr = builder.cntr;
        this.ownerAddr = builder.ownerAddr;
        this.inputParams = builder.inputParams;
        this.inputTypes = builder.inputTypes;
        this.output = builder.output;
        this.outputType = builder.outputType;
        this.callValue = builder.callValue;
        this.callTokenValue = builder.callTokenValue;
        this.callTokenId = builder.callTokenId;
        this.stateMutability = builder.stateMutability;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Common.SmartContract.ABI.Entry getAbi() {
        return this.abi;
    }

    public void setAbi(Common.SmartContract.ABI.Entry abi) {
        this.abi = abi;
    }

    public Contract getCntr() {
        return this.cntr;
    }

    public void setCntr(Contract cntr) {
        this.cntr = cntr;
    }

    public ByteString getOwnerAddr() {
        return this.ownerAddr;
    }

    public void setOwnerAddr(ByteString ownerAddr) {
        this.ownerAddr = ownerAddr;
    }

    public List<String> getInputParams() {
        return this.inputParams;
    }

    public void setInputParams(List<String> inputParams) {
        this.inputParams = inputParams;
    }

    public List<String> getInputTypes() {
        return this.inputTypes;
    }

    public void setInputTypes(List<String> inputTypes) {
        this.inputTypes = inputTypes;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String outputs) {
        this.output = this.output;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public long getCallValue() {
        return this.callValue;
    }

    public void setCallValue(long callValue) {
        this.callValue = callValue;
    }

    public long getCallTokenValue() {
        return this.callTokenValue;
    }

    public void setCallTokenValue(long callTokenValue) {
        this.callTokenValue = callTokenValue;
    }

    public int getCallTokenId() {
        return this.callTokenId;
    }

    public void setCallTokenId(int callTokenId) {
        this.callTokenId = callTokenId;
    }

    public String getStateMutability() {
        return this.stateMutability;
    }

    public void setStateMutability(String stateMutability) {
        this.stateMutability = stateMutability;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("# function ");
        ret.append(this.name);
        ret.append("(");
        if (this.inputParams.size() != 0) {
            for (int i = 0; i < this.inputParams.size(); ++i) {
                ret.append(this.inputParams.get(i) + " " + this.inputTypes.get(i) + ", ");
            }
            ret.delete(ret.length() - 2, ret.length() - 1);
        }
        ret.append(")");
        ret.append(" " + this.stateMutability);
        ret.append(" returns (");
        ret.append(this.outputType);
        ret.append(" " + this.output);
        ret.append(")");
        return ret.toString();
    }

    public static class Builder {
        private String name;
        private Common.SmartContract.ABI.Entry abi;
        private Contract cntr;
        private ByteString ownerAddr;
        private List<String> inputParams = new ArrayList<String>();
        private List<String> inputTypes = new ArrayList<String>();
        private String output = "";
        private String outputType;
        private long callValue = 0L;
        private long callTokenValue = 0L;
        private int callTokenId = 0;
        private String stateMutability;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setAbi(Common.SmartContract.ABI.Entry abi) {
            this.abi = abi;
            return this;
        }

        public Builder setCntr(Contract cntr) {
            this.cntr = cntr;
            return this;
        }

        public Builder setOwnerAddr(ByteString ownerAddr) {
            this.ownerAddr = ownerAddr;
            return this;
        }

        public Builder setInputParams(List<String> inputParams) {
            this.inputParams = inputParams;
            return this;
        }

        public Builder setInputTypes(List<String> inputTypes) {
            this.inputTypes = inputTypes;
            return this;
        }

        public Builder setOutput(String output) {
            this.output = output;
            return this;
        }

        public Builder setOutputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        public Builder setCallValue(long callValue) {
            this.callValue = callValue;
            return this;
        }

        public Builder setCallTokenValue(long callTokenValue) {
            this.callTokenValue = callTokenValue;
            return this;
        }

        public Builder setCallTokenId(int callTokenId) {
            this.callTokenId = callTokenId;
            return this;
        }

        public Builder setStateMutability(String stateMutability) {
            this.stateMutability = stateMutability;
            return this;
        }

        public ContractFunction build() {
            return new ContractFunction(this);
        }
    }
}

