/*
 * Decompiled with CFR 0.152.
 */
package org.tron.trident.core;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.stub.MetadataUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.jcajce.provider.digest.SHA256;
import org.tron.trident.abi.FunctionEncoder;
import org.tron.trident.abi.datatypes.Function;
import org.tron.trident.abi.datatypes.Type;
import org.tron.trident.api.GrpcAPI;
import org.tron.trident.api.WalletGrpc;
import org.tron.trident.api.WalletSolidityGrpc;
import org.tron.trident.core.Api;
import org.tron.trident.core.contract.Contract;
import org.tron.trident.core.contract.ContractFunction;
import org.tron.trident.core.exceptions.IllegalException;
import org.tron.trident.core.key.KeyPair;
import org.tron.trident.core.transaction.TransactionBuilder;
import org.tron.trident.core.transaction.TransactionCapsule;
import org.tron.trident.core.utils.ByteArray;
import org.tron.trident.core.utils.Sha256Hash;
import org.tron.trident.core.utils.Utils;
import org.tron.trident.proto.Chain;
import org.tron.trident.proto.Common;
import org.tron.trident.proto.Contract;
import org.tron.trident.proto.Response;
import org.tron.trident.utils.Base58Check;
import org.tron.trident.utils.Numeric;

public class ApiWrapper
implements Api {
    public static final long TRANSACTION_DEFAULT_EXPIRATION_TIME = 60000L;
    public static final long GRPC_TIMEOUT = 30000L;
    public static final long FEE_LIMIT = 150000000L;
    public static final long CONSUME_USER_RESOURCE_PERCENT = 100L;
    public static final long ORIGIN_ENERGY_LIMIT = 100000000L;
    public final WalletGrpc.WalletBlockingStub blockingStub;
    public final WalletSolidityGrpc.WalletSolidityBlockingStub blockingStubSolidity;
    public final KeyPair keyPair;
    private final ManagedChannel channel;
    private final ManagedChannel channelSolidity;

    public ApiWrapper(String grpcEndpoint, String grpcEndpointSolidity, String hexPrivateKey) {
        this.channel = ManagedChannelBuilder.forTarget((String)grpcEndpoint).usePlaintext().build();
        this.channelSolidity = ManagedChannelBuilder.forTarget((String)grpcEndpointSolidity).usePlaintext().build();
        this.blockingStub = (WalletGrpc.WalletBlockingStub)WalletGrpc.newBlockingStub((Channel)this.channel).withDeadlineAfter(30000L, TimeUnit.MILLISECONDS);
        this.blockingStubSolidity = (WalletSolidityGrpc.WalletSolidityBlockingStub)WalletSolidityGrpc.newBlockingStub((Channel)this.channelSolidity).withDeadlineAfter(30000L, TimeUnit.MILLISECONDS);
        this.keyPair = new KeyPair(hexPrivateKey);
    }

    public ApiWrapper(String grpcEndpoint, String grpcEndpointSolidity, String hexPrivateKey, String apiKey) {
        this.channel = ManagedChannelBuilder.forTarget((String)grpcEndpoint).usePlaintext().build();
        this.channelSolidity = ManagedChannelBuilder.forTarget((String)grpcEndpointSolidity).usePlaintext().build();
        Metadata header = new Metadata();
        Metadata.Key key = Metadata.Key.of((String)"TRON-PRO-API-KEY", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        header.put(key, (Object)apiKey);
        this.blockingStub = (WalletGrpc.WalletBlockingStub)((WalletGrpc.WalletBlockingStub)WalletGrpc.newBlockingStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)header)})).withDeadlineAfter(30000L, TimeUnit.MILLISECONDS);
        this.blockingStubSolidity = (WalletSolidityGrpc.WalletSolidityBlockingStub)((WalletSolidityGrpc.WalletSolidityBlockingStub)WalletSolidityGrpc.newBlockingStub((Channel)this.channelSolidity).withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)header)})).withDeadlineAfter(30000L, TimeUnit.MILLISECONDS);
        this.keyPair = new KeyPair(hexPrivateKey);
    }

    public ApiWrapper(String grpcEndpoint, String grpcEndpointSolidity, String hexPrivateKey, List<ClientInterceptor> clientInterceptors) {
        this.channel = ManagedChannelBuilder.forTarget((String)grpcEndpoint).intercept(clientInterceptors).usePlaintext().build();
        this.channelSolidity = ManagedChannelBuilder.forTarget((String)grpcEndpointSolidity).usePlaintext().build();
        this.blockingStub = (WalletGrpc.WalletBlockingStub)WalletGrpc.newBlockingStub((Channel)this.channel).withDeadlineAfter(30000L, TimeUnit.MILLISECONDS);
        this.blockingStubSolidity = (WalletSolidityGrpc.WalletSolidityBlockingStub)WalletSolidityGrpc.newBlockingStub((Channel)this.channelSolidity).withDeadlineAfter(30000L, TimeUnit.MILLISECONDS);
        this.keyPair = new KeyPair(hexPrivateKey);
    }

    public ApiWrapper(String grpcEndpoint, String grpcEndpointSolidity, String hexPrivateKey, int timeout) {
        this.channel = ManagedChannelBuilder.forTarget((String)grpcEndpoint).usePlaintext().build();
        this.channelSolidity = ManagedChannelBuilder.forTarget((String)grpcEndpointSolidity).usePlaintext().build();
        this.blockingStub = (WalletGrpc.WalletBlockingStub)WalletGrpc.newBlockingStub((Channel)this.channel).withDeadlineAfter(timeout, TimeUnit.MILLISECONDS);
        this.blockingStubSolidity = (WalletSolidityGrpc.WalletSolidityBlockingStub)WalletSolidityGrpc.newBlockingStub((Channel)this.channelSolidity).withDeadlineAfter(timeout, TimeUnit.MILLISECONDS);
        this.keyPair = new KeyPair(hexPrivateKey);
    }

    public ApiWrapper(String grpcEndpoint, String grpcEndpointSolidity, String hexPrivateKey, List<ClientInterceptor> clientInterceptors, int timeout) {
        this.channel = ManagedChannelBuilder.forTarget((String)grpcEndpoint).intercept(clientInterceptors).usePlaintext().build();
        this.channelSolidity = ManagedChannelBuilder.forTarget((String)grpcEndpointSolidity).usePlaintext().build();
        this.blockingStub = (WalletGrpc.WalletBlockingStub)WalletGrpc.newBlockingStub((Channel)this.channel).withDeadlineAfter(timeout, TimeUnit.MILLISECONDS);
        this.blockingStubSolidity = (WalletSolidityGrpc.WalletSolidityBlockingStub)WalletSolidityGrpc.newBlockingStub((Channel)this.channelSolidity).withDeadlineAfter(timeout, TimeUnit.MILLISECONDS);
        this.keyPair = new KeyPair(hexPrivateKey);
    }

    public void close() {
        this.channel.shutdown();
        this.channelSolidity.shutdown();
    }

    public static ApiWrapper ofMainnet(String hexPrivateKey, String apiKey) {
        return new ApiWrapper("grpc.trongrid.io:50051", "grpc.trongrid.io:50052", hexPrivateKey, apiKey);
    }

    @Deprecated
    public static ApiWrapper ofMainnet(String hexPrivateKey) {
        return new ApiWrapper("grpc.trongrid.io:50051", "grpc.trongrid.io:50052", hexPrivateKey);
    }

    public static ApiWrapper ofShasta(String hexPrivateKey) {
        return new ApiWrapper("grpc.shasta.trongrid.io:50051", "grpc.shasta.trongrid.io:50052", hexPrivateKey);
    }

    public static ApiWrapper ofNile(String hexPrivateKey) {
        return new ApiWrapper("grpc.nile.trongrid.io:50051", "grpc.nile.trongrid.io:50061", hexPrivateKey);
    }

    public static KeyPair generateAddress() {
        return KeyPair.generate();
    }

    public static ByteString parseAddress(String address) {
        byte[] raw2 = address.startsWith("T") ? Base58Check.base58ToBytes(address) : ByteArray.fromHexString(address);
        return ByteString.copyFrom((byte[])raw2);
    }

    public static byte[] calculateTransactionHash(Chain.Transaction txn) {
        SHA256.Digest digest = new SHA256.Digest();
        digest.update(txn.getRawData().toByteArray());
        return digest.digest();
    }

    public static ByteString parseHex(String hexString) {
        return ByteString.copyFrom((byte[])ByteArray.fromHexString(hexString));
    }

    public static String toHex(byte[] raw2) {
        return ByteArray.toHexString(raw2);
    }

    public static String toHex(ByteString raw2) {
        return ApiWrapper.toHex(raw2.toByteArray());
    }

    @Override
    public Chain.Transaction signTransaction(Response.TransactionExtention txnExt, KeyPair keyPair) {
        byte[] txId = txnExt.getTxid().toByteArray();
        byte[] signature = KeyPair.signTransaction(txId, keyPair);
        return txnExt.getTransaction().toBuilder().addSignature(ByteString.copyFrom((byte[])signature)).build();
    }

    @Override
    public Chain.Transaction signTransaction(Chain.Transaction txn, KeyPair keyPair) {
        byte[] txId = ApiWrapper.calculateTransactionHash(txn);
        byte[] signature = KeyPair.signTransaction(txId, keyPair);
        return txn.toBuilder().addSignature(ByteString.copyFrom((byte[])signature)).build();
    }

    @Override
    public Chain.Transaction signTransaction(Response.TransactionExtention txnExt) {
        return this.signTransaction(txnExt, this.keyPair);
    }

    @Override
    public Chain.Transaction signTransaction(Chain.Transaction txn) {
        return this.signTransaction(txn, this.keyPair);
    }

    private TransactionCapsule createTransactionCapsuleWithoutValidate(Message message, Chain.Transaction.Contract.ContractType contractType, Response.BlockExtention solidHeadBlock, Response.BlockExtention headBlock) throws Exception {
        Contract.CreateSmartContract contract;
        long percent;
        TransactionCapsule trx = new TransactionCapsule(message, contractType);
        if (contractType == Chain.Transaction.Contract.ContractType.CreateSmartContract && ((percent = (contract = Utils.getSmartContractFromTransaction(trx.getTransaction())).getNewContract().getConsumeUserResourcePercent()) < 0L || percent > 100L)) {
            throw new Exception("percent must be >= 0 and <= 100");
        }
        trx.setTransactionCreate(false);
        byte[] blockHash = Utils.getBlockId(solidHeadBlock).getBytes();
        trx.setReference(solidHeadBlock.getBlockHeader().getRawData().getNumber(), blockHash);
        long expiration = headBlock.getBlockHeader().getRawData().getTimestamp() + 60000L;
        trx.setExpiration(expiration);
        trx.setTimestamp();
        return trx;
    }

    private TransactionCapsule createTransaction(Message message, Chain.Transaction.Contract.ContractType contractType) throws Exception {
        GrpcAPI.BlockReq blockReq = GrpcAPI.BlockReq.newBuilder().setDetail(false).build();
        Response.BlockExtention solidHeadBlock = this.blockingStubSolidity.getBlock(blockReq);
        Response.BlockExtention headBlock = this.blockingStub.getBlock(blockReq);
        return this.createTransactionCapsuleWithoutValidate(message, contractType, solidHeadBlock, headBlock);
    }

    @Override
    public Response.TransactionExtention createTransactionExtention(Message request, Chain.Transaction.Contract.ContractType contractType) throws IllegalException {
        Response.TransactionExtention.Builder trxExtBuilder = Response.TransactionExtention.newBuilder();
        Response.TransactionReturn.Builder retBuilder = Response.TransactionReturn.newBuilder();
        try {
            TransactionCapsule trx = this.createTransaction(request, contractType);
            trxExtBuilder.setTransaction(trx.getTransaction());
            trxExtBuilder.setTxid(ByteString.copyFrom((byte[])Sha256Hash.hash(true, trx.getTransaction().getRawData().toByteArray())));
            retBuilder.setResult(true).setCode(Response.TransactionReturn.response_code.SUCCESS);
        }
        catch (Exception e) {
            retBuilder.setResult(false).setCode(Response.TransactionReturn.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
            throw new IllegalException("createTransactionExtention error," + e.getMessage());
        }
        trxExtBuilder.setResult(retBuilder);
        return trxExtBuilder.build();
    }

    @Override
    public long estimateBandwidth(Chain.Transaction txn) {
        return (long)txn.toBuilder().clearRet().build().getSerializedSize() + 64L;
    }

    private String resolveResultCode(int code2) {
        Response.TransactionReturn.response_code responseCode = Response.TransactionReturn.response_code.forNumber(code2);
        return responseCode != null ? responseCode.name() : "";
    }

    @Override
    public String broadcastTransaction(Chain.Transaction txn) throws RuntimeException {
        Response.TransactionReturn ret = this.blockingStub.broadcastTransaction(txn);
        if (!ret.getResult()) {
            String message = this.resolveResultCode(ret.getCodeValue()) + ", " + ret.getMessage();
            throw new RuntimeException(message);
        }
        byte[] txId = ApiWrapper.calculateTransactionHash(txn);
        return ByteArray.toHexString(txId);
    }

    @Override
    public Response.TransactionExtention transfer(String fromAddress, String toAddress, long amount) throws IllegalException {
        ByteString rawFrom = ApiWrapper.parseAddress(fromAddress);
        ByteString rawTo = ApiWrapper.parseAddress(toAddress);
        Contract.TransferContract transferContract = Contract.TransferContract.newBuilder().setOwnerAddress(rawFrom).setToAddress(rawTo).setAmount(amount).build();
        return this.createTransactionExtention((Message)transferContract, Chain.Transaction.Contract.ContractType.TransferContract);
    }

    @Override
    public Response.TransactionExtention transferTrc10(String fromAddress, String toAddress, int tokenId, long amount) throws IllegalException {
        ByteString rawFrom = ApiWrapper.parseAddress(fromAddress);
        ByteString rawTo = ApiWrapper.parseAddress(toAddress);
        byte[] rawTokenId = Integer.toString(tokenId).getBytes();
        Contract.TransferAssetContract transferAssetContract = Contract.TransferAssetContract.newBuilder().setOwnerAddress(rawFrom).setToAddress(rawTo).setAssetName(ByteString.copyFrom((byte[])rawTokenId)).setAmount(amount).build();
        return this.createTransactionExtention((Message)transferAssetContract, Chain.Transaction.Contract.ContractType.TransferAssetContract);
    }

    @Override
    public Response.TransactionExtention freezeBalance(String ownerAddress, long frozenBalance, int frozenDuration, int resourceCode) throws IllegalException {
        return this.freezeBalance(ownerAddress, frozenBalance, frozenDuration, resourceCode, "");
    }

    @Override
    public Response.TransactionExtention freezeBalance(String ownerAddress, long frozenBalance, int frozenDuration, int resourceCode, String receiveAddress) throws IllegalException {
        ByteString rawFrom = ApiWrapper.parseAddress(ownerAddress);
        ByteString rawReceiveFrom = ApiWrapper.parseAddress(receiveAddress);
        Contract.FreezeBalanceContract freezeBalanceContract = Contract.FreezeBalanceContract.newBuilder().setOwnerAddress(rawFrom).setFrozenBalance(frozenBalance).setFrozenDuration(frozenDuration).setResourceValue(resourceCode).setReceiverAddress(rawReceiveFrom).build();
        return this.createTransactionExtention((Message)freezeBalanceContract, Chain.Transaction.Contract.ContractType.FreezeBalanceContract);
    }

    @Override
    public Response.TransactionExtention freezeBalanceV2(String ownerAddress, long frozenBalance, int resourceCode) throws IllegalException {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        Contract.FreezeBalanceV2Contract freezeBalanceV2Contract = Contract.FreezeBalanceV2Contract.newBuilder().setOwnerAddress(rawOwner).setFrozenBalance(frozenBalance).setResourceValue(resourceCode).build();
        return this.createTransactionExtention((Message)freezeBalanceV2Contract, Chain.Transaction.Contract.ContractType.FreezeBalanceV2Contract);
    }

    @Override
    public Response.TransactionExtention unfreezeBalance(String ownerAddress, int resourceCode) throws IllegalException {
        return this.unfreezeBalance(ownerAddress, resourceCode, "");
    }

    @Override
    public Response.TransactionExtention unfreezeBalance(String ownerAddress, int resourceCode, String receiveAddress) throws IllegalException {
        Contract.UnfreezeBalanceContract unfreezeBalanceContract = Contract.UnfreezeBalanceContract.newBuilder().setOwnerAddress(ApiWrapper.parseAddress(ownerAddress)).setResourceValue(resourceCode).setReceiverAddress(ApiWrapper.parseAddress(receiveAddress)).build();
        return this.createTransactionExtention((Message)unfreezeBalanceContract, Chain.Transaction.Contract.ContractType.UnfreezeBalanceContract);
    }

    @Override
    public Response.TransactionExtention unfreezeBalanceV2(String ownerAddress, long unfreezeBalance, int resourceCode) throws IllegalException {
        Contract.UnfreezeBalanceV2Contract unfreezeBalanceV2Contract = Contract.UnfreezeBalanceV2Contract.newBuilder().setOwnerAddress(ApiWrapper.parseAddress(ownerAddress)).setResourceValue(resourceCode).setUnfreezeBalance(unfreezeBalance).build();
        return this.createTransactionExtention((Message)unfreezeBalanceV2Contract, Chain.Transaction.Contract.ContractType.UnfreezeBalanceV2Contract);
    }

    @Override
    public Response.TransactionExtention cancelAllUnfreezeV2(String ownerAddress) throws IllegalException {
        Contract.CancelAllUnfreezeV2Contract cancelUnfreezeV2Contract = Contract.CancelAllUnfreezeV2Contract.newBuilder().setOwnerAddress(ApiWrapper.parseAddress(ownerAddress)).build();
        return this.createTransactionExtention((Message)cancelUnfreezeV2Contract, Chain.Transaction.Contract.ContractType.CancelAllUnfreezeV2Contract);
    }

    @Override
    public Response.TransactionExtention delegateResource(String ownerAddress, long balance, int resourceCode, String receiverAddress, boolean lock) throws IllegalException {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        ByteString rawReceiver = ApiWrapper.parseAddress(receiverAddress);
        Contract.DelegateResourceContract delegateResourceContract = Contract.DelegateResourceContract.newBuilder().setOwnerAddress(rawOwner).setBalance(balance).setReceiverAddress(rawReceiver).setLock(lock).setResourceValue(resourceCode).build();
        return this.createTransactionExtention((Message)delegateResourceContract, Chain.Transaction.Contract.ContractType.DelegateResourceContract);
    }

    @Override
    public Response.TransactionExtention delegateResourceV2(String ownerAddress, long balance, int resourceCode, String receiverAddress, boolean lock, long lockPeriod) throws IllegalException {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        ByteString rawReceiver = ApiWrapper.parseAddress(receiverAddress);
        Contract.DelegateResourceContract delegateResourceContract = Contract.DelegateResourceContract.newBuilder().setOwnerAddress(rawOwner).setBalance(balance).setReceiverAddress(rawReceiver).setLock(lock).setResourceValue(resourceCode).build();
        if (lock) {
            delegateResourceContract = delegateResourceContract.toBuilder().setLockPeriod(lockPeriod).build();
        }
        return this.createTransactionExtention((Message)delegateResourceContract, Chain.Transaction.Contract.ContractType.DelegateResourceContract);
    }

    @Override
    public Response.TransactionExtention undelegateResource(String ownerAddress, long balance, int resourceCode, String receiverAddress) throws IllegalException {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        ByteString rawReceiver = ApiWrapper.parseAddress(receiverAddress);
        Contract.UnDelegateResourceContract unDelegateResourceContract = Contract.UnDelegateResourceContract.newBuilder().setOwnerAddress(rawOwner).setBalance(balance).setReceiverAddress(rawReceiver).setResourceValue(resourceCode).build();
        return this.createTransactionExtention((Message)unDelegateResourceContract, Chain.Transaction.Contract.ContractType.UnDelegateResourceContract);
    }

    @Override
    public Response.TransactionExtention withdrawExpireUnfreeze(String ownerAddress) throws IllegalException {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        Contract.WithdrawExpireUnfreezeContract withdrawExpireUnfreezeContract = Contract.WithdrawExpireUnfreezeContract.newBuilder().setOwnerAddress(rawOwner).build();
        return this.createTransactionExtention((Message)withdrawExpireUnfreezeContract, Chain.Transaction.Contract.ContractType.WithdrawExpireUnfreezeContract);
    }

    @Override
    public long getAvailableUnfreezeCount(String ownerAddress) {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        GrpcAPI.GetAvailableUnfreezeCountRequestMessage getAvailableUnfreezeCountRequestMessage = GrpcAPI.GetAvailableUnfreezeCountRequestMessage.newBuilder().setOwnerAddress(rawOwner).build();
        GrpcAPI.GetAvailableUnfreezeCountResponseMessage responseMessage = this.blockingStub.getAvailableUnfreezeCount(getAvailableUnfreezeCountRequestMessage);
        return responseMessage.getCount();
    }

    @Override
    public long getCanWithdrawUnfreezeAmount(String ownerAddress) {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        GrpcAPI.CanWithdrawUnfreezeAmountRequestMessage getAvailableUnfreezeCountRequestMessage = GrpcAPI.CanWithdrawUnfreezeAmountRequestMessage.newBuilder().setOwnerAddress(rawOwner).build();
        GrpcAPI.CanWithdrawUnfreezeAmountResponseMessage responseMessage = this.blockingStub.getCanWithdrawUnfreezeAmount(getAvailableUnfreezeCountRequestMessage);
        return responseMessage.getAmount();
    }

    @Override
    public long getCanWithdrawUnfreezeAmount(String ownerAddress, long timestamp) {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        GrpcAPI.CanWithdrawUnfreezeAmountRequestMessage getAvailableUnfreezeCountRequestMessage = GrpcAPI.CanWithdrawUnfreezeAmountRequestMessage.newBuilder().setOwnerAddress(rawOwner).setTimestamp(timestamp).build();
        GrpcAPI.CanWithdrawUnfreezeAmountResponseMessage responseMessage = this.blockingStub.getCanWithdrawUnfreezeAmount(getAvailableUnfreezeCountRequestMessage);
        return responseMessage.getAmount();
    }

    @Override
    public long getCanDelegatedMaxSize(String ownerAddress, int type) {
        ByteString rawFrom = ApiWrapper.parseAddress(ownerAddress);
        GrpcAPI.CanDelegatedMaxSizeRequestMessage getAvailableUnfreezeCountRequestMessage = GrpcAPI.CanDelegatedMaxSizeRequestMessage.newBuilder().setOwnerAddress(rawFrom).setType(type).build();
        GrpcAPI.CanDelegatedMaxSizeResponseMessage responseMessage = this.blockingStub.getCanDelegatedMaxSize(getAvailableUnfreezeCountRequestMessage);
        return responseMessage.getMaxSize();
    }

    @Override
    public Response.DelegatedResourceList getDelegatedResourceV2(String fromAddress, String toAddress) {
        ByteString rawFrom = ApiWrapper.parseAddress(fromAddress);
        ByteString rawTo = ApiWrapper.parseAddress(toAddress);
        Response.DelegatedResourceMessage delegatedResourceMessage = Response.DelegatedResourceMessage.newBuilder().setFromAddress(rawFrom).setToAddress(rawTo).build();
        return this.blockingStub.getDelegatedResourceV2(delegatedResourceMessage);
    }

    @Override
    public Response.DelegatedResourceAccountIndex getDelegatedResourceAccountIndexV2(String address) throws IllegalException {
        ByteString rawAddress = ApiWrapper.parseAddress(address);
        GrpcAPI.BytesMessage request = GrpcAPI.BytesMessage.newBuilder().setValue(rawAddress).build();
        return this.blockingStub.getDelegatedResourceAccountIndexV2(request);
    }

    @Override
    public Response.TransactionExtention voteWitness(String ownerAddress, HashMap<String, String> votes) throws IllegalException {
        ByteString rawFrom = ApiWrapper.parseAddress(ownerAddress);
        Contract.VoteWitnessContract voteWitnessContract = ApiWrapper.createVoteWitnessContract(rawFrom, votes);
        return this.createTransactionExtention((Message)voteWitnessContract, Chain.Transaction.Contract.ContractType.VoteWitnessContract);
    }

    @Override
    public Response.TransactionExtention createAccount(String ownerAddress, String accountAddress) throws IllegalException {
        ByteString bsOwnerAddress = ApiWrapper.parseAddress(ownerAddress);
        ByteString bsAccountAddress = ApiWrapper.parseAddress(accountAddress);
        Contract.AccountCreateContract accountCreateContract = ApiWrapper.createAccountCreateContract(bsOwnerAddress, bsAccountAddress);
        return this.createTransactionExtention((Message)accountCreateContract, Chain.Transaction.Contract.ContractType.AccountCreateContract);
    }

    @Override
    public Response.TransactionExtention updateAccount(String address, String accountName) throws IllegalException {
        ByteString bsAddress = ApiWrapper.parseAddress(address);
        byte[] bytesAccountName = accountName.getBytes();
        ByteString bsAccountName = ByteString.copyFrom((byte[])bytesAccountName);
        Contract.AccountUpdateContract accountUpdateContract = ApiWrapper.createAccountUpdateContract(bsAccountName, bsAddress);
        return this.createTransactionExtention((Message)accountUpdateContract, Chain.Transaction.Contract.ContractType.AccountUpdateContract);
    }

    @Override
    public Chain.Block getNowBlock() throws IllegalException {
        Chain.Block block = this.blockingStub.getNowBlock(GrpcAPI.EmptyMessage.newBuilder().build());
        if (!block.hasBlockHeader()) {
            throw new IllegalException("Fail to get latest block.");
        }
        return block;
    }

    @Override
    public Response.BlockExtention getBlockByNum(long blockNum) throws IllegalException {
        GrpcAPI.NumberMessage.Builder builder = GrpcAPI.NumberMessage.newBuilder();
        builder.setNum(blockNum);
        Response.BlockExtention block = this.blockingStub.getBlockByNum2(builder.build());
        if (!block.hasBlockHeader()) {
            throw new IllegalException();
        }
        return block;
    }

    @Override
    public Response.BlockListExtention getBlockByLatestNum(long num) throws IllegalException {
        GrpcAPI.NumberMessage numberMessage = GrpcAPI.NumberMessage.newBuilder().setNum(num).build();
        Response.BlockListExtention blockListExtention = this.blockingStub.getBlockByLatestNum2(numberMessage);
        if (blockListExtention.getBlockCount() == 0) {
            throw new IllegalException("The number of latest blocks must be between 1 and 99, please check it.");
        }
        return blockListExtention;
    }

    @Override
    public Response.BlockListExtention getBlockByLimitNext(long startNum, long endNum) throws IllegalException {
        GrpcAPI.BlockLimit blockLimit = GrpcAPI.BlockLimit.newBuilder().setStartNum(startNum).setEndNum(endNum).build();
        Response.BlockListExtention blockListExtention = this.blockingStub.getBlockByLimitNext2(blockLimit);
        if (endNum - startNum > 100L) {
            throw new IllegalException("The difference between startNum and endNum cannot be greater than 100, please check it.");
        }
        if (blockListExtention.getBlockCount() == 0) {
            throw new IllegalException();
        }
        return blockListExtention;
    }

    @Override
    public Response.NodeInfo getNodeInfo() throws IllegalException {
        Response.NodeInfo nodeInfo = this.blockingStub.getNodeInfo(GrpcAPI.EmptyMessage.newBuilder().build());
        if (nodeInfo.getBlock().isEmpty()) {
            throw new IllegalException("Fail to get node info.");
        }
        return nodeInfo;
    }

    @Override
    public Response.NodeList listNodes() throws IllegalException {
        Response.NodeList nodeList = this.blockingStub.listNodes(GrpcAPI.EmptyMessage.newBuilder().build());
        if (nodeList.getNodesCount() == 0) {
            throw new IllegalException("Fail to get node list.");
        }
        return nodeList;
    }

    @Override
    public Response.TransactionInfoList getTransactionInfoByBlockNum(long blockNum) throws IllegalException {
        GrpcAPI.NumberMessage numberMessage = GrpcAPI.NumberMessage.newBuilder().setNum(blockNum).build();
        Response.TransactionInfoList transactionInfoList = this.blockingStub.getTransactionInfoByBlockNum(numberMessage);
        if (transactionInfoList.getTransactionInfoCount() == 0) {
            throw new IllegalException("no transactions or the blockNum is incorrect.");
        }
        return transactionInfoList;
    }

    @Override
    public Response.TransactionInfo getTransactionInfoById(String txID) throws IllegalException {
        ByteString bsTxId = ApiWrapper.parseAddress(txID);
        GrpcAPI.BytesMessage request = GrpcAPI.BytesMessage.newBuilder().setValue(bsTxId).build();
        Response.TransactionInfo transactionInfo = this.blockingStub.getTransactionInfoById(request);
        if (transactionInfo.getBlockTimeStamp() == 0L) {
            throw new IllegalException();
        }
        return transactionInfo;
    }

    @Override
    public Chain.Transaction getTransactionById(String txID) throws IllegalException {
        ByteString bsTxId = ApiWrapper.parseAddress(txID);
        GrpcAPI.BytesMessage request = GrpcAPI.BytesMessage.newBuilder().setValue(bsTxId).build();
        Chain.Transaction transaction = this.blockingStub.getTransactionById(request);
        if (transaction.getRetCount() == 0) {
            throw new IllegalException();
        }
        return transaction;
    }

    @Override
    public Response.Account getAccount(String address) {
        ByteString bsAddress = ApiWrapper.parseAddress(address);
        GrpcAPI.AccountAddressMessage accountAddressMessage = GrpcAPI.AccountAddressMessage.newBuilder().setAddress(bsAddress).build();
        return this.blockingStub.getAccount(accountAddressMessage);
    }

    @Override
    public Response.AccountResourceMessage getAccountResource(String address) {
        ByteString bsAddress = ApiWrapper.parseAddress(address);
        GrpcAPI.AccountAddressMessage account = GrpcAPI.AccountAddressMessage.newBuilder().setAddress(bsAddress).build();
        return this.blockingStub.getAccountResource(account);
    }

    @Override
    public Response.AccountNetMessage getAccountNet(String address) {
        ByteString bsAddress = ApiWrapper.parseAddress(address);
        GrpcAPI.AccountAddressMessage account = GrpcAPI.AccountAddressMessage.newBuilder().setAddress(bsAddress).build();
        return this.blockingStub.getAccountNet(account);
    }

    @Override
    public long getAccountBalance(String address) {
        Response.Account account = this.getAccount(address);
        return account.getBalance();
    }

    @Override
    public Response.Account getAccountById(String id) {
        ByteString bsId = ByteString.copyFrom((byte[])id.getBytes());
        GrpcAPI.AccountIdMessage accountId = GrpcAPI.AccountIdMessage.newBuilder().setId(bsId).build();
        return this.blockingStub.getAccountById(accountId);
    }

    @Override
    public Chain.Transaction setAccountId(String id, String address) throws IllegalException {
        ByteString bsId = ByteString.copyFrom((byte[])id.getBytes());
        ByteString bsAddress = ApiWrapper.parseAddress(address);
        Contract.SetAccountIdContract setAccountIdContract = ApiWrapper.createSetAccountIdContract(bsId, bsAddress);
        return this.createTransactionExtention((Message)setAccountIdContract, Chain.Transaction.Contract.ContractType.SetAccountIdContract).getTransaction();
    }

    @Override
    public Response.TransactionExtention setAccountId2(String id, String address) throws IllegalException {
        ByteString bsId = ByteString.copyFrom((byte[])id.getBytes());
        ByteString bsAddress = ApiWrapper.parseAddress(address);
        Contract.SetAccountIdContract setAccountIdContract = ApiWrapper.createSetAccountIdContract(bsId, bsAddress);
        return this.createTransactionExtention((Message)setAccountIdContract, Chain.Transaction.Contract.ContractType.SetAccountIdContract);
    }

    @Override
    public Response.ChainParameters getChainParameters() throws IllegalException {
        Response.ChainParameters chainParameters = this.blockingStub.getChainParameters(GrpcAPI.EmptyMessage.newBuilder().build());
        if (chainParameters.getChainParameterCount() == 0) {
            throw new IllegalException("Fail to get chain parameters.");
        }
        return chainParameters;
    }

    @Override
    public Response.DelegatedResourceList getDelegatedResource(String fromAddress, String toAddress) {
        ByteString fromAddressBS = ApiWrapper.parseAddress(fromAddress);
        ByteString toAddressBS = ApiWrapper.parseAddress(toAddress);
        Response.DelegatedResourceMessage request = Response.DelegatedResourceMessage.newBuilder().setFromAddress(fromAddressBS).setToAddress(toAddressBS).build();
        return this.blockingStub.getDelegatedResource(request);
    }

    @Override
    public Response.DelegatedResourceAccountIndex getDelegatedResourceAccountIndex(String address) {
        ByteString addressBS = ApiWrapper.parseAddress(address);
        GrpcAPI.BytesMessage bytesMessage = GrpcAPI.BytesMessage.newBuilder().setValue(addressBS).build();
        return this.blockingStub.getDelegatedResourceAccountIndex(bytesMessage);
    }

    @Override
    public Response.AssetIssueList getAssetIssueList() {
        return this.blockingStub.getAssetIssueList(GrpcAPI.EmptyMessage.newBuilder().build());
    }

    @Override
    public Response.AssetIssueList getPaginatedAssetIssueList(long offset, long limit) {
        GrpcAPI.PaginatedMessage pageMessage = GrpcAPI.PaginatedMessage.newBuilder().setOffset(offset).setLimit(limit).build();
        return this.blockingStub.getPaginatedAssetIssueList(pageMessage);
    }

    @Override
    public Response.AssetIssueList getAssetIssueByAccount(String address) {
        ByteString addressBS = ApiWrapper.parseAddress(address);
        GrpcAPI.AccountAddressMessage request = GrpcAPI.AccountAddressMessage.newBuilder().setAddress(addressBS).build();
        return this.blockingStub.getAssetIssueByAccount(request);
    }

    @Override
    public Contract.AssetIssueContract getAssetIssueById(String assetId) {
        ByteString assetIdBs = ByteString.copyFrom((byte[])assetId.getBytes());
        GrpcAPI.BytesMessage request = GrpcAPI.BytesMessage.newBuilder().setValue(assetIdBs).build();
        return this.blockingStub.getAssetIssueById(request);
    }

    @Override
    public Contract.AssetIssueContract getAssetIssueByName(String name) {
        ByteString assetNameBs = ByteString.copyFrom((byte[])name.getBytes());
        GrpcAPI.BytesMessage request = GrpcAPI.BytesMessage.newBuilder().setValue(assetNameBs).build();
        return this.blockingStub.getAssetIssueByName(request);
    }

    @Override
    public Response.AssetIssueList getAssetIssueListByName(String name) {
        ByteString assetNameBs = ByteString.copyFrom((byte[])name.getBytes());
        GrpcAPI.BytesMessage request = GrpcAPI.BytesMessage.newBuilder().setValue(assetNameBs).build();
        return this.blockingStub.getAssetIssueListByName(request);
    }

    @Override
    public Response.TransactionExtention participateAssetIssue(String toAddress, String ownerAddress, String assertName, long amount) throws IllegalException {
        ByteString bsTo = ApiWrapper.parseAddress(toAddress);
        ByteString bsOwner = ApiWrapper.parseAddress(ownerAddress);
        ByteString bsName = ByteString.copyFrom((byte[])assertName.getBytes());
        Contract.ParticipateAssetIssueContract participateAssetIssueContract = Contract.ParticipateAssetIssueContract.newBuilder().setToAddress(bsTo).setAssetName(bsName).setOwnerAddress(bsOwner).setAmount(amount).build();
        return this.createTransactionExtention((Message)participateAssetIssueContract, Chain.Transaction.Contract.ContractType.ParticipateAssetIssueContract);
    }

    @Override
    public Response.ProposalList listProposals() {
        return this.blockingStub.listProposals(GrpcAPI.EmptyMessage.newBuilder().build());
    }

    @Override
    public Response.Proposal getProposalById(String id) {
        ByteString bsTxId = ByteString.copyFrom((byte[])ByteArray.fromLong(Long.parseLong(id)));
        GrpcAPI.BytesMessage request = GrpcAPI.BytesMessage.newBuilder().setValue(bsTxId).build();
        return this.blockingStub.getProposalById(request);
    }

    @Override
    public Response.WitnessList listWitnesses() {
        return this.blockingStub.listWitnesses(GrpcAPI.EmptyMessage.newBuilder().build());
    }

    @Override
    public Response.ExchangeList listExchanges() {
        return this.blockingStub.listExchanges(GrpcAPI.EmptyMessage.newBuilder().build());
    }

    @Override
    public Response.Exchange getExchangeById(String id) throws IllegalException {
        ByteString bsTxId = ByteString.copyFrom((byte[])ByteArray.fromLong(Long.parseLong(id)));
        GrpcAPI.BytesMessage request = GrpcAPI.BytesMessage.newBuilder().setValue(bsTxId).build();
        Response.Exchange exchange = this.blockingStub.getExchangeById(request);
        if (exchange.getSerializedSize() == 0) {
            throw new IllegalException();
        }
        return exchange;
    }

    @Override
    public Response.TransactionExtention createAssetIssue(String ownerAddress, String name, String abbr, long totalSupply, int trxNum, int icoNum, long startTime, long endTime, String url, long freeAssetNetLimit, long publicFreeAssetNetLimit, int precision, HashMap<String, String> frozenSupply, String description) throws IllegalException {
        Contract.AssetIssueContract.Builder builder = this.assetIssueContractBuilder(ownerAddress, name, abbr, totalSupply, trxNum, icoNum, startTime, endTime, url, freeAssetNetLimit, publicFreeAssetNetLimit, precision, description);
        for (Map.Entry<String, String> entry : frozenSupply.entrySet()) {
            String daysStr = entry.getKey();
            String amountStr = entry.getValue();
            long amount = Long.parseLong(amountStr);
            long days = Long.parseLong(daysStr);
            Contract.AssetIssueContract.FrozenSupply.Builder frozenBuilder = Contract.AssetIssueContract.FrozenSupply.newBuilder();
            frozenBuilder.setFrozenAmount(amount);
            frozenBuilder.setFrozenDays(days);
            builder.addFrozenSupply(frozenBuilder.build());
        }
        Contract.AssetIssueContract assetIssueContract = builder.build();
        return this.createTransactionExtention((Message)assetIssueContract, Chain.Transaction.Contract.ContractType.AssetIssueContract);
    }

    @Override
    public Response.TransactionExtention createAssetIssue(String ownerAddress, String name, String abbr, long totalSupply, int trxNum, int icoNum, long startTime, long endTime, String url, long freeAssetNetLimit, long publicFreeAssetNetLimit, int precision, String description) throws IllegalException {
        Contract.AssetIssueContract.Builder builder = this.assetIssueContractBuilder(ownerAddress, name, abbr, totalSupply, trxNum, icoNum, startTime, endTime, url, freeAssetNetLimit, publicFreeAssetNetLimit, precision, description);
        Contract.AssetIssueContract assetIssueContract = builder.build();
        return this.createTransactionExtention((Message)assetIssueContract, Chain.Transaction.Contract.ContractType.AssetIssueContract);
    }

    @Override
    public Contract.AssetIssueContract.Builder assetIssueContractBuilder(String ownerAddress, String name, String abbr, long totalSupply, int trxNum, int icoNum, long startTime, long endTime, String url, long freeAssetNetLimit, long publicFreeAssetNetLimit, int precision, String description) {
        ByteString bsAddress = ApiWrapper.parseAddress(ownerAddress);
        return Contract.AssetIssueContract.newBuilder().setOwnerAddress(bsAddress).setName(ByteString.copyFrom((byte[])name.getBytes())).setAbbr(ByteString.copyFrom((byte[])abbr.getBytes())).setTotalSupply(totalSupply).setTrxNum(trxNum).setNum(icoNum).setStartTime(startTime).setEndTime(endTime).setUrl(ByteString.copyFrom((byte[])url.getBytes())).setFreeAssetNetLimit(freeAssetNetLimit).setPublicFreeAssetNetLimit(publicFreeAssetNetLimit).setPrecision(precision).setDescription(ByteString.copyFrom((byte[])description.getBytes()));
    }

    @Override
    public Response.TransactionExtention updateAsset(String ownerAddress, String description, String url, long newLimit, long newPublicLimit) throws IllegalException {
        ByteString bsOwnerAddress = ApiWrapper.parseAddress(ownerAddress);
        ByteString bsDescription = ByteString.copyFrom((byte[])description.getBytes());
        ByteString bsUrl = ByteString.copyFrom((byte[])url.getBytes());
        Contract.UpdateAssetContract updateAssetContract = ApiWrapper.createUpdateAssetContract(bsOwnerAddress, bsDescription, bsUrl, newLimit, newPublicLimit);
        return this.createTransactionExtention((Message)updateAssetContract, Chain.Transaction.Contract.ContractType.UpdateAssetContract);
    }

    @Override
    public Response.TransactionExtention unfreezeAsset(String ownerAddress) throws IllegalException {
        ByteString bsOwnerAddress = ApiWrapper.parseAddress(ownerAddress);
        Contract.UnfreezeAssetContract unfreezeAssetContract = ApiWrapper.createUnfreezeAssetContract(bsOwnerAddress);
        return this.createTransactionExtention((Message)unfreezeAssetContract, Chain.Transaction.Contract.ContractType.UnfreezeAssetContract);
    }

    @Override
    public Response.TransactionExtention accountPermissionUpdate(Contract.AccountPermissionUpdateContract accountPermissionUpdateContract) throws IllegalException {
        return this.createTransactionExtention((Message)accountPermissionUpdateContract, Chain.Transaction.Contract.ContractType.AccountPermissionUpdateContract);
    }

    @Override
    public Response.TransactionSignWeight getTransactionSignWeight(Chain.Transaction trx) {
        return this.blockingStub.getTransactionSignWeight(trx);
    }

    @Override
    public Response.TransactionApprovedList getTransactionApprovedList(Chain.Transaction trx) {
        return this.blockingStub.getTransactionApprovedList(trx);
    }

    @Override
    public Response.Account getAccountSolidity(String address) {
        ByteString bsAddress = ApiWrapper.parseAddress(address);
        GrpcAPI.AccountAddressMessage accountAddressMessage = GrpcAPI.AccountAddressMessage.newBuilder().setAddress(bsAddress).build();
        return this.blockingStubSolidity.getAccount(accountAddressMessage);
    }

    @Override
    public Response.BlockExtention getNowBlockSolidity() throws IllegalException {
        Response.BlockExtention blockExtention = this.blockingStubSolidity.getNowBlock2(GrpcAPI.EmptyMessage.newBuilder().build());
        if (!blockExtention.hasBlockHeader()) {
            throw new IllegalException("Fail to get latest block.");
        }
        return blockExtention;
    }

    @Override
    public Chain.Transaction getTransactionByIdSolidity(String txID) throws IllegalException {
        ByteString bsTxId = ApiWrapper.parseHex(txID);
        GrpcAPI.BytesMessage request = GrpcAPI.BytesMessage.newBuilder().setValue(bsTxId).build();
        Chain.Transaction transaction = this.blockingStubSolidity.getTransactionById(request);
        if (transaction.getRetCount() == 0) {
            throw new IllegalException();
        }
        return transaction;
    }

    @Override
    public GrpcAPI.NumberMessage getRewardSolidity(String address) {
        ByteString bsAddress = ApiWrapper.parseAddress(address);
        GrpcAPI.BytesMessage bytesMessage = GrpcAPI.BytesMessage.newBuilder().setValue(bsAddress).build();
        return this.blockingStubSolidity.getRewardInfo(bytesMessage);
    }

    public static Contract.VoteWitnessContract createVoteWitnessContract(ByteString ownerAddress, Map<String, String> votes) {
        Contract.VoteWitnessContract.Builder builder = Contract.VoteWitnessContract.newBuilder();
        builder.setOwnerAddress(ownerAddress);
        for (String addressBase58 : votes.keySet()) {
            String voteCount = votes.get(addressBase58);
            long count = Long.parseLong(voteCount);
            Contract.VoteWitnessContract.Vote.Builder voteBuilder = Contract.VoteWitnessContract.Vote.newBuilder();
            ByteString voteAddress = ApiWrapper.parseAddress(addressBase58);
            voteBuilder.setVoteAddress(voteAddress);
            voteBuilder.setVoteCount(count);
            builder.addVotes(voteBuilder.build());
        }
        return builder.build();
    }

    public static Contract.AccountUpdateContract createAccountUpdateContract(ByteString accountName, ByteString address) {
        Contract.AccountUpdateContract.Builder builder = Contract.AccountUpdateContract.newBuilder();
        builder.setAccountName(accountName);
        builder.setOwnerAddress(address);
        return builder.build();
    }

    public static Contract.AccountCreateContract createAccountCreateContract(ByteString owner, ByteString address) {
        Contract.AccountCreateContract.Builder builder = Contract.AccountCreateContract.newBuilder();
        builder.setOwnerAddress(owner);
        builder.setAccountAddress(address);
        return builder.build();
    }

    public static Contract.SetAccountIdContract createSetAccountIdContract(ByteString accountId, ByteString address) {
        Contract.SetAccountIdContract.Builder builder = Contract.SetAccountIdContract.newBuilder();
        builder.setAccountId(accountId);
        builder.setOwnerAddress(address);
        return builder.build();
    }

    public static Contract.UpdateAssetContract createUpdateAssetContract(ByteString address, ByteString description, ByteString url, long newLimit, long newPublicLimit) {
        Contract.UpdateAssetContract.Builder builder = Contract.UpdateAssetContract.newBuilder();
        builder.setDescription(description);
        builder.setUrl(url);
        builder.setNewLimit(newLimit);
        builder.setNewPublicLimit(newPublicLimit);
        builder.setOwnerAddress(address);
        return builder.build();
    }

    public static Contract.UnfreezeAssetContract createUnfreezeAssetContract(ByteString address) {
        Contract.UnfreezeAssetContract.Builder builder = Contract.UnfreezeAssetContract.newBuilder();
        builder.setOwnerAddress(address);
        return builder.build();
    }

    @Override
    public Response.TransactionExtention updateBrokerage(String address, int brokerage) throws IllegalException {
        ByteString ownerAddress = ApiWrapper.parseAddress(address);
        Contract.UpdateBrokerageContract updateBrokerageContract = Contract.UpdateBrokerageContract.newBuilder().setOwnerAddress(ownerAddress).setBrokerage(brokerage).build();
        return this.createTransactionExtention((Message)updateBrokerageContract, Chain.Transaction.Contract.ContractType.UpdateBrokerageContract);
    }

    @Override
    public long getBrokerageInfo(String address) {
        ByteString sr = ApiWrapper.parseAddress(address);
        GrpcAPI.BytesMessage param = GrpcAPI.BytesMessage.newBuilder().setValue(sr).build();
        return this.blockingStub.getBrokerageInfo(param).getNum();
    }

    @Override
    public Contract getContract(String contractAddress) {
        ByteString rawAddress = ApiWrapper.parseAddress(contractAddress);
        GrpcAPI.BytesMessage param = GrpcAPI.BytesMessage.newBuilder().setValue(rawAddress).build();
        Common.SmartContract smartContract = this.blockingStub.getContract(param);
        return new Contract.Builder().setOriginAddr(smartContract.getOriginAddress()).setCntrAddr(smartContract.getContractAddress()).setAbi(smartContract.getAbi()).setBytecode(smartContract.getBytecode()).setCallValue(smartContract.getCallValue()).setConsumeUserResourcePercent(smartContract.getConsumeUserResourcePercent()).setName(smartContract.getName()).setOriginEnergyLimit(smartContract.getOriginEnergyLimit()).setCodeHash(smartContract.getCodeHash()).setTrxHash(smartContract.getTrxHash()).setVersion(smartContract.getVersion()).build();
    }

    @Override
    public Common.SmartContract getSmartContract(String contractAddress) {
        ByteString rawAddress = ApiWrapper.parseAddress(contractAddress);
        GrpcAPI.BytesMessage param = GrpcAPI.BytesMessage.newBuilder().setValue(rawAddress).build();
        return this.blockingStub.getContract(param);
    }

    private boolean isFuncInContract(Contract contract, Function function) {
        List<ContractFunction> functions = contract.getFunctions();
        for (ContractFunction contractFunction : functions) {
            if (!contractFunction.getName().equalsIgnoreCase(function.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public Response.TransactionExtention constantCall(String ownerAddress, String contractAddress, Function function) {
        String encodedHex = FunctionEncoder.encode(function);
        Contract.TriggerSmartContract trigger = this.buildTrigger(ownerAddress, contractAddress, encodedHex, 0L, 0L, null);
        return this.blockingStub.triggerConstantContract(trigger);
    }

    @Override
    @Deprecated
    public Response.TransactionExtention constantCallV2(String ownerAddress, String contractAddress, String callData) {
        Contract.TriggerSmartContract trigger = this.buildTrigger(ownerAddress, contractAddress, callData, 0L, 0L, null);
        return this.blockingStub.triggerConstantContract(trigger);
    }

    @Override
    public Response.TransactionExtention triggerConstantContract(String ownerAddress, String contractAddress, String callData) {
        Contract.TriggerSmartContract trigger = this.buildTrigger(ownerAddress, contractAddress, callData, 0L, 0L, null);
        return this.blockingStub.triggerConstantContract(trigger);
    }

    @Override
    public Response.TransactionExtention triggerConstantContract(String ownerAddress, String contractAddress, String callData, long callValue, long tokenValue, String tokenId) {
        Contract.TriggerSmartContract trigger = this.buildTrigger(ownerAddress, contractAddress, callData, callValue, tokenValue, tokenId);
        return this.blockingStub.triggerConstantContract(trigger);
    }

    @Override
    @Deprecated
    public TransactionBuilder triggerCall(String ownerAddress, String contractAddress, Function function) {
        Response.TransactionExtention txnExt = this.constantCall(ownerAddress, contractAddress, function);
        return new TransactionBuilder(txnExt.getTransaction());
    }

    @Override
    @Deprecated
    public TransactionBuilder triggerCallV2(String ownerAddress, String contractAddress, String callData) {
        Contract.TriggerSmartContract trigger = this.buildTrigger(ownerAddress, contractAddress, callData, 0L, 0L, null);
        Response.TransactionExtention txnExt = this.blockingStub.triggerConstantContract(trigger);
        return new TransactionBuilder(txnExt.getTransaction());
    }

    @Override
    public TransactionBuilder triggerConstantContract(String ownerAddress, String contractAddress, String callData, long callValue, long tokenValue, String tokenId, long feeLimit) {
        Contract.TriggerSmartContract trigger = this.buildTrigger(ownerAddress, contractAddress, callData, callValue, tokenValue, tokenId);
        Response.TransactionExtention txnExt = this.blockingStub.triggerConstantContract(trigger);
        TransactionBuilder builder = new TransactionBuilder(txnExt.getTransaction());
        builder.setFeeLimit(feeLimit);
        return builder;
    }

    @Override
    public Response.TransactionExtention triggerContract(String ownerAddress, String contractAddress, Function function) {
        String encodedHex = FunctionEncoder.encode(function);
        Contract.TriggerSmartContract trigger = this.buildTrigger(ownerAddress, contractAddress, encodedHex, 0L, 0L, null);
        return this.blockingStub.triggerContract(trigger);
    }

    @Override
    public Response.TransactionExtention triggerContract(String ownerAddress, String contractAddress, String callData) {
        Contract.TriggerSmartContract trigger = this.buildTrigger(ownerAddress, contractAddress, callData, 0L, 0L, null);
        return this.blockingStub.triggerContract(trigger);
    }

    @Override
    public Response.TransactionExtention triggerContract(String ownerAddress, String contractAddress, Function function, long callValue, long tokenValue, String tokenId) {
        String encodedHex = FunctionEncoder.encode(function);
        Contract.TriggerSmartContract trigger = this.buildTrigger(ownerAddress, contractAddress, encodedHex, callValue, tokenValue, tokenId);
        return this.blockingStub.triggerContract(trigger);
    }

    @Override
    public Response.TransactionExtention triggerContract(String ownerAddress, String contractAddress, String callData, long callValue, long tokenValue, String tokenId) {
        Contract.TriggerSmartContract trigger = this.buildTrigger(ownerAddress, contractAddress, callData, callValue, tokenValue, tokenId);
        return this.blockingStub.triggerContract(trigger);
    }

    @Override
    public Response.BlockBalanceTrace getBlockBalance(String blockId, long blockNum) {
        ByteString bsId = ApiWrapper.parseHex(blockId);
        Response.BlockIdentifier blockIdentifier = Response.BlockIdentifier.newBuilder().setHash(bsId).setNumber(blockNum).build();
        return this.blockingStub.getBlockBalanceTrace(blockIdentifier);
    }

    @Override
    public long getBurnTRX() {
        GrpcAPI.NumberMessage numberMessage = this.blockingStub.getBurnTrx(GrpcAPI.EmptyMessage.getDefaultInstance());
        return numberMessage.getNum();
    }

    @Override
    public Response.TransactionExtention createWitness(String ownerAddress, String url) throws IllegalException {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        Contract.WitnessCreateContract witnessCreateContract = Contract.WitnessCreateContract.newBuilder().setOwnerAddress(rawOwner).setUrl(ByteString.copyFromUtf8((String)url)).build();
        return this.createTransactionExtention((Message)witnessCreateContract, Chain.Transaction.Contract.ContractType.WitnessCreateContract);
    }

    @Override
    public Response.TransactionExtention updateWitness(String ownerAddress, String updateUrl) throws IllegalException {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        Contract.WitnessUpdateContract witnessUpdateContract = Contract.WitnessUpdateContract.newBuilder().setOwnerAddress(rawOwner).setUpdateUrl(ByteString.copyFromUtf8((String)updateUrl)).build();
        return this.createTransactionExtention((Message)witnessUpdateContract, Chain.Transaction.Contract.ContractType.WitnessUpdateContract);
    }

    @Override
    public Response.TransactionExtention withdrawBalance(String ownerAddress) throws IllegalException {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        Contract.WithdrawBalanceContract withdrawBalanceContract = Contract.WithdrawBalanceContract.newBuilder().setOwnerAddress(rawOwner).build();
        return this.createTransactionExtention((Message)withdrawBalanceContract, Chain.Transaction.Contract.ContractType.WithdrawBalanceContract);
    }

    @Override
    public long getNextMaintenanceTime() {
        GrpcAPI.NumberMessage numberMessage = this.blockingStub.getNextMaintenanceTime(GrpcAPI.EmptyMessage.getDefaultInstance());
        return numberMessage.getNum();
    }

    @Override
    public Response.TransactionExtention proposalCreate(String ownerAddress, Map<Long, Long> parameters) throws IllegalException {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        Contract.ProposalCreateContract proposalCreateContract = Contract.ProposalCreateContract.newBuilder().setOwnerAddress(rawOwner).putAllParameters(parameters).build();
        return this.createTransactionExtention((Message)proposalCreateContract, Chain.Transaction.Contract.ContractType.ProposalCreateContract);
    }

    @Override
    public Response.TransactionExtention approveProposal(String ownerAddress, long proposalId, boolean isAddApproval) throws IllegalException {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        Contract.ProposalApproveContract proposalApproveContract = Contract.ProposalApproveContract.newBuilder().setOwnerAddress(rawOwner).setIsAddApproval(isAddApproval).setProposalId(proposalId).build();
        return this.createTransactionExtention((Message)proposalApproveContract, Chain.Transaction.Contract.ContractType.ProposalApproveContract);
    }

    @Override
    public Response.TransactionExtention deleteProposal(String ownerAddress, long proposalId) throws IllegalException {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        Contract.ProposalDeleteContract proposalDeleteContract = Contract.ProposalDeleteContract.newBuilder().setOwnerAddress(rawOwner).setProposalId(proposalId).build();
        return this.createTransactionExtention((Message)proposalDeleteContract, Chain.Transaction.Contract.ContractType.ProposalDeleteContract);
    }

    @Override
    public GrpcAPI.TransactionIdList getTransactionListFromPending() {
        return this.blockingStub.getTransactionListFromPending(GrpcAPI.EmptyMessage.getDefaultInstance());
    }

    @Override
    public long getPendingSize() {
        GrpcAPI.NumberMessage pendingSize = this.blockingStub.getPendingSize(GrpcAPI.EmptyMessage.getDefaultInstance());
        return pendingSize.getNum();
    }

    @Override
    public Chain.Transaction getTransactionFromPending(String txId) throws IllegalException {
        ByteString bsTxId = ByteString.copyFrom((byte[])ByteArray.fromHexString(txId));
        GrpcAPI.BytesMessage request = GrpcAPI.BytesMessage.newBuilder().setValue(bsTxId).build();
        return this.blockingStub.getTransactionFromPending(request);
    }

    @Override
    public Chain.Block getBlockById(String blockID) {
        ByteString bsBlockId = ApiWrapper.parseHex(blockID);
        GrpcAPI.BytesMessage request = GrpcAPI.BytesMessage.newBuilder().setValue(bsBlockId).build();
        return this.blockingStub.getBlockById(request);
    }

    @Override
    public Response.EstimateEnergyMessage estimateEnergy(String ownerAddress, String contractAddress, Function function) {
        String encodedHex = FunctionEncoder.encode(function);
        Contract.TriggerSmartContract trigger = this.buildTrigger(ownerAddress, contractAddress, encodedHex, 0L, 0L, null);
        return this.blockingStub.estimateEnergy(trigger);
    }

    @Override
    public Response.EstimateEnergyMessage estimateEnergyV2(String ownerAddress, String contractAddress, String callData) {
        Contract.TriggerSmartContract trigger = this.buildTrigger(ownerAddress, contractAddress, callData, 0L, 0L, null);
        return this.blockingStub.estimateEnergy(trigger);
    }

    @Override
    public Response.EstimateEnergyMessage estimateEnergyV2(String ownerAddress, String contractAddress, String callData, long callValue, long tokenValue, String tokenId) {
        Contract.TriggerSmartContract trigger = this.buildTrigger(ownerAddress, contractAddress, callData, callValue, tokenValue, tokenId);
        return this.blockingStub.estimateEnergy(trigger);
    }

    private Contract.TriggerSmartContract buildTrigger(String ownerAddress, String contractAddress, String callData, long callValue, long tokenValue, String tokenId) {
        Contract.TriggerSmartContract.Builder builder = Contract.TriggerSmartContract.newBuilder().setOwnerAddress(ApiWrapper.parseAddress(ownerAddress)).setContractAddress(ApiWrapper.parseAddress(contractAddress)).setData(ByteString.copyFrom((byte[])ByteArray.fromHexString(callData)));
        if (callValue > 0L) {
            builder.setCallValue(callValue);
        }
        if (tokenId != null && !tokenId.isEmpty()) {
            builder.setCallTokenValue(tokenValue);
            builder.setTokenId(Long.parseLong(tokenId));
        }
        return builder.build();
    }

    @Override
    public Response.PricesResponseMessage getBandwidthPrices() {
        return this.blockingStub.getBandwidthPrices(GrpcAPI.EmptyMessage.getDefaultInstance());
    }

    @Override
    public Response.PricesResponseMessage getEnergyPrices() {
        return this.blockingStub.getEnergyPrices(GrpcAPI.EmptyMessage.getDefaultInstance());
    }

    @Override
    public Response.PricesResponseMessage getMemoFee() {
        return this.blockingStub.getMemoFee(GrpcAPI.EmptyMessage.getDefaultInstance());
    }

    @Override
    public Response.PricesResponseMessage getBandwidthPricesOnSolidity() {
        return this.blockingStubSolidity.getBandwidthPrices(GrpcAPI.EmptyMessage.getDefaultInstance());
    }

    @Override
    public Response.PricesResponseMessage getEnergyPricesOnSolidity() {
        return this.blockingStubSolidity.getEnergyPrices(GrpcAPI.EmptyMessage.getDefaultInstance());
    }

    @Override
    public Response.TransactionExtention clearContractABI(String ownerAddress, String contractAddress) throws IllegalException {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        ByteString rawContract = ApiWrapper.parseAddress(contractAddress);
        Contract.ClearABIContract clearABIContract = Contract.ClearABIContract.newBuilder().setOwnerAddress(rawOwner).setContractAddress(rawContract).build();
        return this.createTransactionExtention((Message)clearABIContract, Chain.Transaction.Contract.ContractType.ClearABIContract);
    }

    @Override
    public Response.ExchangeList getPaginatedExchangeList(long offset, long limit) {
        GrpcAPI.PaginatedMessage paginatedMessage = GrpcAPI.PaginatedMessage.newBuilder().setOffset(offset).setLimit(limit).build();
        return this.blockingStub.getPaginatedExchangeList(paginatedMessage);
    }

    @Override
    public Response.ProposalList getPaginatedProposalList(long offset, long limit) {
        GrpcAPI.PaginatedMessage paginatedMessage = GrpcAPI.PaginatedMessage.newBuilder().setOffset(offset).setLimit(limit).build();
        return this.blockingStub.getPaginatedProposalList(paginatedMessage);
    }

    @Override
    public Response.BlockExtention getBlock(String blockIDOrNum, boolean detail) {
        GrpcAPI.BlockReq blockReq = GrpcAPI.BlockReq.newBuilder().setIdOrNum(blockIDOrNum).setDetail(detail).build();
        return this.blockingStub.getBlock(blockReq);
    }

    @Override
    public Response.BlockExtention getBlock() {
        GrpcAPI.BlockReq blockReq = GrpcAPI.BlockReq.newBuilder().setDetail(false).build();
        return this.blockingStub.getBlock(blockReq);
    }

    @Override
    public Chain.Block getBlockByIdOrNum(String blockIDOrNum) {
        if (Numeric.isNumericString(blockIDOrNum)) {
            GrpcAPI.NumberMessage numberMessage = GrpcAPI.NumberMessage.newBuilder().setNum(Long.parseLong(blockIDOrNum)).build();
            return this.blockingStub.getBlockByNum(numberMessage);
        }
        if (ByteArray.isHexString(blockIDOrNum)) {
            GrpcAPI.BytesMessage bytesMessage = GrpcAPI.BytesMessage.newBuilder().setValue(ApiWrapper.parseHex(blockIDOrNum)).build();
            return this.blockingStub.getBlockById(bytesMessage);
        }
        throw new IllegalArgumentException("Invalid blockIDOrNum: " + blockIDOrNum);
    }

    @Override
    public Response.SmartContractDataWrapper getContractInfo(String contractAddress) {
        ByteString rawAddress = ApiWrapper.parseAddress(contractAddress);
        GrpcAPI.BytesMessage param = GrpcAPI.BytesMessage.newBuilder().setValue(rawAddress).build();
        return this.blockingStub.getContractInfo(param);
    }

    @Override
    public Response.MarketOrderList getMarketOrderByAccount(String address) {
        ByteString rawAddress = ApiWrapper.parseAddress(address);
        GrpcAPI.BytesMessage param = GrpcAPI.BytesMessage.newBuilder().setValue(rawAddress).build();
        return this.blockingStub.getMarketOrderByAccount(param);
    }

    @Override
    public Response.MarketOrder getMarketOrderById(String txn) {
        ByteString rawAddress = ApiWrapper.parseHex(txn);
        GrpcAPI.BytesMessage param = GrpcAPI.BytesMessage.newBuilder().setValue(rawAddress).build();
        return this.blockingStub.getMarketOrderById(param);
    }

    @Override
    public Response.MarketOrderList getMarketOrderListByPair(String sellTokenId, String buyTokenId) {
        Response.MarketOrderPair param = Response.MarketOrderPair.newBuilder().setSellTokenId(ByteString.copyFrom((byte[])sellTokenId.getBytes())).setBuyTokenId(ByteString.copyFrom((byte[])buyTokenId.getBytes())).build();
        return this.blockingStub.getMarketOrderListByPair(param);
    }

    @Override
    public Response.MarketOrderPairList getMarketPairList() {
        return this.blockingStub.getMarketPairList(GrpcAPI.EmptyMessage.getDefaultInstance());
    }

    @Override
    public Response.MarketPriceList getMarketPriceByPair(String sellTokenId, String buyTokenId) {
        Response.MarketOrderPair param = Response.MarketOrderPair.newBuilder().setSellTokenId(ByteString.copyFrom((byte[])sellTokenId.getBytes())).setBuyTokenId(ByteString.copyFrom((byte[])buyTokenId.getBytes())).build();
        return this.blockingStub.getMarketPriceByPair(param);
    }

    @Override
    public Response.TransactionExtention exchangeCreate(String ownerAddress, String firstToken, long firstBalance, String secondToken, long secondBalance) throws IllegalException {
        Contract.ExchangeCreateContract exchangeCreateContract = Contract.ExchangeCreateContract.newBuilder().setOwnerAddress(ApiWrapper.parseAddress(ownerAddress)).setFirstTokenId(ByteString.copyFrom((byte[])firstToken.getBytes())).setFirstTokenBalance(firstBalance).setSecondTokenId(ByteString.copyFrom((byte[])secondToken.getBytes())).setSecondTokenBalance(secondBalance).build();
        return this.createTransactionExtention((Message)exchangeCreateContract, Chain.Transaction.Contract.ContractType.ExchangeCreateContract);
    }

    @Override
    public Response.TransactionExtention exchangeInject(String ownerAddress, long exchangeId, String tokenId, long amount) throws IllegalException {
        Contract.ExchangeInjectContract exchangeInjectContract = Contract.ExchangeInjectContract.newBuilder().setOwnerAddress(ApiWrapper.parseAddress(ownerAddress)).setExchangeId(exchangeId).setTokenId(ByteString.copyFrom((byte[])tokenId.getBytes())).setQuant(amount).build();
        return this.createTransactionExtention((Message)exchangeInjectContract, Chain.Transaction.Contract.ContractType.ExchangeInjectContract);
    }

    @Override
    public Response.TransactionExtention exchangeTransaction(String ownerAddress, long exchangeId, String tokenId, long amount, long expected) throws IllegalException {
        Contract.ExchangeTransactionContract exchangeTransactionContract = Contract.ExchangeTransactionContract.newBuilder().setOwnerAddress(ApiWrapper.parseAddress(ownerAddress)).setExchangeId(exchangeId).setTokenId(ByteString.copyFrom((byte[])tokenId.getBytes())).setQuant(amount).setExpected(exchangeId).build();
        return this.createTransactionExtention((Message)exchangeTransactionContract, Chain.Transaction.Contract.ContractType.ExchangeTransactionContract);
    }

    @Override
    public Response.TransactionExtention exchangeWithdraw(String ownerAddress, long exchangeId, String tokenId, long quant) throws IllegalException {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        Contract.ExchangeWithdrawContract exchangeWithdrawContract = Contract.ExchangeWithdrawContract.newBuilder().setOwnerAddress(rawOwner).setExchangeId(exchangeId).setTokenId(ByteString.copyFrom((byte[])tokenId.getBytes())).setQuant(quant).build();
        return this.createTransactionExtention((Message)exchangeWithdrawContract, Chain.Transaction.Contract.ContractType.ExchangeWithdrawContract);
    }

    @Override
    public long getTransactionCountByBlockNum(long blockNum) {
        GrpcAPI.NumberMessage message = GrpcAPI.NumberMessage.newBuilder().setNum(blockNum).build();
        return this.blockingStub.getTransactionCountByBlockNum(message).getNum();
    }

    @Override
    public Response.TransactionExtention marketCancelOrder(String ownerAddress, String orderId) throws IllegalException {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        ByteString rawOrderId = ApiWrapper.parseHex(orderId);
        Contract.MarketCancelOrderContract marketCancelOrderContract = Contract.MarketCancelOrderContract.newBuilder().setOwnerAddress(rawOwner).setOrderId(rawOrderId).build();
        return this.createTransactionExtention((Message)marketCancelOrderContract, Chain.Transaction.Contract.ContractType.MarketCancelOrderContract);
    }

    @Override
    public Response.TransactionExtention marketSellAsset(String ownerAddress, String sellTokenId, long sellTokenQuantity, String buyTokenId, long buyTokenQuantity) throws IllegalException {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        Contract.MarketSellAssetContract marketSellAssetContract = Contract.MarketSellAssetContract.newBuilder().setOwnerAddress(rawOwner).setSellTokenId(ByteString.copyFrom((byte[])sellTokenId.getBytes())).setSellTokenQuantity(sellTokenQuantity).setBuyTokenId(ByteString.copyFrom((byte[])buyTokenId.getBytes())).setBuyTokenQuantity(buyTokenQuantity).build();
        return this.createTransactionExtention((Message)marketSellAssetContract, Chain.Transaction.Contract.ContractType.MarketSellAssetContract);
    }

    @Override
    public Response.TransactionExtention updateEnergyLimit(String ownerAddress, String contractAddress, long originEnergyLimit) throws IllegalException {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        ByteString rawContract = ApiWrapper.parseAddress(contractAddress);
        Contract.UpdateEnergyLimitContract updateEnergyLimitContract = Contract.UpdateEnergyLimitContract.newBuilder().setOwnerAddress(rawOwner).setContractAddress(rawContract).setOriginEnergyLimit(originEnergyLimit).build();
        return this.createTransactionExtention((Message)updateEnergyLimitContract, Chain.Transaction.Contract.ContractType.UpdateEnergyLimitContract);
    }

    @Override
    public Response.TransactionExtention updateSetting(String ownerAddress, String contractAddress, long consumeUserResourcePercent) throws IllegalException {
        ByteString rawOwner = ApiWrapper.parseAddress(ownerAddress);
        ByteString rawContract = ApiWrapper.parseAddress(contractAddress);
        Contract.UpdateSettingContract updateSettingContract = Contract.UpdateSettingContract.newBuilder().setOwnerAddress(rawOwner).setContractAddress(rawContract).setConsumeUserResourcePercent(consumeUserResourcePercent).build();
        return this.createTransactionExtention((Message)updateSettingContract, Chain.Transaction.Contract.ContractType.UpdateSettingContract);
    }

    @Override
    public Contract.CreateSmartContract createSmartContract(String contractName, String address, String ABI2, String code2, long callValue, long consumeUserResourcePercent, long originEnergyLimit, long tokenValue, String tokenId) throws Exception {
        Common.SmartContract.ABI.Builder abiBuilder = Common.SmartContract.ABI.newBuilder();
        Contract.loadAbiFromJson(ABI2, abiBuilder);
        Common.SmartContract.ABI abi = abiBuilder.build();
        Common.SmartContract.Builder builder = Common.SmartContract.newBuilder().setName(contractName).setOriginAddress(ApiWrapper.parseAddress(address)).setAbi(abi).setConsumeUserResourcePercent(consumeUserResourcePercent).setOriginEnergyLimit(originEnergyLimit);
        if (callValue != 0L) {
            builder.setCallValue(callValue);
        }
        builder.setBytecode(ApiWrapper.parseHex(code2));
        Contract.CreateSmartContract.Builder createSmartContractBuilder = Contract.CreateSmartContract.newBuilder().setOwnerAddress(ApiWrapper.parseAddress(address)).setNewContract(builder.build());
        if (tokenId != null && !tokenId.equalsIgnoreCase("") && !tokenId.equalsIgnoreCase("#")) {
            createSmartContractBuilder.setCallTokenValue(tokenValue).setTokenId(Long.parseLong(tokenId));
        }
        return createSmartContractBuilder.build();
    }

    @Override
    public Contract.CreateSmartContract createSmartContract(String contractName, String address, String ABI2, String code2, long callValue, long consumeUserResourcePercent, long originEnergyLimit, long tokenValue, String tokenId, String libraryAddressPair, String compilerVersion) throws Exception {
        if (null != libraryAddressPair) {
            byte[] byteCode = Utils.replaceLibraryAddress(code2, libraryAddressPair, compilerVersion);
            code2 = ByteArray.toHexString(byteCode);
        }
        return this.createSmartContract(contractName, address, ABI2, code2, callValue, consumeUserResourcePercent, originEnergyLimit, tokenValue, tokenId);
    }

    @Override
    public String deployContract(String contractName, String abiStr, String bytecode, List<Type<?>> constructorParams, long feeLimit, long consumeUserResourcePercent, long originEnergyLimit, long callValue) throws Exception {
        if (constructorParams != null && !constructorParams.isEmpty()) {
            ByteString constructorParamsByteString = Utils.encodeParameter(constructorParams);
            ByteString newByteCode = ApiWrapper.parseHex(bytecode).concat(constructorParamsByteString);
            bytecode = ByteArray.toHexString(newByteCode.toByteArray());
        }
        Contract.CreateSmartContract createSmartContract = this.createSmartContract(contractName, this.keyPair.toBase58CheckAddress(), abiStr, bytecode, callValue, consumeUserResourcePercent, originEnergyLimit, 0L, null);
        TransactionBuilder txBuilder = new TransactionBuilder(this.blockingStub.deployContract(createSmartContract).getTransaction());
        txBuilder.setFeeLimit(feeLimit);
        Chain.Transaction transaction = this.signTransaction(txBuilder.getTransaction());
        return this.broadcastTransaction(transaction);
    }

    @Override
    public String deployContract(String name, String abiStr, String bytecode) throws Exception {
        return this.deployContract(name, abiStr, bytecode, null, 150000000L, 100L, 100000000L, 0L);
    }
}

