/*
 * Decompiled with CFR 0.152.
 */
package org.tron.trident.core.transaction;

import java.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.tron.trident.core.ApiWrapper;
import org.tron.trident.core.key.KeyPair;
import org.tron.trident.crypto.SECP256K1;
import org.tron.trident.crypto.tuwenitypes.Bytes;
import org.tron.trident.crypto.tuwenitypes.Bytes32;

public class SignatureValidator {
    public static boolean verify(byte[] txid, byte[] signature, byte[] owner) {
        SECP256K1.Signature sig = SECP256K1.Signature.decode(Bytes.wrap(signature));
        SECP256K1.PublicKey pubKey = SECP256K1.PublicKey.recoverFromSignature(Bytes32.wrap(txid), sig).get();
        byte[] addressFromPubKey = KeyPair.publicKeyToAddress(pubKey);
        return Arrays.equals(addressFromPubKey, owner);
    }

    public static boolean verify(String txid, String signature, String owner) {
        byte[] txidBytes = Hex.decode((String)txid);
        byte[] sig = Hex.decode((String)signature);
        byte[] ownerBytes = ApiWrapper.parseAddress(owner).toByteArray();
        return SignatureValidator.verify(txidBytes, sig, ownerBytes);
    }
}

