/*
 * Decompiled with CFR 0.152.
 */
package org.tron.trident.core.contract;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import org.tron.trident.abi.FunctionReturnDecoder;
import org.tron.trident.abi.TypeReference;
import org.tron.trident.abi.datatypes.Address;
import org.tron.trident.abi.datatypes.Bool;
import org.tron.trident.abi.datatypes.Function;
import org.tron.trident.abi.datatypes.Utf8String;
import org.tron.trident.abi.datatypes.generated.Uint256;
import org.tron.trident.abi.datatypes.generated.Uint8;
import org.tron.trident.core.ApiWrapper;
import org.tron.trident.core.contract.Contract;
import org.tron.trident.core.transaction.TransactionBuilder;
import org.tron.trident.proto.Chain;
import org.tron.trident.proto.Response;
import org.tron.trident.utils.Base58Check;
import org.tron.trident.utils.Numeric;

public class Trc20Contract
extends Contract {
    public Trc20Contract(Contract cntr, String ownerAddr, ApiWrapper wrapper) {
        super(cntr, ownerAddr, wrapper);
    }

    public String name() {
        Function name = new Function("name", Collections.emptyList(), Arrays.asList(new TypeReference<Utf8String>(){}));
        Response.TransactionExtention txnExt = this.wrapper.constantCall(Base58Check.bytesToBase58(this.ownerAddr.toByteArray()), Base58Check.bytesToBase58(this.cntrAddr.toByteArray()), name);
        String result = Numeric.toHexString(txnExt.getConstantResult(0).toByteArray());
        return (String)FunctionReturnDecoder.decode(result, name.getOutputParameters()).get(0).getValue();
    }

    public String symbol() {
        Function symbol = new Function("symbol", Collections.emptyList(), Arrays.asList(new TypeReference<Utf8String>(){}));
        Response.TransactionExtention txnExt = this.wrapper.constantCall(Base58Check.bytesToBase58(this.ownerAddr.toByteArray()), Base58Check.bytesToBase58(this.cntrAddr.toByteArray()), symbol);
        String result = Numeric.toHexString(txnExt.getConstantResult(0).toByteArray());
        return (String)FunctionReturnDecoder.decode(result, symbol.getOutputParameters()).get(0).getValue();
    }

    public BigInteger decimals() {
        Function decimals = new Function("decimals", Collections.emptyList(), Arrays.asList(new TypeReference<Uint8>(){}));
        Response.TransactionExtention txnExt = this.wrapper.constantCall(Base58Check.bytesToBase58(this.ownerAddr.toByteArray()), Base58Check.bytesToBase58(this.cntrAddr.toByteArray()), decimals);
        String result = Numeric.toHexString(txnExt.getConstantResult(0).toByteArray());
        return (BigInteger)FunctionReturnDecoder.decode(result, decimals.getOutputParameters()).get(0).getValue();
    }

    public BigInteger totalSupply() {
        Function totalSupply = new Function("totalSupply", Collections.emptyList(), Arrays.asList(new TypeReference<Uint256>(){}));
        Response.TransactionExtention txnExt = this.wrapper.constantCall(Base58Check.bytesToBase58(this.ownerAddr.toByteArray()), Base58Check.bytesToBase58(this.cntrAddr.toByteArray()), totalSupply);
        String result = Numeric.toHexString(txnExt.getConstantResult(0).toByteArray());
        return (BigInteger)FunctionReturnDecoder.decode(result, totalSupply.getOutputParameters()).get(0).getValue();
    }

    public BigInteger balanceOf(String accountAddr) {
        Function balanceOf = new Function("balanceOf", Arrays.asList(new Address(accountAddr)), Arrays.asList(new TypeReference<Uint256>(){}));
        Response.TransactionExtention txnExt = this.wrapper.constantCall(Base58Check.bytesToBase58(this.ownerAddr.toByteArray()), Base58Check.bytesToBase58(this.cntrAddr.toByteArray()), balanceOf);
        String result = Numeric.toHexString(txnExt.getConstantResult(0).toByteArray());
        return (BigInteger)FunctionReturnDecoder.decode(result, balanceOf.getOutputParameters()).get(0).getValue();
    }

    public String transfer(String destAddr, long amount, int power, String memo, long feeLimit) {
        Function transfer = new Function("transfer", Arrays.asList(new Address(destAddr), new Uint256(BigInteger.valueOf(amount).multiply(BigInteger.valueOf(10L).pow(power)))), Arrays.asList(new TypeReference<Bool>(){}));
        TransactionBuilder builder = this.wrapper.triggerCall(Base58Check.bytesToBase58(this.ownerAddr.toByteArray()), Base58Check.bytesToBase58(this.cntrAddr.toByteArray()), transfer);
        builder.setFeeLimit(feeLimit);
        builder.setMemo(memo);
        Chain.Transaction signedTxn = this.wrapper.signTransaction(builder.build());
        return this.wrapper.broadcastTransaction(signedTxn);
    }

    public String transferFrom(String fromAddr, String destAddr, long amount, int power, String memo, long feeLimit) {
        Function transferFrom = new Function("transferFrom", Arrays.asList(new Address(fromAddr), new Address(destAddr), new Uint256(BigInteger.valueOf(amount).multiply(BigInteger.valueOf(10L).pow(power)))), Arrays.asList(new TypeReference<Bool>(){}));
        TransactionBuilder builder = this.wrapper.triggerCall(Base58Check.bytesToBase58(this.ownerAddr.toByteArray()), Base58Check.bytesToBase58(this.cntrAddr.toByteArray()), transferFrom);
        builder.setFeeLimit(feeLimit);
        builder.setMemo(memo);
        Chain.Transaction signedTxn = this.wrapper.signTransaction(builder.build());
        return this.wrapper.broadcastTransaction(signedTxn);
    }

    public String approve(String spender, long amount, int power, String memo, long feeLimit) {
        Function approve = new Function("approve", Arrays.asList(new Address(spender), new Uint256(BigInteger.valueOf(amount).multiply(BigInteger.valueOf(10L).pow(power)))), Arrays.asList(new TypeReference<Bool>(){}));
        TransactionBuilder builder = this.wrapper.triggerCall(Base58Check.bytesToBase58(this.ownerAddr.toByteArray()), Base58Check.bytesToBase58(this.cntrAddr.toByteArray()), approve);
        builder.setFeeLimit(feeLimit);
        builder.setMemo(memo);
        Chain.Transaction signedTxn = this.wrapper.signTransaction(builder.build());
        return this.wrapper.broadcastTransaction(signedTxn);
    }

    public BigInteger allowance(String owner, String spender) {
        Function allowance = new Function("allowance", Arrays.asList(new Address(owner), new Address(spender)), Arrays.asList(new TypeReference<Uint256>(){}));
        Response.TransactionExtention txnExt = this.wrapper.constantCall(Base58Check.bytesToBase58(this.ownerAddr.toByteArray()), Base58Check.bytesToBase58(this.cntrAddr.toByteArray()), allowance);
        String result = Numeric.toHexString(txnExt.getConstantResult(0).toByteArray());
        return (BigInteger)FunctionReturnDecoder.decode(result, allowance.getOutputParameters()).get(0).getValue();
    }
}

