/*
 * Decompiled with CFR 0.152.
 */
package org.tron.trident.abi;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import org.tron.trident.abi.datatypes.Address;
import org.tron.trident.abi.datatypes.Array;
import org.tron.trident.abi.datatypes.Bool;
import org.tron.trident.abi.datatypes.Bytes;
import org.tron.trident.abi.datatypes.BytesType;
import org.tron.trident.abi.datatypes.DynamicArray;
import org.tron.trident.abi.datatypes.DynamicBytes;
import org.tron.trident.abi.datatypes.DynamicStruct;
import org.tron.trident.abi.datatypes.NumericType;
import org.tron.trident.abi.datatypes.StaticArray;
import org.tron.trident.abi.datatypes.Type;
import org.tron.trident.abi.datatypes.Ufixed;
import org.tron.trident.abi.datatypes.Uint;
import org.tron.trident.abi.datatypes.Utf8String;
import org.tron.trident.abi.datatypes.primitive.PrimitiveType;
import org.tron.trident.utils.Numeric;

public class TypeEncoder {
    private TypeEncoder() {
    }

    static boolean isDynamic(Type parameter) {
        return parameter instanceof DynamicBytes || parameter instanceof Utf8String || parameter instanceof DynamicArray;
    }

    public static String encode(Type parameter) {
        if (parameter instanceof NumericType) {
            return TypeEncoder.encodeNumeric((NumericType)parameter);
        }
        if (parameter instanceof Address) {
            return TypeEncoder.encodeAddress((Address)parameter);
        }
        if (parameter instanceof Bool) {
            return TypeEncoder.encodeBool((Bool)parameter);
        }
        if (parameter instanceof Bytes) {
            return TypeEncoder.encodeBytes((Bytes)parameter);
        }
        if (parameter instanceof DynamicBytes) {
            return TypeEncoder.encodeDynamicBytes((DynamicBytes)parameter);
        }
        if (parameter instanceof Utf8String) {
            return TypeEncoder.encodeString((Utf8String)parameter);
        }
        if (parameter instanceof StaticArray) {
            return TypeEncoder.encodeArrayValues((StaticArray)parameter);
        }
        if (parameter instanceof DynamicStruct) {
            return TypeEncoder.encodeDynamicStruct((DynamicStruct)parameter);
        }
        if (parameter instanceof DynamicArray) {
            return TypeEncoder.encodeDynamicArray((DynamicArray)parameter);
        }
        if (parameter instanceof PrimitiveType) {
            return TypeEncoder.encode(((PrimitiveType)parameter).toSolidityType());
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + parameter.getClass());
    }

    static String encodeAddress(Address address) {
        return TypeEncoder.encodeNumeric(address.toUint());
    }

    static String encodeNumeric(NumericType numericType) {
        byte[] rawValue = TypeEncoder.toByteArray(numericType);
        byte paddingValue = TypeEncoder.getPaddingValue(numericType);
        byte[] paddedRawValue = new byte[32];
        if (paddingValue != 0) {
            for (int i = 0; i < paddedRawValue.length; ++i) {
                paddedRawValue[i] = paddingValue;
            }
        }
        System.arraycopy(rawValue, 0, paddedRawValue, 32 - rawValue.length, rawValue.length);
        return Numeric.toHexStringNoPrefix(paddedRawValue);
    }

    private static byte getPaddingValue(NumericType numericType) {
        if (numericType.getValue().signum() == -1) {
            return -1;
        }
        return 0;
    }

    private static byte[] toByteArray(NumericType numericType) {
        BigInteger value = numericType.getValue();
        if ((numericType instanceof Ufixed || numericType instanceof Uint) && value.bitLength() == 256) {
            byte[] byteArray = new byte[32];
            System.arraycopy(value.toByteArray(), 1, byteArray, 0, 32);
            return byteArray;
        }
        return value.toByteArray();
    }

    static String encodeBool(Bool value) {
        byte[] rawValue = new byte[32];
        if (value.getValue().booleanValue()) {
            rawValue[rawValue.length - 1] = 1;
        }
        return Numeric.toHexStringNoPrefix(rawValue);
    }

    static String encodeBytes(BytesType bytesType) {
        byte[] dest;
        byte[] value = bytesType.getValue();
        int length = value.length;
        int mod = length % 32;
        if (mod != 0) {
            int padding = 32 - mod;
            dest = new byte[length + padding];
            System.arraycopy(value, 0, dest, 0, length);
        } else {
            dest = value;
        }
        return Numeric.toHexStringNoPrefix(dest);
    }

    static String encodeDynamicBytes(DynamicBytes dynamicBytes) {
        int size = dynamicBytes.getValue().length;
        String encodedLength = TypeEncoder.encode(new Uint(BigInteger.valueOf(size)));
        String encodedValue = TypeEncoder.encodeBytes(dynamicBytes);
        StringBuilder result = new StringBuilder();
        result.append(encodedLength);
        result.append(encodedValue);
        return result.toString();
    }

    static String encodeString(Utf8String string) {
        byte[] utfEncoded = string.getValue().getBytes(StandardCharsets.UTF_8);
        return TypeEncoder.encodeDynamicBytes(new DynamicBytes(utfEncoded));
    }

    static <T extends Type> String encodeArrayValues(Array<T> value) {
        StringBuilder result = new StringBuilder();
        Iterator iterator = value.getValue().iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            result.append(TypeEncoder.encode(type));
        }
        return result.toString();
    }

    static String encodeDynamicStruct(DynamicStruct value) {
        String encodedValues = TypeEncoder.encodeDynamicStructValues(value);
        StringBuilder result = new StringBuilder();
        result.append(encodedValues);
        return result.toString();
    }

    private static String encodeDynamicStructValues(DynamicStruct value) {
        int staticSize = 0;
        for (int i = 0; i < value.getValue().size(); ++i) {
            Type type = (Type)value.getValue().get(i);
            if (TypeEncoder.isDynamic(type)) {
                staticSize += 32;
                continue;
            }
            staticSize += type.bytes32PaddedLength();
        }
        int dynamicOffset = staticSize;
        ArrayList<String> offsetsAndStaticValues = new ArrayList<String>();
        ArrayList<String> dynamicValues = new ArrayList<String>();
        for (int i = 0; i < value.getValue().size(); ++i) {
            Type type = (Type)value.getValue().get(i);
            if (TypeEncoder.isDynamic(type)) {
                offsetsAndStaticValues.add(Numeric.toHexStringNoPrefix(Numeric.toBytesPadded(new BigInteger(Long.toString(dynamicOffset)), 32)));
                dynamicValues.add(TypeEncoder.encode(type));
                dynamicOffset += type.bytes32PaddedLength();
                continue;
            }
            offsetsAndStaticValues.add(TypeEncoder.encode((Type)value.getValue().get(i)));
        }
        ArrayList<String> data = new ArrayList<String>();
        data.addAll(offsetsAndStaticValues);
        data.addAll(dynamicValues);
        return String.join((CharSequence)"", data);
    }

    static <T extends Type> String encodeDynamicArray(DynamicArray<T> value) {
        int size = value.getValue().size();
        String encodedLength = TypeEncoder.encode(new Uint(BigInteger.valueOf(size)));
        String valuesOffsets = TypeEncoder.encodeArrayValuesOffsets(value);
        String encodedValues = TypeEncoder.encodeArrayValues(value);
        StringBuilder result = new StringBuilder();
        result.append(encodedLength);
        result.append(valuesOffsets);
        result.append(encodedValues);
        return result.toString();
    }

    private static <T extends Type> String encodeArrayValuesOffsets(DynamicArray<T> value) {
        boolean arrayOfString;
        StringBuilder result = new StringBuilder();
        boolean arrayOfBytes = !value.getValue().isEmpty() && value.getValue().get(0) instanceof DynamicBytes;
        boolean bl = arrayOfString = !value.getValue().isEmpty() && value.getValue().get(0) instanceof Utf8String;
        if (arrayOfBytes || arrayOfString) {
            long offset = 0L;
            for (int i = 0; i < value.getValue().size(); ++i) {
                if (i == 0) {
                    offset = value.getValue().size() * 32;
                } else {
                    int bytesLength = arrayOfBytes ? ((byte[])((Type)value.getValue().get(i - 1)).getValue()).length : ((String)((Type)value.getValue().get(i - 1)).getValue()).length();
                    int numberOfWords = (bytesLength + 32 - 1) / 32;
                    int totalBytesLength = numberOfWords * 32;
                    offset += (long)(totalBytesLength + 32);
                }
                result.append(Numeric.toHexStringNoPrefix(Numeric.toBytesPadded(new BigInteger(Long.toString(offset)), 32)));
            }
        }
        return result.toString();
    }
}

