/*
 * Decompiled with CFR 0.152.
 */
package org.mx.sm;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.mx.TypeUtils;
import org.mx.sm.SM3Digest;

public class SM2 {
    public static String[] ecc_param = new String[]{"FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0"};
    private final BigInteger ecc_p = new BigInteger(ecc_param[0], 16);
    private final BigInteger ecc_a = new BigInteger(ecc_param[1], 16);
    private final BigInteger ecc_b = new BigInteger(ecc_param[2], 16);
    private final BigInteger ecc_n = new BigInteger(ecc_param[3], 16);
    private final BigInteger ecc_gx = new BigInteger(ecc_param[4], 16);
    private final BigInteger ecc_gy = new BigInteger(ecc_param[5], 16);
    private final ECCurve ecc_curve;
    private final ECPoint ecc_point_g;
    private final ECDomainParameters ecc_bc_spec;
    private final ECKeyPairGenerator ecc_key_pair_generator;
    private final ECFieldElement ecc_gx_fieldelement = new ECFieldElement.Fp(this.ecc_p, this.ecc_gx);
    private final ECFieldElement ecc_gy_fieldelement = new ECFieldElement.Fp(this.ecc_p, this.ecc_gy);

    public SM2() {
        this.ecc_curve = new ECCurve.Fp(this.ecc_p, this.ecc_a, this.ecc_b);
        this.ecc_point_g = new ECPoint.Fp(this.ecc_curve, this.ecc_gx_fieldelement, this.ecc_gy_fieldelement);
        this.ecc_bc_spec = new ECDomainParameters(this.ecc_curve, this.ecc_point_g, this.ecc_n);
        ECKeyGenerationParameters ecc_ecgenparam = new ECKeyGenerationParameters(this.ecc_bc_spec, new SecureRandom());
        this.ecc_key_pair_generator = new ECKeyPairGenerator();
        this.ecc_key_pair_generator.init(ecc_ecgenparam);
    }

    public byte[] encrypt(byte[] publicKey, byte[] data) {
        if (publicKey == null || publicKey.length == 0) {
            return null;
        }
        if (data == null || data.length == 0) {
            return null;
        }
        byte[] source = new byte[data.length];
        System.arraycopy(data, 0, source, 0, data.length);
        Cipher cipher = new Cipher();
        ECPoint userKey = this.ecc_curve.decodePoint(publicKey);
        ECPoint c1 = cipher.initEncrypt(this, userKey);
        cipher.encrypt(source);
        byte[] c3 = new byte[32];
        cipher.dofinal(c3);
        byte[] c1b = c1.getEncoded();
        byte[] c2b = source;
        byte[] c3b = c3;
        byte[] out = new byte[c1b.length + c2b.length + c3b.length];
        System.arraycopy(c1b, 0, out, 0, c1b.length);
        System.arraycopy(c2b, 0, out, c1b.length, c2b.length);
        System.arraycopy(c3b, 0, out, c1b.length + c2b.length, c3b.length);
        return out;
    }

    public byte[] decrypt(byte[] privateKey, byte[] encryptedData) {
        if (privateKey == null || privateKey.length == 0) {
            return null;
        }
        if (encryptedData == null || encryptedData.length == 0) {
            return null;
        }
        String data = TypeUtils.byteArray2HexString(encryptedData);
        byte[] c1Bytes = TypeUtils.hexString2ByteArray(data.substring(0, 130));
        int c2Len = encryptedData.length - 97;
        byte[] c2 = TypeUtils.hexString2ByteArray(data.substring(130, 130 + 2 * c2Len));
        byte[] c3 = TypeUtils.hexString2ByteArray(data.substring(130 + 2 * c2Len, 194 + 2 * c2Len));
        BigInteger userD = new BigInteger(1, privateKey);
        ECPoint c1 = this.ecc_curve.decodePoint(c1Bytes);
        Cipher cipher = new Cipher();
        cipher.initDecrypt(userD, c1);
        cipher.decrypt(c2);
        cipher.dofinal(c3);
        return c2;
    }

    public static SM2KeyPair generateKeyPair() {
        SM2 sm2 = new SM2();
        AsymmetricCipherKeyPair key = sm2.ecc_key_pair_generator.generateKeyPair();
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
        return new SM2KeyPair(ecpriv.getD(), ecpub.getQ());
    }

    private class Cipher {
        private int ct = 1;
        private ECPoint p2;
        private SM3Digest sm3keybase;
        private SM3Digest sm3c3;
        private byte[] key = new byte[32];
        private byte keyOff = 0;

        private void reset() {
            this.sm3keybase = new SM3Digest();
            this.sm3c3 = new SM3Digest();
            byte[] p = TypeUtils.bigint2ByteArray(this.p2.getX().toBigInteger());
            this.sm3keybase.update(p, 0, p.length);
            this.sm3c3.update(p, 0, p.length);
            p = TypeUtils.bigint2ByteArray(this.p2.getY().toBigInteger());
            this.sm3keybase.update(p, 0, p.length);
            this.ct = 1;
            this.nextKey();
        }

        private void nextKey() {
            SM3Digest sm3keycur = new SM3Digest(this.sm3keybase);
            sm3keycur.update((byte)(this.ct >> 24 & 0xFF));
            sm3keycur.update((byte)(this.ct >> 16 & 0xFF));
            sm3keycur.update((byte)(this.ct >> 8 & 0xFF));
            sm3keycur.update((byte)(this.ct & 0xFF));
            sm3keycur.doFinal(this.key, 0);
            this.keyOff = 0;
            ++this.ct;
        }

        public ECPoint initEncrypt(SM2 sm2, ECPoint userKey) {
            AsymmetricCipherKeyPair key = sm2.ecc_key_pair_generator.generateKeyPair();
            ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
            ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
            BigInteger k = ecpriv.getD();
            ECPoint c1 = ecpub.getQ();
            this.p2 = userKey.multiply(k);
            this.reset();
            return c1;
        }

        public void encrypt(byte[] data) {
            this.sm3c3.update(data, 0, data.length);
            int i = 0;
            while (i < data.length) {
                if (this.keyOff == this.key.length) {
                    this.nextKey();
                }
                int n = i++;
                byte by = this.keyOff;
                this.keyOff = (byte)(by + 1);
                data[n] = (byte)(data[n] ^ this.key[by]);
            }
        }

        public void initDecrypt(BigInteger userD, ECPoint c1) {
            this.p2 = c1.multiply(userD);
            this.reset();
        }

        public void decrypt(byte[] data) {
            int i = 0;
            while (i < data.length) {
                if (this.keyOff == this.key.length) {
                    this.nextKey();
                }
                int n = i++;
                byte by = this.keyOff;
                this.keyOff = (byte)(by + 1);
                data[n] = (byte)(data[n] ^ this.key[by]);
            }
            this.sm3c3.update(data, 0, data.length);
        }

        public void dofinal(byte[] c3) {
            byte[] p = TypeUtils.bigint2ByteArray(this.p2.getY().toBigInteger());
            this.sm3c3.update(p, 0, p.length);
            this.sm3c3.doFinal(c3, 0);
            this.reset();
        }
    }

    public static class SM2KeyPair {
        private BigInteger privateKey;
        private ECPoint publicKey;

        public SM2KeyPair(BigInteger privateKey, ECPoint publicKey) {
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        }

        public BigInteger getPrivateKey() {
            return this.privateKey;
        }

        public ECPoint getPublicKey() {
            return this.publicKey;
        }
    }
}

