/*
 * Decompiled with CFR 0.152.
 */
package org.mx.rate;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneralTopNRate<T> {
    private static final Logger logger = LoggerFactory.getLogger(GeneralTopNRate.class);
    private long lastCleanTime = 0L;
    private long startTime = 0L;
    private int N = 300;
    private T total = null;
    private Map<Long, T> topNNumbers = null;
    private ValueType valueType = ValueType.Integer;

    public GeneralTopNRate() {
        this(300, 1.0);
    }

    public GeneralTopNRate(int N) {
        this(N, 1.0);
    }

    public GeneralTopNRate(int N, double scale) {
        this.N = N;
        if (scale <= 0.0) {
            scale = 1.0;
        }
        if (scale < 0.01) {
            scale = 0.01;
        }
        int size = (int)((double)this.N / scale);
        this.topNNumbers = new HashMap<Long, T>(size);
        this.startTime = System.currentTimeMillis();
        this.lastCleanTime = System.currentTimeMillis();
        Type gt = this.getClass().getGenericSuperclass();
        if (ParameterizedType.class.isAssignableFrom(gt.getClass())) {
            Type t = ((ParameterizedType)gt).getActualTypeArguments()[0];
            String typeName = t.getTypeName();
            if (Float.class.getName().equalsIgnoreCase(typeName)) {
                this.valueType = ValueType.Float;
            } else if (Double.class.getName().equalsIgnoreCase(typeName)) {
                this.valueType = ValueType.Double;
            } else if (Integer.class.getName().equalsIgnoreCase(typeName)) {
                this.valueType = ValueType.Integer;
            } else if (Long.class.getName().equalsIgnoreCase(typeName)) {
                this.valueType = ValueType.Long;
            } else {
                throw new UnsupportedOperationException("This operate only support Int | Long | Float | Double data types.");
            }
        }
    }

    private long doClean() {
        int right;
        long time = System.currentTimeMillis();
        int left1 = (int)(time - this.lastCleanTime);
        if (left1 > (right = this.N * 1000 + 300)) {
            Long[] keys;
            Long[] longArray = keys = this.topNNumbers.keySet().toArray(new Long[0]);
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long key = longArray[i];
                int left2 = (int)(time - key);
                if (left2 < right) continue;
                this.topNNumbers.remove(key);
            }
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("doClean: removed=%d, totalSize=%d, current=%d, last=%d.", keys.length, this.topNNumbers.size(), time, this.lastCleanTime));
            }
            this.lastCleanTime = time;
        }
        return time;
    }

    protected abstract T add(T var1, T var2);

    public void addNumber(T t) {
        long time = this.doClean();
        this.total = this.add(this.total, t);
        T num = this.add(this.topNNumbers.get(time), t);
        this.topNNumbers.put(time, num);
    }

    public int getN() {
        return this.N;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public T getTotal() {
        return this.total;
    }

    public double getTotalRate() {
        return this.getTopNRate(-1);
    }

    public double getTopNRate(int lastSeconds) {
        int last;
        long time = this.doClean();
        Object num = null;
        long l = time - this.startTime;
        int n = last = l % 1000L == 0L ? (int)(l / 1000L) : (int)(l / 1000L) + 1;
        if (lastSeconds == -1 || lastSeconds > this.N) {
            num = this.total;
            lastSeconds = lastSeconds == -1 ? Integer.MAX_VALUE : lastSeconds;
        } else {
            int count = lastSeconds * 1000;
            for (Long key : this.topNNumbers.keySet()) {
                if (time - key > (long)count) continue;
                T t = this.topNNumbers.get(key);
                num = this.add(num, t);
            }
        }
        lastSeconds = Math.min(lastSeconds, last);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("num=%d, total=%s, time=%d, start=%d, last=%d - %d.", lastSeconds, num == null ? "" : num.toString(), time, this.startTime, (time - this.startTime) / 1000L, time - this.startTime));
        }
        return this.getRate(num, lastSeconds);
    }

    protected abstract double getRate(T var1, int var2);

    public void reset() {
        this.total = null;
        this.topNNumbers.clear();
        this.startTime = System.currentTimeMillis();
        this.lastCleanTime = System.currentTimeMillis();
    }

    public static enum ValueType {
        Integer,
        Long,
        Float,
        Double;

    }
}

