/*
 * Decompiled with CFR 0.152.
 */
package org.mx.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.mx.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SystemConfig.class);
    private static SystemConfig config = null;
    private ConcurrentHashMap<String, String> map = new ConcurrentHashMap();

    private SystemConfig() {
    }

    public static SystemConfig instance() {
        if (config == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The ApplicationConfig not instance, will instance it.");
            }
            config = new SystemConfig();
        }
        return config;
    }

    public void clean() {
        this.map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String file) throws IOException {
        if (StringUtils.isBlank(file)) {
            throw new IOException("The file path and name is blank.");
        }
        ConfigFileMetaData meta = new ConfigFileMetaData(file);
        try (InputStream in = meta.isFromFile ? new FileInputStream(meta.file) : SystemConfig.class.getResourceAsStream(file);){
            this.load(in, meta.type);
        }
    }

    public void load(InputStream in, ConfigFileType type) throws IOException {
        Properties properties = new Properties();
        if (type == ConfigFileType.Properties) {
            properties.load(in);
        } else if (type == ConfigFileType.XML) {
            properties.loadFromXML(in);
        } else {
            throw new IOException(String.format("Not supported config file type: %s.", type.name()));
        }
        for (String key : properties.stringPropertyNames()) {
            this.map.put(key, properties.getProperty(key));
        }
    }

    public String getValue(String key) {
        return this.map.get(key);
    }

    public void setValue(String key, Object value) {
        this.map.put(key, String.valueOf(value));
    }

    private class ConfigFileMetaData {
        String file;
        boolean isFromFile;
        ConfigFileType type;

        ConfigFileMetaData(String filePath) throws IOException {
            String tar = filePath.toLowerCase();
            String[] flag = new String[]{"classpath:", "file:"};
            if (tar.startsWith(flag[0])) {
                this.isFromFile = false;
                this.file = filePath.substring(flag[0].length());
            } else if (tar.startsWith(flag[1])) {
                this.isFromFile = true;
                this.file = filePath.substring(flag[1].length());
            }
            if (tar.endsWith(".properties")) {
                this.type = ConfigFileType.Properties;
            } else if (tar.endsWith(".xml")) {
                this.type = ConfigFileType.XML;
            }
            throw new IOException(String.format("Not supported config file type: %s.", filePath));
        }
    }

    private static enum ConfigFileType {
        Properties,
        XML;

    }
}

