/*
 * Decompiled with CFR 0.152.
 */
package org.mx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import java.util.function.Function;
import org.mx.StringUtils;
import org.mx.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemUtils {
    private static final Logger logger = LoggerFactory.getLogger(SystemUtils.class);

    private SystemUtils() {
    }

    public static SystemType getType() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("windows")) {
            return SystemType.Windows;
        }
        if (osName.startsWith("linux")) {
            return SystemType.Linux;
        }
        if (osName.startsWith("mac")) {
            return SystemType.Mac;
        }
        return SystemType.Other;
    }

    public static String getJvmPid() {
        return SystemUtils.getSystemStat(SystemUtils.jvmPid());
    }

    public static float getCpuRate(String identity) {
        return SystemUtils.getSystemStat(SystemUtils.cpuRate(identity)).floatValue();
    }

    public static int getThreads() {
        return SystemUtils.getSystemStat(SystemUtils.threads());
    }

    public static float getMemoryRate() {
        return SystemUtils.getSystemStat(SystemUtils.memory()).floatValue();
    }

    private static <Void, R> R getSystemStat(Function<Void, R> function) {
        return function.apply(null);
    }

    private static Function<Void, String> jvmPid() {
        return avoid -> ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    private static Function<Void, Float> cpuRate(String identity) {
        SystemType type = SystemUtils.getType();
        switch (type) {
            case Windows: {
                return aVoid -> {
                    String command = String.format("%s\\system32\\wbem\\wmic.exe process get Caption,CommandLine,KernelModeTime,UserModeTime", System.getenv("windir"));
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Command: %s", command));
                    }
                    try {
                        Process process = Runtime.getRuntime().exec(new String[]{"CMD", "/C", command});
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        Object[] lines = bufferedReader.lines().toArray();
                        long myTime = 0L;
                        long totalTime = 0L;
                        if (lines.length > 0) {
                            String line = (String)lines[0];
                            int[] pos = new int[]{line.indexOf("Caption"), line.indexOf("CommandLine"), line.indexOf("KernelModeTime"), line.indexOf("UserModeTime")};
                            for (int index = 1; index < lines.length; ++index) {
                                line = (String)lines[index];
                                if (StringUtils.isBlank(line)) continue;
                                String caption = line.substring(pos[0], pos[1]).trim();
                                String commandLine = line.substring(pos[1], pos[2]).trim();
                                long kernelTime = Long.valueOf(line.substring(pos[2], pos[3]).trim().replaceAll(" ", ""));
                                long userTime = Long.valueOf(line.substring(pos[3]).trim().replaceAll(" ", ""));
                                totalTime += kernelTime + userTime;
                                if (!caption.contains(identity) && !commandLine.contains(identity)) continue;
                                myTime = kernelTime + userTime;
                            }
                        }
                        if (totalTime <= 0L) {
                            totalTime = 1L;
                        }
                        return Float.valueOf((float)myTime / (float)totalTime);
                    }
                    catch (IOException ex) {
                        if (logger.isErrorEnabled()) {
                            logger.error(String.format("Invoke command[%s] fail.", command), (Throwable)ex);
                        }
                        return Float.valueOf(0.0f);
                    }
                };
            }
            case Linux: 
            case Mac: {
                return avoid -> {
                    String command = String.format("ps ux -p %s | awk '{print $3}'", SystemUtils.getSystemStat(SystemUtils.jvmPid()));
                    try {
                        Process process = Runtime.getRuntime().exec(new String[]{"sh", "-c", command});
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        bufferedReader.readLine();
                        String line = bufferedReader.readLine();
                        return Float.valueOf(line);
                    }
                    catch (IOException ex) {
                        if (logger.isErrorEnabled()) {
                            logger.error(String.format("Invoke command[%s] fail.", command), (Throwable)ex);
                        }
                        return Float.valueOf(0.0f);
                    }
                };
            }
        }
        return null;
    }

    private static Function<Void, Integer> threads() {
        return aVoid -> {
            ThreadGroup parentThread = Thread.currentThread().getThreadGroup();
            while (parentThread.getParent() != null) {
                parentThread = parentThread.getParent();
            }
            return parentThread.activeCount();
        };
    }

    private static Function<Void, Float> memory() {
        SystemType type = SystemUtils.getType();
        switch (type) {
            case Windows: {
                return aVoid -> {
                    String command = String.format("TASKLIST /NH /FO CSV /FI \"PID EQ %s\"", SystemUtils.getSystemStat(SystemUtils.jvmPid()));
                    try {
                        Process process = Runtime.getRuntime().exec(command);
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        List<String> segs = TypeUtils.csv2List(bufferedReader.readLine());
                        String memoryStr = segs.get(4).replaceAll("[, \"]", "");
                        long memory = TypeUtils.string2Size(memoryStr, 0L);
                        List<MemoryPoolMXBean> memoryPoolMxBeans = ManagementFactory.getMemoryPoolMXBeans();
                        int total = 0;
                        for (MemoryPoolMXBean bean : memoryPoolMxBeans) {
                            total = (int)((long)total + bean.getCollectionUsage().getMax());
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.format("Memory fetch, seg: %s, memory: %d, total: %d.", segs.get(4), memory, total));
                        }
                        return Float.valueOf((float)memory / (float)(total == 0 ? 1 : total));
                    }
                    catch (IOException ex) {
                        if (logger.isErrorEnabled()) {
                            logger.error(String.format("Invoke the command[%s] fail.", ex));
                        }
                        return Float.valueOf(0.0f);
                    }
                };
            }
            case Linux: 
            case Mac: {
                return aVoid -> {
                    String command = type == SystemType.Mac ? String.format("ps u -p %s | awk '{print $4}'", SystemUtils.getSystemStat(SystemUtils.jvmPid())) : String.format("ps u -p %s | awk '{print $3}'", SystemUtils.getSystemStat(SystemUtils.jvmPid()));
                    try {
                        Process process = Runtime.getRuntime().exec(new String[]{"sh", "-c", command});
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        bufferedReader.readLine();
                        return Float.valueOf(bufferedReader.readLine());
                    }
                    catch (IOException ex) {
                        if (logger.isErrorEnabled()) {
                            logger.error(String.format("Invoke the command[%s] fail", command), (Throwable)ex);
                        }
                        return Float.valueOf(0.0f);
                    }
                };
            }
        }
        if (logger.isErrorEnabled()) {
            logger.error(String.format("Unsupported type: %s.", new Object[]{type}));
        }
        return null;
    }

    public static enum SystemType {
        Windows,
        Linux,
        Mac,
        Other;

    }
}

