/*
 * Decompiled with CFR 0.152.
 */
package org.mx;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.mx.sm.SM4;
import org.mx.sm.SM4Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretUtils {
    private static Logger logger = LoggerFactory.getLogger(SecretUtils.class);

    private SecretUtils() {
    }

    public static byte[] des56Encrypt(String password, byte[] src) {
        return SecretUtils.secretCrypt("DES", 56, true, password, src);
    }

    public static byte[] des56Decrypt(String password, byte[] src) {
        return SecretUtils.secretCrypt("DES", 56, false, password, src);
    }

    public static byte[] desede112Encrypt(String password, byte[] src) {
        return SecretUtils.secretCrypt("DESede", 112, true, password, src);
    }

    public static byte[] desede112Decrypt(String password, byte[] src) {
        return SecretUtils.secretCrypt("DESede", 112, false, password, src);
    }

    public static byte[] desede168Encrypt(String password, byte[] src) {
        return SecretUtils.secretCrypt("DESede", 168, true, password, src);
    }

    public static byte[] desede168Decrypt(String password, byte[] src) {
        return SecretUtils.secretCrypt("DESede", 168, false, password, src);
    }

    public static byte[] aes192Encrypt(String password, byte[] src) {
        return SecretUtils.secretCrypt("AES", 192, true, password, src);
    }

    public static byte[] aes192Decrypt(String password, byte[] src) {
        return SecretUtils.secretCrypt("AES", 192, false, password, src);
    }

    public static byte[] aes256Encrypt(String password, byte[] src) {
        return SecretUtils.secretCrypt("AES", 256, true, password, src);
    }

    public static byte[] aes256Decrypt(String password, byte[] src) {
        return SecretUtils.secretCrypt("AES", 256, false, password, src);
    }

    private static SecretKey generateSecretKey(String algorithm, int keySize, String password) throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance(algorithm);
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(password.getBytes());
        keyGen.init(keySize, random);
        return keyGen.generateKey();
    }

    private static byte[] secretCrypt(String algorithm, int keySize, boolean encrypted, String password, byte[] src) {
        Cipher cipher;
        SecretKey skey;
        try {
            skey = SecretUtils.generateSecretKey(algorithm, keySize, password);
        }
        catch (NoSuchAlgorithmException ex) {
            if (logger.isErrorEnabled()) {
                logger.error(String.format("Unsupported algorithm: %s.", algorithm), (Throwable)ex);
            }
            return null;
        }
        try {
            cipher = Cipher.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException ex) {
            if (logger.isErrorEnabled()) {
                logger.error(String.format("Unsupported algorithm: %s.", algorithm), (Throwable)ex);
            }
            return null;
        }
        try {
            cipher.init(encrypted ? 1 : 2, skey);
        }
        catch (InvalidKeyException ex) {
            if (logger.isErrorEnabled()) {
                logger.error(String.format("Invalide key: %s.", password), (Throwable)ex);
            }
            return null;
        }
        try {
            return cipher.doFinal(src);
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            if (logger.isErrorEnabled()) {
                logger.error(String.format("%s the data fail, key: %s.", encrypted ? "Encrypt" : "Decrypt", password), (Throwable)ex);
            }
            return null;
        }
    }

    public static byte[] sm4EncryptECB(String secretKey, byte[] src) {
        try {
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            return sm4.sm4_crypt_ecb(ctx, src);
        }
        catch (Throwable ex) {
            if (logger.isErrorEnabled()) {
                logger.error("Encrypt any data by SM4(ECB) fail.", ex);
            }
            return null;
        }
    }

    public static byte[] sm4DecryptECB(String secretKey, byte[] src) {
        try {
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            return sm4.sm4_crypt_ecb(ctx, src);
        }
        catch (Throwable ex) {
            if (logger.isErrorEnabled()) {
                logger.error("Decrypt any data by SM4(ECB) fail.", ex);
            }
            return null;
        }
    }

    public static byte[] sm4EncryptCBC(String secretKey, String ivKey, byte[] src) {
        try {
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = secretKey.getBytes();
            byte[] ivBytes = ivKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            return sm4.sm4_crypt_cbc(ctx, ivBytes, src);
        }
        catch (Throwable ex) {
            if (logger.isErrorEnabled()) {
                logger.error("Encrypt any data by SM4(CBC) fail.", ex);
            }
            return null;
        }
    }

    public static byte[] sm4DecryptCBC(String secretKey, String ivKey, byte[] src) {
        try {
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = secretKey.getBytes();
            byte[] ivBytes = ivKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            return sm4.sm4_crypt_cbc(ctx, ivBytes, src);
        }
        catch (Throwable ex) {
            if (logger.isErrorEnabled()) {
                logger.error("Decrypt any data by SM4(CBC) fail.", ex);
            }
            return null;
        }
    }
}

