/*
 * Decompiled with CFR 0.152.
 */
package org.mx;

import org.mx.DigestUtils;
import org.mx.SecretUtils;
import org.mx.StringUtils;

public class PasswordUtils {
    private PasswordUtils() {
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("PasswordUtils <Operate> <Algorithm> <text>");
            System.out.println("  Operate: encrypt | decrypt");
            System.out.println("  Algorithm: sm4 | des | 3des | aes");
            System.exit(0);
        }
        String password = "Edmund!@#123)(*0";
        String value = "";
        boolean encrypt = args[0].equalsIgnoreCase("encrypt");
        switch (args[1]) {
            case "sm4": {
                if (encrypt) {
                    byte[] buff = SecretUtils.sm4EncryptECB(password, args[2].getBytes());
                    value = DigestUtils.toBase64(buff);
                    break;
                }
                byte[] buff = DigestUtils.fromBase64(args[2]);
                buff = SecretUtils.sm4DecryptECB(password, buff);
                value = new String(buff);
                break;
            }
            case "des": {
                if (encrypt) {
                    byte[] buff = SecretUtils.des56Encrypt(password, args[2].getBytes());
                    value = DigestUtils.toBase64(buff);
                    break;
                }
                byte[] buff = DigestUtils.fromBase64(args[2]);
                buff = SecretUtils.des56Decrypt(password, buff);
                value = new String(buff);
                break;
            }
            case "3des": {
                if (encrypt) {
                    byte[] buff = SecretUtils.desede168Encrypt(password, args[2].getBytes());
                    value = DigestUtils.toBase64(buff);
                    break;
                }
                byte[] buff = DigestUtils.fromBase64(args[2]);
                buff = SecretUtils.desede168Decrypt(password, buff);
                value = new String(buff);
                break;
            }
            case "aes": {
                if (encrypt) {
                    byte[] buff = SecretUtils.aes256Encrypt(password, args[2].getBytes());
                    value = DigestUtils.toBase64(buff);
                    break;
                }
                byte[] buff = DigestUtils.fromBase64(args[2]);
                buff = SecretUtils.aes256Decrypt(password, buff);
                value = new String(buff);
                break;
            }
            default: {
                System.out.println(String.format("Unsupported algorithm: %s.", args[1]));
                System.exit(0);
            }
        }
        System.out.println(String.format("source: %s\ntarget: %s", args[2], value));
    }

    public static PasswordStrengthen checkStrengthen(String password) {
        if (StringUtils.isBlank(password)) {
            return PasswordStrengthen.LOW;
        }
        int length = password.length();
        int containTypes = 0;
        if (length > 6) {
            if (password.matches(".*[\\d]+.*")) {
                ++containTypes;
            }
            if (password.matches(".*[a-z]+.*")) {
                ++containTypes;
            }
            if (password.matches(".*[A-Z]+.*")) {
                ++containTypes;
            }
            if (password.matches(".*[`~!@#$%^&()\\-=_+,./<>?'|{}\\[\\]\\\\]+.*")) {
                ++containTypes;
            }
        }
        switch (containTypes) {
            case 4: {
                return PasswordStrengthen.HIGHER;
            }
            case 3: {
                return PasswordStrengthen.HIGH;
            }
            case 2: {
                return PasswordStrengthen.MEDIUM;
            }
        }
        return PasswordStrengthen.LOW;
    }

    public static enum PasswordStrengthen {
        LOW,
        MEDIUM,
        HIGH,
        HIGHER;

    }
}

